/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.animations.implementations;

import java.util.Collection;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.skills.skills.implementations.ArcherySkill;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ChargedShotAmmo
extends Animation {
    private static final Particle ammo;
    private static final Particle.DustOptions ammoOptions;
    private static final double cP;
    private static final double sP;
    private static final double cY;
    private static final double sY;
    private static final double cR;
    private static final double sR;

    public ChargedShotAmmo(String id) {
        super(id);
    }

    @Override
    public void animate(LivingEntity entity, Location location, Vector direction, int tick) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            new AmmoAnimation(p, ArcherySkill.getChargedShotCharges(p.getUniqueId())).runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
        }
    }

    static {
        YamlConfiguration config = ConfigManager.getConfig("skills/archery.yml").get();
        ammo = Catch.catchOrElse(() -> Particle.valueOf((String)config.getString("charged_shot_ammo_particle")), null, "Invalid charged shot ammo particle given in skills/archery.yml charged_shot_ammo_particle");
        ammoOptions = new Particle.DustOptions(Utils.hexToRgb(config.getString("charged_shot_ammo_rgb", "#ffffff")), 0.5f);
        cP = MathUtils.cos(MathUtils.toRadians(0.0));
        sP = MathUtils.sin(MathUtils.toRadians(0.0));
        cY = MathUtils.cos(MathUtils.toRadians(2.0));
        sY = MathUtils.sin(MathUtils.toRadians(2.0));
        cR = MathUtils.cos(MathUtils.toRadians(0.0));
        sR = MathUtils.sin(MathUtils.toRadians(0.0));
    }

    private static class AmmoAnimation
    extends BukkitRunnable {
        private final Player p;
        private Collection<Location> circle;
        private int charges;
        private final Location normalizedLocation;

        public AmmoAnimation(Player p, int charges) {
            this.p = p;
            this.charges = charges;
            this.normalizedLocation = new Location(p.getWorld(), 0.0, 0.0, 0.0);
            this.circle = MathUtils.getEvenCircle(this.normalizedLocation, 0.75, charges, 0.0);
        }

        public void run() {
            int remainingCharges = ArcherySkill.getChargedShotCharges(this.p.getUniqueId());
            if (!this.p.isValid() || !this.p.isOnline() || remainingCharges <= 0) {
                this.cancel();
                return;
            }
            for (Location l : this.circle) {
                if (l.getWorld() == null || !l.getWorld().equals((Object)this.p.getWorld())) {
                    l.setWorld(this.p.getWorld());
                }
                if (ammo == Utils.DUST) {
                    this.p.getWorld().spawnParticle(ammo, l.clone().add(this.p.getLocation()).add(0.0, 0.8, 0.0), 0, (Object)ammoOptions);
                    continue;
                }
                this.p.getWorld().spawnParticle(ammo, l.clone().add(this.p.getLocation()).add(0.0, 0.8, 0.0), 0);
            }
            if (remainingCharges != this.charges) {
                this.charges = remainingCharges;
                this.circle = MathUtils.getEvenCircle(this.normalizedLocation, 0.75, this.charges, 0.0);
            }
            MathUtils.transformExistingPointsPredefined(this.normalizedLocation, cP, sP, cY, sY, cR, sR, 1.0, this.circle);
        }
    }
}

