/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.animations.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class DrillingActive
extends Animation {
    private static final Particle particle;
    private static final Particle.DustOptions options;
    private static final String drillingOff;
    private static final Sound drillingActiveSound;

    public DrillingActive(String id) {
        super(id);
    }

    @Override
    public void animate(LivingEntity entity, Location location, Vector direction, int tick) {
        AccumulativeStatManager.uncache((Entity)entity);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (particle != null) {
                new DrillingAnimation(p).runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
            }
        }
    }

    static {
        YamlConfiguration config = ConfigManager.getConfig("skills/mining.yml").get();
        particle = Catch.catchOrElse(() -> Particle.valueOf((String)config.getString("drilling_effect_particle")), null);
        options = new Particle.DustOptions(Utils.hexToRgb(config.getString("drilling_effect_color", "#ffffff")), 0.5f);
        drillingOff = TranslationManager.translatePlaceholders(config.getString("drilling_toggle_off"));
        drillingActiveSound = Utils.getSound(config.getString("drilling_active_sound"), null, null);
    }

    private static class DrillingAnimation
    extends BukkitRunnable {
        private final Player p;

        public DrillingAnimation(Player p) {
            this.p = p;
        }

        public void run() {
            RayTraceResult result;
            if (!this.p.isValid() || !this.p.isOnline() || Timer.isCooldownPassed(this.p.getUniqueId(), "mining_drilling_duration") || ItemUtils.isEmpty(this.p.getInventory().getItemInMainHand()) || !this.p.getInventory().getItemInMainHand().getType().toString().endsWith("_PICKAXE")) {
                this.cancel();
                Utils.sendActionBar(this.p, drillingOff);
                AccumulativeStatManager.uncacheStat((Entity)this.p, "BLOCK_SPECIFIC_DIG_SPEED");
                Timer.setCooldown(this.p.getUniqueId(), 0, "mining_drilling_duration");
            }
            if ((result = this.p.rayTraceBlocks(5.0, FluidCollisionMode.NEVER)) == null) {
                return;
            }
            Block hit = result.getHitBlock();
            if (hit == null) {
                return;
            }
            if (particle == Particle.valueOf((String)Utils.oldOrNew("REDSTONE", "DUST"))) {
                this.p.spawnParticle(particle, result.getHitPosition().toLocation(this.p.getWorld()), 0, (Object)options);
            } else if (particle == Particle.valueOf((String)Utils.oldOrNew("BLOCK_DUST", "BLOCK"))) {
                this.p.spawnParticle(particle, result.getHitPosition().toLocation(this.p.getWorld()), 0, (Object)hit.getBlockData());
            } else {
                this.p.spawnParticle(particle, result.getHitPosition().toLocation(this.p.getWorld()), 0);
            }
            this.p.playSound((Entity)this.p, drillingActiveSound, 0.1f, 1.0f);
        }
    }
}

