/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.block;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;

public class BlockInteractConversions {
    private static final Map<String, Conversion> conversions = new HashMap<String, Conversion>();
    private static final Map<Material, Map<Material, Collection<Conversion>>> conversionsByBlock = new HashMap<Material, Map<Material, Collection<Conversion>>>();

    public static Map<Material, Map<Material, Collection<Conversion>>> getConversionsByBlock() {
        return conversionsByBlock;
    }

    public static Map<String, Conversion> getConversions() {
        return conversions;
    }

    public static void loadConversions() {
        YamlConfiguration config = ConfigManager.getConfig("block_conversions.yml").reload().get();
        ConfigurationSection conversionSection = config.getConfigurationSection("conversions");
        if (conversionSection != null) {
            for (String name : conversionSection.getKeys(false)) {
                Material from = Catch.catchOrElse(() -> Material.valueOf((String)config.getString("conversions." + name + ".from")), null);
                Material to = Catch.catchOrElse(() -> Material.valueOf((String)config.getString("conversions." + name + ".to")), null);
                if (from == null || to == null) continue;
                Sound sound = Utils.getSound(config.getString("conversions." + name + ".sound"), null, null);
                HashMap<Material, Pair<Integer, Boolean>> usableItems = new HashMap<Material, Pair<Integer, Boolean>>();
                ConfigurationSection itemSection = config.getConfigurationSection("conversions." + name + ".with");
                if (itemSection != null) {
                    for (String i : itemSection.getKeys(false)) {
                        Material with = Catch.catchOrElse(() -> Material.valueOf((String)i.replaceFirst("c:", "")), null);
                        if (with == null) continue;
                        boolean consumed = i.startsWith("c:");
                        int modelData = config.getInt("conversions." + name + ".with." + i, -1);
                        usableItems.put(with, new Pair<Integer, Boolean>(modelData, consumed));
                    }
                }
                if (usableItems.isEmpty()) {
                    ValhallaMMO.logWarning("Block interact conversion " + name + " has no usable tools to execute it with");
                    continue;
                }
                conversions.put(name, new Conversion(name, from, to, usableItems, sound));
            }
        }
        for (String c : conversions.keySet()) {
            Conversion conversion = conversions.get(c);
            for (Material tool : conversion.usableItems.keySet()) {
                Map conversionsByTool = conversionsByBlock.getOrDefault(conversion.from, new HashMap());
                Collection existingConversions = conversionsByTool.getOrDefault(tool, new HashSet());
                existingConversions.add(conversion);
                conversionsByTool.put(tool, existingConversions);
                conversionsByBlock.put(conversion.from, conversionsByTool);
            }
        }
    }

    public static boolean trigger(Player user, Block clicked) {
        ItemBuilder used;
        boolean mainHand;
        if (!conversionsByBlock.containsKey(clicked.getType()) || !user.isSneaking()) {
            return false;
        }
        if (!ItemUtils.isEmpty(user.getInventory().getItemInMainHand()) && conversionsByBlock.get(clicked.getType()).containsKey(user.getInventory().getItemInMainHand().getType())) {
            mainHand = true;
            used = new ItemBuilder(user.getInventory().getItemInMainHand());
        } else if (!ItemUtils.isEmpty(user.getInventory().getItemInOffHand()) && conversionsByBlock.get(clicked.getType()).containsKey(user.getInventory().getItemInOffHand().getType())) {
            mainHand = false;
            used = new ItemBuilder(user.getInventory().getItemInOffHand());
        } else {
            return false;
        }
        Collection<Conversion> possibleConversion = conversionsByBlock.get(clicked.getType()).get(used.getItem().getType());
        PowerProfile profile = ProfileCache.getOrCache(user, PowerProfile.class);
        for (Conversion conversion : possibleConversion) {
            Stairs s1;
            Pair<Integer, Boolean> data;
            if (!profile.getUnlockedBlockConversions().contains(conversion.name) || (data = conversion.usableItems.get(used.getItem().getType())).getOne() >= 0 && !used.getMeta().hasCustomModelData() || data.getOne() >= 0 && used.getMeta().getCustomModelData() != data.getOne().intValue()) continue;
            ItemStack item = mainHand ? user.getInventory().getItemInMainHand() : user.getInventory().getItemInOffHand();
            BlockPlaceEvent event = new BlockPlaceEvent(clicked, clicked.getState(), clicked.getLocation().add(0.0, -1.0, 0.0).getBlock(), item, user, true, mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            BlockData blockData = clicked.getBlockData();
            if (blockData instanceof Stairs) {
                s1 = (Stairs)blockData;
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                    BlockData patt0$temp = clicked.getBlockData();
                    if (patt0$temp instanceof Stairs) {
                        Stairs s2 = (Stairs)patt0$temp;
                        s2.setShape(s1.getShape());
                    }
                }, 1L);
            }
            if ((blockData = clicked.getBlockData()) instanceof Slab) {
                s1 = (Slab)blockData;
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> BlockInteractConversions.lambda$trigger$4(clicked, (Slab)s1), 1L);
            }
            clicked.setType(conversion.to);
            if (conversion.sound != null) {
                user.playSound(user.getLocation(), conversion.sound, 1.0f, 1.0f);
            }
            if (!data.getTwo().booleanValue()) {
                return true;
            }
            if (used.getMeta() instanceof Damageable && used.getItem().getType().getMaxDurability() > 0) {
                if (ItemUtils.damageItem(user, item, 1, mainHand ? EntityEffect.BREAK_EQUIPMENT_MAIN_HAND : EntityEffect.BREAK_EQUIPMENT_OFF_HAND, true)) {
                    if (mainHand) {
                        user.getInventory().setItemInMainHand(null);
                    } else {
                        user.getInventory().setItemInOffHand(null);
                    }
                }
            } else if (item.getAmount() <= 1) {
                if (mainHand) {
                    user.getInventory().setItemInMainHand(null);
                } else {
                    user.getInventory().setItemInOffHand(null);
                }
            } else {
                item.setAmount(item.getAmount() - 1);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$trigger$4(Block clicked, Slab s1) {
        BlockData patt0$temp = clicked.getBlockData();
        if (patt0$temp instanceof Slab) {
            Slab s2 = (Slab)patt0$temp;
            s2.setType(s1.getType());
        }
    }

    public record Conversion(String name, Material from, Material to, Map<Material, Pair<Integer, Boolean>> usableItems, Sound sound) {
    }
}

