/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.persistence.BrewingRecipePersistence;
import me.athlaeos.valhallammo.crafting.persistence.CauldronRecipePersistence;
import me.athlaeos.valhallammo.crafting.persistence.CookingRecipePersistence;
import me.athlaeos.valhallammo.crafting.persistence.GridRecipePersistence;
import me.athlaeos.valhallammo.crafting.persistence.ImmersiveRecipePersistence;
import me.athlaeos.valhallammo.crafting.persistence.SmithingRecipePersistence;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicBrewingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCauldronRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaKeyedRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.listeners.CookingListener;
import me.athlaeos.valhallammo.listeners.SmithingTableListener;
import me.athlaeos.valhallammo.persistence.GsonAdapter;
import me.athlaeos.valhallammo.persistence.ItemStackGSONAdapter;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.version.SmithingTransformRecipeWrapper;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class CustomRecipeRegistry {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(RecipeOption.class, new GsonAdapter("OPTION")).registerTypeAdapter(IngredientChoice.class, new GsonAdapter("CHOICE")).registerTypeAdapter(DynamicItemModifier.class, new GsonAdapter("MOD_TYPE")).registerTypeAdapter(ValhallaRecipe.class, new GsonAdapter("RECIPE_TYPE")).registerTypeAdapter(Validation.class, new GsonAdapter("VALIDATION_TYPE")).registerTypeHierarchyAdapter(ConfigurationSerializable.class, (Object)new ItemStackGSONAdapter()).setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();
    private static final Collection<NamespacedKey> disabledRecipes = new HashSet<NamespacedKey>();
    private static final Map<String, DynamicBrewingRecipe> brewingRecipes = new HashMap<String, DynamicBrewingRecipe>();
    private static final Map<Material, Collection<DynamicBrewingRecipe>> brewingRecipesByIngredient = new HashMap<Material, Collection<DynamicBrewingRecipe>>();
    private static final Map<String, DynamicCauldronRecipe> cauldronRecipes = new HashMap<String, DynamicCauldronRecipe>();
    private static final Map<String, DynamicCookingRecipe> cookingRecipes = new HashMap<String, DynamicCookingRecipe>();
    private static final Map<String, DynamicGridRecipe> gridRecipes = new HashMap<String, DynamicGridRecipe>();
    private static final Map<String, DynamicSmithingRecipe> smithingRecipes = new HashMap<String, DynamicSmithingRecipe>();
    private static final Map<String, ImmersiveCraftingRecipe> immersiveRecipes = new HashMap<String, ImmersiveCraftingRecipe>();
    private static final Map<NamespacedKey, DynamicCookingRecipe> cookingRecipesByKey = new HashMap<NamespacedKey, DynamicCookingRecipe>();
    private static final Map<NamespacedKey, DynamicGridRecipe> gridRecipesByKey = new HashMap<NamespacedKey, DynamicGridRecipe>();
    private static final Map<Integer, Collection<DynamicGridRecipe>> gridRecipesByIngredientQuantities = new HashMap<Integer, Collection<DynamicGridRecipe>>();
    private static final Map<NamespacedKey, DynamicSmithingRecipe> smithingRecipesByKey = new HashMap<NamespacedKey, DynamicSmithingRecipe>();
    private static final Map<String, Collection<ImmersiveCraftingRecipe>> immersiveRecipesByBlock = new HashMap<String, Collection<ImmersiveCraftingRecipe>>();
    private static final Collection<String> allRecipes = new HashSet<String>();
    private static final Map<NamespacedKey, ValhallaKeyedRecipe> allKeyedRecipes = new HashMap<NamespacedKey, ValhallaKeyedRecipe>();
    private static final Map<String, ValhallaKeyedRecipe> allKeyedRecipesByName = new HashMap<String, ValhallaKeyedRecipe>();
    private static boolean changesMade = false;
    private static final BrewingRecipePersistence brewingRecipePersistence = new BrewingRecipePersistence(gson);
    private static final GridRecipePersistence gridRecipePersistence = new GridRecipePersistence(gson);
    private static final SmithingRecipePersistence smithingRecipePersistence = new SmithingRecipePersistence(gson);
    private static final ImmersiveRecipePersistence immersiveRecipePersistence = new ImmersiveRecipePersistence(gson);
    private static final CauldronRecipePersistence cauldronRecipePersistence = new CauldronRecipePersistence(gson);
    private static final CookingRecipePersistence cookingRecipePersistence = new CookingRecipePersistence(gson);

    public static void loadFiles() {
        CustomRecipeRegistry.loadBrewingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/brewing_recipes.json"), false);
        CustomRecipeRegistry.loadGridRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/grid_recipes.json"), false);
        CustomRecipeRegistry.loadSmithingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/smithing_recipes.json"), false);
        CustomRecipeRegistry.loadImmersiveRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/immersive_recipes.json"), false);
        CustomRecipeRegistry.loadCauldronRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/cauldron_recipes.json"), false);
        CustomRecipeRegistry.loadCookingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/cooking_recipes.json"), false);
        for (MinecraftVersion version : MinecraftVersion.values()) {
            if (!MinecraftVersion.currentVersionNewerThan(version) || version.getVersionString() == null) continue;
            CustomRecipeRegistry.loadBrewingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/brewing_recipes_" + version.getVersionString() + "+.json"), false);
            CustomRecipeRegistry.loadGridRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/grid_recipes_" + version.getVersionString() + "+.json"), false);
            CustomRecipeRegistry.loadSmithingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/smithing_recipes_" + version.getVersionString() + "+.json"), false);
            CustomRecipeRegistry.loadImmersiveRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/immersive_recipes_" + version.getVersionString() + "+.json"), false);
            CustomRecipeRegistry.loadCauldronRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/cauldron_recipes_" + version.getVersionString() + "+.json"), false);
            CustomRecipeRegistry.loadCookingRecipes(new File(ValhallaMMO.getInstance().getDataFolder(), "/recipes/cooking_recipes_" + version.getVersionString() + "+.json"), false);
        }
        YamlConfiguration disabled = ConfigManager.getConfig("recipes/disabled_recipes.yml").reload().get();
        for (String s : disabled.getStringList("disabled")) {
            try {
                NamespacedKey recipeKey = NamespacedKey.minecraft((String)s.toLowerCase(Locale.US));
                disabledRecipes.add(recipeKey);
            }
            catch (IllegalArgumentException ignored) {
                ValhallaMMO.logWarning("Invalid recipe key '" + s + "' found, recipe contains illegal characters. Allowed characters: [a-zA-Z0-9/. -], cancelled crafting recipe removal");
            }
        }
    }

    public static void removeDisabledRecipe(NamespacedKey key) {
        disabledRecipes.remove(key);
    }

    public static void addDisabledRecipe(NamespacedKey key) {
        disabledRecipes.add(key);
    }

    public static Collection<NamespacedKey> getDisabledRecipes() {
        return disabledRecipes;
    }

    public static void saveRecipes(boolean async) {
        if (!changesMade) {
            return;
        }
        if (async) {
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), CustomRecipeRegistry::saveAllRecipeTypes);
        } else {
            CustomRecipeRegistry.saveAllRecipeTypes();
        }
    }

    private static void saveAllRecipeTypes() {
        brewingRecipePersistence.saveRecipesToFile("recipes/brewing_recipes.json", brewingRecipes.values());
        gridRecipePersistence.saveRecipesToFile("recipes/grid_recipes.json", gridRecipes.values());
        smithingRecipePersistence.saveRecipesToFile("recipes/smithing_recipes.json", smithingRecipes.values());
        immersiveRecipePersistence.saveRecipesToFile("recipes/immersive_recipes.json", immersiveRecipes.values());
        cauldronRecipePersistence.saveRecipesToFile("recipes/cauldron_recipes.json", cauldronRecipes.values());
        cookingRecipePersistence.saveRecipesToFile("recipes/cooking_recipes.json", cookingRecipes.values());
        YamlConfiguration disabled = ConfigManager.getConfig("recipes/disabled_recipes.yml").reload().get();
        disabled.set("disabled", disabledRecipes.stream().map(NamespacedKey::getKey).collect(Collectors.toList()));
        ConfigManager.saveConfig("recipes/disabled_recipes.yml");
    }

    public static void loadBrewingRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading brewing recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> brewingRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((DynamicBrewingRecipe)r, overwrite))));
    }

    public static void loadCauldronRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading cauldron recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> cauldronRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((DynamicCauldronRecipe)r, overwrite))));
    }

    public static void loadCookingRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading cooking recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> cookingRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((DynamicCookingRecipe)r, overwrite))));
    }

    public static void loadGridRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading crafting grid recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> gridRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((DynamicGridRecipe)r, overwrite))));
    }

    public static void loadSmithingRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading smithing recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> smithingRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((DynamicSmithingRecipe)r, overwrite))));
    }

    public static void loadImmersiveRecipes(File file, boolean overwrite) {
        if (!file.exists()) {
            return;
        }
        ValhallaMMO.logInfo("Loading immersive recipes from " + file.getPath());
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> immersiveRecipePersistence.getRecipesFromFile(file).forEach((k, r) -> ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> CustomRecipeRegistry.register((ImmersiveCraftingRecipe)r, overwrite))));
    }

    private static void addRecipePermission(String recipeName) {
        Permission existing = ValhallaMMO.getInstance().getServer().getPluginManager().getPermission("valhalla.recipe." + recipeName);
        if (existing != null) {
            return;
        }
        existing = new Permission("valhalla.recipe." + recipeName, "Grants access to the recipe " + recipeName, PermissionDefault.FALSE);
        ValhallaMMO.getInstance().getServer().getPluginManager().addPermission(existing);
    }

    private static void removePermission(String recipeName) {
        ValhallaMMO.getInstance().getServer().getPluginManager().removePermission("valhalla.recipe." + recipeName);
    }

    public static void register(DynamicBrewingRecipe recipe, boolean overwrite) {
        if (overwrite || !brewingRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            brewingRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            Collection existing = brewingRecipesByIngredient.getOrDefault(recipe.getIngredient().getItem().getType(), new HashSet());
            existing.add(recipe);
            brewingRecipesByIngredient.put(recipe.getIngredient().getItem().getType(), existing);
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.BREWING.getId());
        }
    }

    public static void register(DynamicCauldronRecipe recipe, boolean overwrite) {
        if (overwrite || !cauldronRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            cauldronRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.CAULDRON.getId());
        }
    }

    public static void register(ImmersiveCraftingRecipe recipe, boolean overwrite) {
        if (overwrite || !immersiveRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            immersiveRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            Collection recipesByBlock = immersiveRecipesByBlock.getOrDefault(recipe.getBlock(), new HashSet());
            recipesByBlock.add(recipe);
            immersiveRecipesByBlock.put(recipe.getBlock(), recipesByBlock);
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.IMMERSIVE.getId());
        }
    }

    public static void register(DynamicCookingRecipe recipe, boolean overwrite) {
        if (overwrite || !cookingRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            cookingRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            cookingRecipesByKey.put(recipe.getKey(), recipe);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            allKeyedRecipes.put(recipe.getKey(), recipe);
            allKeyedRecipesByName.put(recipe.getName(), recipe);
            try {
                recipe.registerRecipe();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CookingListener.campfireRecipeCache.clear();
            CookingListener.furnaceRecipeCache.clear();
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            RecipeOverviewMenu.resetCache(switch (recipe.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case DynamicCookingRecipe.CookingRecipeType.SMOKER -> RecipeOverviewMenu.SMOKING.getId();
                case DynamicCookingRecipe.CookingRecipeType.FURNACE -> RecipeOverviewMenu.FURNACE.getId();
                case DynamicCookingRecipe.CookingRecipeType.BLAST_FURNACE -> RecipeOverviewMenu.BLASTING.getId();
                case DynamicCookingRecipe.CookingRecipeType.CAMPFIRE -> RecipeOverviewMenu.CAMPFIRE.getId();
            });
        }
    }

    public static void register(DynamicGridRecipe recipe, boolean overwrite) {
        if (overwrite || !gridRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            gridRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            gridRecipesByKey.put(recipe.getKey(), recipe);
            gridRecipesByKey.put(recipe.getKey2(), recipe);
            Collection existing = gridRecipesByIngredientQuantities.getOrDefault(recipe.getItems().size(), new HashSet());
            existing.add(recipe);
            gridRecipesByIngredientQuantities.put(recipe.getItems().size(), existing);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            allKeyedRecipes.put(recipe.getKey(), recipe);
            allKeyedRecipesByName.put(recipe.getName(), recipe);
            recipe.registerRecipe();
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.CRAFTING_TABLE.getId());
        }
    }

    public static void register(DynamicSmithingRecipe recipe, boolean overwrite) {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20) && (recipe.getTemplate() == null || recipe.getTemplate().getOption() == null || ItemUtils.isEmpty(recipe.getTemplate().getItem()) || recipe.getTemplate().getOption().getChoice(recipe.getTemplate().getItem()) == null)) {
            recipe.setTemplate(new SlotEntry(new ItemStack(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE), new MaterialChoice()));
        }
        if (overwrite || !smithingRecipes.containsKey(recipe.getName().toLowerCase(Locale.US))) {
            smithingRecipes.put(recipe.getName().toLowerCase(Locale.US), recipe);
            smithingRecipesByKey.put(recipe.getKey(), recipe);
            allRecipes.add(recipe.getName().toLowerCase(Locale.US));
            allKeyedRecipes.put(recipe.getKey(), recipe);
            allKeyedRecipesByName.put(recipe.getName(), recipe);
            SmithingTableListener.smithingRecipeCache.clear();
            boolean isTemplateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
            if (isTemplateCompatible) {
                recipe.convertTemplate();
            }
            CustomRecipeRegistry.addRecipePermission(recipe.getName());
            Iterator iterator = ValhallaMMO.getInstance().getServer().recipeIterator();
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.SMITHING.getId());
            while (iterator.hasNext()) {
                SmithingRecipe s;
                Recipe r = (Recipe)iterator.next();
                if (!(r instanceof SmithingRecipe) || !(s = (SmithingRecipe)r).getBase().test(recipe.getBase().getItem()) || !s.getAddition().test(recipe.getAddition().getItem()) || isTemplateCompatible && !SmithingTransformRecipeWrapper.templatesMatch(s, SmithingTransformRecipeWrapper.getTemplate(s))) continue;
                return;
            }
            recipe.registerRecipe();
        }
    }

    public static void setChangesMade() {
        changesMade = true;
    }

    public static void unregister(String recipe) {
        CustomRecipeRegistry.setChangesMade();
        allRecipes.remove(recipe);
        if (brewingRecipes.containsKey(recipe)) {
            brewingRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.BREWING.getId());
        } else if (cauldronRecipes.containsKey(recipe)) {
            cauldronRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.CAULDRON.getId());
        } else if (immersiveRecipes.containsKey(recipe)) {
            ImmersiveCraftingRecipe r = immersiveRecipes.get(recipe);
            Collection recipesByBlock = immersiveRecipesByBlock.getOrDefault(r.getBlock(), new HashSet());
            recipesByBlock.remove(r);
            immersiveRecipesByBlock.put(r.getBlock(), recipesByBlock);
            immersiveRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.IMMERSIVE.getId());
        } else if (cookingRecipes.containsKey(recipe)) {
            cookingRecipes.get(recipe).unregisterRecipe();
            cookingRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.FURNACE.getId());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.CAMPFIRE.getId());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.SMOKING.getId());
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.BLASTING.getId());
        } else if (gridRecipes.containsKey(recipe)) {
            gridRecipes.get(recipe).unregisterRecipe();
            gridRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.CRAFTING_TABLE.getId());
        } else if (smithingRecipes.containsKey(recipe)) {
            smithingRecipes.get(recipe).unregisterRecipe();
            smithingRecipes.remove(recipe);
            RecipeOverviewMenu.resetCache(RecipeOverviewMenu.SMITHING.getId());
        }
        CustomRecipeRegistry.removePermission(recipe);
    }

    public static Map<String, DynamicBrewingRecipe> getBrewingRecipes() {
        return brewingRecipes;
    }

    public static Map<String, DynamicCauldronRecipe> getCauldronRecipes() {
        return cauldronRecipes;
    }

    public static Map<String, DynamicCookingRecipe> getCookingRecipes() {
        return cookingRecipes;
    }

    public static Map<NamespacedKey, DynamicCookingRecipe> getCookingRecipesByKey() {
        return cookingRecipesByKey;
    }

    public static Map<String, DynamicGridRecipe> getGridRecipes() {
        return gridRecipes;
    }

    public static Map<NamespacedKey, DynamicGridRecipe> getGridRecipesByKey() {
        return gridRecipesByKey;
    }

    public static Map<Integer, Collection<DynamicGridRecipe>> getGridRecipesByIngredientQuantity() {
        return gridRecipesByIngredientQuantities;
    }

    public static Map<String, DynamicSmithingRecipe> getSmithingRecipes() {
        return smithingRecipes;
    }

    public static Map<NamespacedKey, DynamicSmithingRecipe> getSmithingRecipesByKey() {
        return smithingRecipesByKey;
    }

    public static Map<String, ImmersiveCraftingRecipe> getImmersiveRecipes() {
        return immersiveRecipes;
    }

    public static Collection<String> getAllRecipes() {
        return allRecipes;
    }

    public static Map<String, Collection<ImmersiveCraftingRecipe>> getImmersiveRecipesByBlock() {
        return immersiveRecipesByBlock;
    }

    public static Map<NamespacedKey, ValhallaKeyedRecipe> getAllKeyedRecipes() {
        return allKeyedRecipes;
    }

    public static Map<String, ValhallaKeyedRecipe> getAllKeyedRecipesByName() {
        return allKeyedRecipesByName;
    }

    public static Map<Material, Collection<DynamicBrewingRecipe>> getBrewingRecipesByIngredient() {
        return brewingRecipesByIngredient;
    }
}

