/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.blockvalidations.implementations;

import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class BlockInRange
extends Validation {
    private final Material blockRequired;
    private final Material icon;
    private final int radius;
    private final int heightDifference;
    private final String errorMessage;

    public BlockInRange(Material blockRequired, int radius, int heightDifference, String errorMessage) {
        this.blockRequired = blockRequired;
        this.icon = blockRequired;
        this.radius = radius;
        this.heightDifference = heightDifference;
        this.errorMessage = errorMessage;
    }

    public BlockInRange(Material blockRequired, Material icon, int radius, int heightDifference, String errorMessage) {
        this.blockRequired = blockRequired;
        this.icon = icon;
        this.radius = radius;
        this.heightDifference = heightDifference;
        this.errorMessage = errorMessage;
    }

    @Override
    public String id() {
        return "BLOCK_NEARBY_" + String.valueOf(this.blockRequired);
    }

    @Override
    public ItemStack icon() {
        String name = StringUtils.toPascalCase(this.blockRequired.toString().replace("_", " "));
        return new ItemBuilder(this.icon).name("&e" + name + " within " + this.radius + " blocks").lore("&fRequires " + name + " to be within", "&f" + this.radius + " blocks to the block").get();
    }

    @Override
    public String activeDescription() {
        String name = StringUtils.toPascalCase(this.blockRequired.toString().replace("_", " "));
        return "&fMust have " + name + " within " + this.radius + " blocks";
    }

    @Override
    public String validationError() {
        return this.errorMessage;
    }

    @Override
    public boolean isCompatible(String block) {
        return true;
    }

    @Override
    public boolean validate(Block b) {
        for (int x = b.getX() - this.radius; x <= b.getX() + this.radius; ++x) {
            for (int y = b.getY() - this.heightDifference; y <= b.getY() + this.heightDifference; ++y) {
                for (int z = b.getZ() - this.radius; z <= b.getZ() + this.radius; ++z) {
                    Block block = b.getWorld().getBlockAt(x, y, z);
                    if (!ItemUtils.isSimilarMaterial(this.blockRequired, block.getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void execute(Block b) {
    }
}

