/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.crafting_conditionals;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SmithingTagsAdd
extends DynamicItemModifier {
    private final Collection<Integer> tags = new HashSet<Integer>();
    private Map<Integer, Integer> newTags = new HashMap<Integer, Integer>();
    private int tag = 0;
    private int level = 1;

    public SmithingTagsAdd(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (this.newTags == null) {
            this.newTags = new HashMap<Integer, Integer>();
        }
        if (!this.tags.isEmpty()) {
            this.tags.forEach(t -> this.newTags.put((Integer)t, 1));
            this.tags.clear();
        }
        Map<Integer, Integer> existingTags = SmithingItemPropertyManager.getTags(context.getItem().getMeta());
        this.newTags.keySet().forEach(t -> SmithingItemPropertyManager.addTag(context.getItem(), t, existingTags.getOrDefault(t, 0) + this.newTags.get(t)));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11) {
            this.tag = Math.max(0, this.tag + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1));
        } else if (button == 13) {
            this.level += (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1);
        } else if (button == 17) {
            if (e.isShiftClick()) {
                this.newTags.clear();
            } else {
                this.newTags.put(this.tag, this.level);
            }
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        List<String> tagLore = this.newTags.isEmpty() ? List.of("&cNone") : this.newTags.keySet().stream().map(t -> "&e" + Objects.requireNonNullElse(String.format("%s %s", SmithingItemPropertyManager.getTagLore(t), StringUtils.toRoman(this.newTags.getOrDefault(t, 1))), String.format("%d %s &7(invisible)", t, StringUtils.toRoman(this.newTags.getOrDefault(t, 1))))).collect(Collectors.toList());
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.WRITABLE_BOOK).name("&fTag Selection?").lore("&fTag &e" + this.tag + "&7 (" + Objects.requireNonNullElse(SmithingItemPropertyManager.getTagLore(this.tag), "invisible") + "&7)", "&fClick the button below to add", "&fthis tag to the list.", "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 10", "&fCurrent tags:").appendLore(tagLore).get()).map(Set.of(new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.STRUCTURE_VOID).name("&fTag Level").lore("&fTag &e" + this.tag + "&7 (" + Objects.requireNonNullElse(SmithingItemPropertyManager.getTagLore(this.tag), "invisible") + "&7) " + StringUtils.toRoman(this.level), "&fLevel is added to any pre-existing tag level", "&6Click to add selected tag to", "&6the list.", "&6Shift-Click to clear list", "&fCurrent tags:").appendLore(tagLore).get()), new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.STRUCTURE_VOID).name("&fConfirm Tag").lore("&fCurrently selected: &e" + this.tag + " " + StringUtils.toRoman(this.level), "&6Click to add selected tag to", "&6the list.", "&6Shift-Click to clear list", "&fCurrent tags:").appendLore(tagLore).get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.PAPER).get();
    }

    @Override
    public String getDisplayName() {
        return "&7Item Tags (ADD)";
    }

    @Override
    public String getDescription() {
        return "&fAdds a number of item tags to the item. Item tags are useful for recipe condition checking";
    }

    @Override
    public String getActiveDescription() {
        if (this.newTags == null) {
            this.newTags = new HashMap<Integer, Integer>();
        }
        if (!this.tags.isEmpty()) {
            this.tags.forEach(t -> this.newTags.put((Integer)t, 1));
            this.tags.clear();
        }
        return "&fAdds the following tags to the item: /n&e" + String.valueOf(this.newTags.isEmpty() ? List.of("&cNone") : this.newTags.keySet().stream().map(t -> "&e" + SmithingItemPropertyManager.getTagLore(t) + " " + StringUtils.toRoman(Math.max(1, this.newTags.get(t)))).collect(Collectors.joining(", ")));
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.CRAFTING_CONDITIONALS.id());
    }

    public Map<Integer, Integer> getNewTags() {
        if (this.newTags == null) {
            this.newTags = new HashMap<Integer, Integer>();
        }
        if (!this.tags.isEmpty()) {
            this.tags.forEach(t -> this.newTags.put((Integer)t, 1));
            this.tags.clear();
        }
        return this.newTags;
    }

    @Override
    public DynamicItemModifier copy() {
        SmithingTagsAdd m = new SmithingTagsAdd(this.getName());
        m.getNewTags().putAll(this.newTags);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "One argument is expected: a string joining all numeric tags and levels together (example: 1:1,2:5,3:1,4:2)";
        }
        for (String t : args[0].split(",")) {
            String[] split = t.split(":");
            Integer tag = Catch.catchOrElse(() -> Integer.parseInt(split[0]), null);
            if (tag == null) {
                return "One argument is expected: a string joining all numeric tags together (example: 1,2,3,4). One of them was not a number";
            }
            Integer level = Catch.catchOrElse(() -> Integer.parseInt(split[1]), null);
            this.newTags.put(tag, level == null ? 1 : Math.max(1, level));
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<tags_separated_by_commas>");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }

    public void setNewTags(Map<Integer, Integer> newTags) {
        this.newTags = newTags;
    }
}

