/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.enchantment_misc;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.EnchantingItemPropertyManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.Enchanter;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentRandomize
extends DynamicItemModifier {
    private int level = 10;
    private boolean scaleWithSkill = false;
    private boolean includeTreasure = false;

    public EnchantmentRandomize(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (this.level == 0) {
            return;
        }
        if (!context.getItem().getItem().getEnchantments().isEmpty()) {
            this.failedRecipe(context.getItem(), TranslationManager.getTranslation("modifier-warning-already-has-enchantments"));
            return;
        }
        Map<Enchantment, Integer> chosenEnchantments = Enchanter.getRandomEnchantments(context.getItem().getItem(), context.getItem().getMeta(), this.level, this.includeTreasure);
        if (chosenEnchantments.isEmpty()) {
            return;
        }
        if (context.getItem().getItem().getType() == Material.BOOK) {
            context.getItem().type(Material.ENCHANTED_BOOK);
        }
        for (Enchantment e : chosenEnchantments.keySet()) {
            ItemMeta itemMeta;
            int lv = chosenEnchantments.get(e);
            if (this.scaleWithSkill) {
                int skill = (int)AccumulativeStatManager.getCachedStats("ENCHANTING_QUALITY", (Entity)context.getCrafter(), 10000L, true);
                skill = (int)((double)skill * (1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_FRACTION_QUALITY", (Entity)context.getCrafter(), 10000L, true)));
                lv = EnchantingItemPropertyManager.getScaledLevel(e, skill, lv);
            }
            if ((itemMeta = context.getItem().getMeta()) instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta eMeta = (EnchantmentStorageMeta)itemMeta;
                eMeta.addStoredEnchant(e, lv, false);
                continue;
            }
            context.getItem().enchant(e, lv);
        }
    }

    @Override
    public boolean requiresPlayer() {
        return this.scaleWithSkill;
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            this.level = Math.max(1, this.level + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1));
        } else if (button == 17) {
            this.scaleWithSkill = !this.scaleWithSkill;
        } else if (button == 13) {
            this.includeTreasure = !this.includeTreasure;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.ENCHANTED_BOOK).name("&eWhat level should be enchanted at?").lore("&fEnchanted at level &e" + this.level, "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 10").get()).map(this.level > 0 ? Set.of(new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.ENCHANTED_BOOK).name("&eShould they scale with skill?").lore(this.scaleWithSkill ? "&eYes" : "&eNo", "&fEnchantments that scale will ", "&fgain/lose levels based on ", "&fenchanting skill.", "&6Click to toggle").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.CHEST).name("&eInclude treasure enchantments?").lore(this.includeTreasure ? "&eYes" : "&eNo", "&fTreasure enchantments do not", "&fnaturally occur through enchanting.", "&fExamples: Mending, Curse of Binding.", "&fenchanting skill.", "&6Click to toggle").get())) : new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.ENCHANTING_TABLE).get();
    }

    @Override
    public String getDisplayName() {
        return "&dEnchant Item Randomly";
    }

    @Override
    public String getDescription() {
        return "&fEnchants item randomly given a level";
    }

    @Override
    public String getActiveDescription() {
        return "&fEnchants item randomly at level &e" + this.level + (this.includeTreasure ? " &fincluding treasure enchantments" : "");
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ENCHANTMENT_MISC.id());
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setScaleWithSkill(boolean scaleWithSkill) {
        this.scaleWithSkill = scaleWithSkill;
    }

    public void setIncludeTreasure(boolean includeTreasure) {
        this.includeTreasure = includeTreasure;
    }

    @Override
    public DynamicItemModifier copy() {
        EnchantmentRandomize m = new EnchantmentRandomize(this.getName());
        m.setIncludeTreasure(this.includeTreasure);
        m.setScaleWithSkill(this.scaleWithSkill);
        m.setLevel(this.level);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 2) {
            return "Two arguments expected: an integer and a yes/no answer";
        }
        try {
            this.level = Integer.parseInt(args[0]);
            this.scaleWithSkill = args[1].equalsIgnoreCase("yes");
        }
        catch (NumberFormatException ignored) {
            return "Two arguments expected: an integer and a yes/no answer. Invalid number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<level>");
        }
        if (currentArg == 1) {
            return List.of("yes", "no");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 2;
    }
}

