/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MaterialClass;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class AmountScale
extends DynamicItemModifier {
    private double skillEfficiency = 1.0;
    private double minimumFraction = 0.0;
    private boolean damagePenalty = true;
    private static final Scaling scaling = Scaling.fromConfig("skills/smithing.yml", "quantity_scaling");

    public AmountScale(String name) {
        super(name);
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    @Override
    public void processItem(ModifierContext context) {
        int minimumAmount;
        int newAmount;
        if (scaling == null) {
            this.failedRecipe(context.getItem(), "");
            return;
        }
        double skill = AccumulativeStatManager.getCachedStats("SMITHING_QUALITY_GENERAL", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        double skillMultiplier = 1.0 + AccumulativeStatManager.getCachedStats("SMITHING_FRACTION_QUALITY_GENERAL", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        MaterialClass materialClass = MaterialClass.getMatchingClass(context.getItem().getMeta());
        if (materialClass != null) {
            skill += AccumulativeStatManager.getCachedStats("SMITHING_QUALITY_" + String.valueOf((Object)materialClass), (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
            skillMultiplier += AccumulativeStatManager.getCachedStats("SMITHING_FRACTION_QUALITY_" + String.valueOf((Object)materialClass), (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        }
        int originalAmount = context.getItem().getItem().getAmount();
        if (this.damagePenalty && context.getItem().getMeta() instanceof Damageable && context.getItem().getItem().getType().getMaxDurability() > 0) {
            double fractionDurability = (double)(context.getItem().getItem().getType().getMaxDurability() - ((Damageable)context.getItem().getMeta()).getDamage()) / (double)context.getItem().getItem().getType().getMaxDurability();
            originalAmount = (int)Math.floor((double)originalAmount * fractionDurability);
        }
        if ((newAmount = (int)Math.max((double)(minimumAmount = Math.max(0, (int)Math.ceil((double)originalAmount * this.minimumFraction))), Math.floor(scaling.evaluate(scaling.getExpression().replace("%rating%", String.valueOf(skill * skillMultiplier * this.skillEfficiency)), originalAmount)))) <= 0) {
            context.getItem().amount(1);
            context.getItem().type(Material.BARRIER);
            this.failedRecipe(context.getItem(), TranslationManager.getTranslation("modifier_warning_salvage_insufficient_skill"));
        } else {
            context.getItem().amount(newAmount);
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 6) {
            this.skillEfficiency = Math.max(0.0, this.skillEfficiency + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 8) {
            this.minimumFraction = Math.min(1.0, Math.max(0.0, this.minimumFraction + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01)));
        } else if (button == 17) {
            this.damagePenalty = !this.damagePenalty;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(6, new ItemBuilder(Material.NETHER_STAR).name("&fSkill Efficiency").lore(String.format("&fSkill efficiency: %.0f%%", this.skillEfficiency * 100.0), String.format("&fMinimum fraction of items: &e%.2fx", this.minimumFraction), String.format("&fReduces with item damage: &e%s", this.damagePenalty ? "Yes" : "No"), "&fSkill efficiency determines how much", "&fof the player's skill is used in the", "&fformula.", "&6Click to add/subtract 1%", "&6Shift-Click to add/subtract 10%").get()).map(Set.of(new Pair<Integer, ItemStack>(8, new ItemBuilder(Material.PAPER).name("&fMinimum fraction").lore(String.format("&fSkill efficiency: %.0f%%", this.skillEfficiency * 100.0), String.format("&fMinimum fraction of items: &e%.2fx", this.minimumFraction), String.format("&fReduces with item damage: &e%s", this.damagePenalty ? "Yes" : "No"), "&fThe resulting item will always be at", "&fleast the given fraction of its amount,", "&frounded up", "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.1").get()), new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.GOLDEN_PICKAXE).name("&6Scale with durability?").lore(String.format("&fSkill efficiency: %.0f%%", this.skillEfficiency * 100.0), String.format("&fMinimum fraction of items: &e%.2fx", this.minimumFraction), String.format("&fReduces with item damage: &e%s", this.damagePenalty ? "Yes" : "No"), "&fDetermines if the resulting amount will", "&fbe lower if the item is damaged.", "&f50% durability will halve the amount", "&6Click to toggle on/off").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.IRON_INGOT).get();
    }

    @Override
    public String getDisplayName() {
        return "&aQuantity (DYNAMIC)";
    }

    @Override
    public String getDescription() {
        return "&fChanges the item's amount based on the player's smithing skill";
    }

    @Override
    public String getActiveDescription() {
        return String.format("&fChanges the item's amount based on &e%.0f%%&f the player's smithing skill, to at least &e%.2fx&f the item's amount &e%s", this.skillEfficiency * 100.0, this.minimumFraction, this.damagePenalty ? "and reducing further with item durability damage" : "No");
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setDamagePenalty(boolean damagePenalty) {
        this.damagePenalty = damagePenalty;
    }

    public void setMinimumFraction(double minimumFraction) {
        this.minimumFraction = minimumFraction;
    }

    public void setSkillEfficiency(double skillEfficiency) {
        this.skillEfficiency = skillEfficiency;
    }

    @Override
    public DynamicItemModifier copy() {
        AmountScale m = new AmountScale(this.getName());
        m.setDamagePenalty(this.damagePenalty);
        m.setMinimumFraction(this.minimumFraction);
        m.setSkillEfficiency(this.skillEfficiency);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 3) {
            return "Three arguments are expected: the first two doubles, the third a yes/no answer";
        }
        try {
            this.skillEfficiency = StringUtils.parseDouble(args[0]);
            this.minimumFraction = StringUtils.parseDouble(args[1]);
            this.damagePenalty = args[2].equalsIgnoreCase("yes");
        }
        catch (NumberFormatException ignored) {
            return "Three arguments are expected: the first two doubles, the third a yes/no answer. At least one was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<skill_efficiency>");
        }
        if (currentArg == 1) {
            return List.of("<minimum_fraction>");
        }
        if (currentArg == 2) {
            return List.of("<lower_with_damage>", "yes", "no");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 3;
    }
}

