/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Colorable;

public class ColorRGB
extends DynamicItemModifier {
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    public ColorRGB(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        context.getItem().color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11 || button == 12 || button == 13) {
            ItemStack cursor = e.getCursor();
            if (!ItemUtils.isEmpty(cursor)) {
                Colorable c;
                ItemMeta meta = cursor.getItemMeta();
                if (meta instanceof Colorable && (c = (Colorable)meta).getColor() != null) {
                    Color color = c.getColor().getColor();
                    this.red = color.getRed();
                    this.green = color.getGreen();
                    this.blue = color.getBlue();
                }
            } else if (button == 11) {
                this.red = Math.min(255, Math.max(0, this.red + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            } else if (button == 12) {
                this.green = Math.min(255, Math.max(0, this.green + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            } else {
                this.blue = Math.min(255, Math.max(0, this.blue + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            }
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        String hex = Utils.rgbToHex(this.red, this.green, this.blue);
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.POTION).name("&cHow red should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 1000000", "&6Shift-Click to add/subtract 100000").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.POTION).name("&aHow green should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 10000", "&6Shift-Click to add/subtract 1000").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.POTION).name("&bHow blue should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 25", "&6Shift-Click to add/subtract 1").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.POTION).flag(ConventionUtils.getHidePotionEffectsFlag()).get();
    }

    @Override
    public String getDisplayName() {
        return "&aSet Leather/Potion Color (RGB)";
    }

    @Override
    public String getDescription() {
        return "&fSets a custom leather or potion color to the item";
    }

    @Override
    public String getActiveDescription() {
        String hex = Utils.rgbToHex(this.red, this.green, this.blue);
        return "&fSets the custom color of the item to &" + hex + hex;
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id(), ModifierCategoryRegistry.POTION_MISC.id());
    }

    public void setRed(int red) {
        this.red = red;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    @Override
    public DynamicItemModifier copy() {
        ColorRGB m = new ColorRGB(this.getName());
        m.setRed(this.red);
        m.setGreen(this.green);
        m.setBlue(this.blue);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 3) {
            return "Three arguments are expected: all integers representing the RGB values of the item";
        }
        try {
            this.red = Integer.parseInt(args[0]);
            this.green = Integer.parseInt(args[1]);
            this.blue = Integer.parseInt(args[2]);
        }
        catch (IllegalArgumentException ignored) {
            return "Three arguments are expected: all integers representing the RGB values of the item. One of them is not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<red>");
        }
        if (currentArg == 1) {
            return List.of("<green>");
        }
        if (currentArg == 2) {
            return List.of("<blue>");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 3;
    }
}

