/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EnchantmentGlint
extends DynamicItemModifier {
    private Boolean glint = true;

    public EnchantmentGlint(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ValhallaMMO.getNms().setGlint(context.getItem().getMeta(), this.glint);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            this.glint = e.isShiftClick() ? null : Boolean.valueOf(this.glint == null || this.glint == false);
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.BOOK).name("&eShould the item glow?").lore("7fSet to &e" + (this.glint == null ? "reset" : (this.glint != false ? "yes" : "no")), "&fIf yes, the item will have an", "&fenchantment glint even without", "&fenchantments.", "&fIf no, the item will not have its", "&fenchantment glint even with", "&fenchantments.", "&fIf reset, it will behave as normal.", "&6Click to toggle", "&6Shift-Click to reset").get()).map(Set.of());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.ENCHANTED_BOOK).get();
    }

    @Override
    public String getDisplayName() {
        return "&aSet Enchantment Glint";
    }

    @Override
    public String getDescription() {
        return "&fSets/removes an enchantment glint on the item";
    }

    @Override
    public String getActiveDescription() {
        return "&fMakes the item " + (this.glint == null ? "glow like normal." : (this.glint != false ? "glow as if it has enchantments" : "stop glowing even if it has enchantments"));
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setGlint(Boolean glint) {
        this.glint = glint;
    }

    @Override
    public DynamicItemModifier copy() {
        EnchantmentGlint m = new EnchantmentGlint(this.getName());
        m.setGlint(this.glint);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate if the item should glow or not";
        }
        try {
            this.glint = args[0].equalsIgnoreCase("reset") ? null : Boolean.valueOf(Boolean.parseBoolean(args[0]));
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid option";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<glow>", "true", "false", "reset");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

