/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class FireResistant
extends DynamicItemModifier {
    private Boolean fireResistant = true;

    public FireResistant(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ValhallaMMO.getNms().setFireResistant(context.getItem().getMeta(), this.fireResistant);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            this.fireResistant = e.isShiftClick() ? null : Boolean.valueOf(this.fireResistant == null || this.fireResistant == false);
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.BOOK).name("&eShould the item be fire resistant?").lore("&fSet to &e" + (this.fireResistant == null ? "reset" : (this.fireResistant != false ? "yes" : "no")), "&fIf yes, the item cannot be destroyed", "&fby lava or fire.", "&fIf no, the item will be destructible", "&fby lava or fire.", "&fIf reset, it will behave as normal.", "&6Click to toggle", "&6Shift-Click to reset").get()).map(Set.of());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.LAVA_BUCKET).get();
    }

    @Override
    public String getDisplayName() {
        return "&aSet Fire Resistant";
    }

    @Override
    public String getDescription() {
        return "&fMakes the item immune/vulnerable to lava/fire";
    }

    @Override
    public String getActiveDescription() {
        return "&fMakes the item " + (this.fireResistant == null ? "normally fire resistant." : (this.fireResistant != false ? "immune to lava or fire" : "vulnerable to lava or fire"));
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setFireResistant(Boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    @Override
    public DynamicItemModifier copy() {
        FireResistant m = new FireResistant(this.getName());
        m.setFireResistant(this.fireResistant);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate if the item should be immune to lava/fire damage or not";
        }
        try {
            this.fireResistant = args[0].equalsIgnoreCase("reset") ? null : Boolean.valueOf(Boolean.parseBoolean(args[0]));
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid option";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<fire_resistant>", "true", "false", "reset");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

