/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.throwable_weapon_animations.ThrowableItemStats;
import me.athlaeos.valhallammo.item.throwable_weapon_animations.ThrowableWeaponAnimationRegistry;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ThrowableWeapon
extends DynamicItemModifier {
    private String animationType = "vertical_spin";
    private int cooldown = 0;
    private double gravityStrength = 1.0;
    private double velocityDamageMultiplier = 0.3;
    private double defaultVelocity = 3.0;
    private double damageMultiplier = 1.0;
    private boolean infinity = false;
    private boolean returnsNaturally = false;

    public ThrowableWeapon(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ThrowableWeaponAnimationRegistry.setItemStats(context.getItem().getMeta(), new ThrowableItemStats(this.animationType, this.cooldown, this.gravityStrength, this.velocityDamageMultiplier, this.defaultVelocity, this.damageMultiplier, this.infinity, this.returnsNaturally));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 7) {
            ArrayList<String> animationTypes = new ArrayList<String>(ThrowableWeaponAnimationRegistry.getAnimations().keySet());
            int currentType = animationTypes.indexOf(this.animationType);
            currentType = e.isLeftClick() ? (currentType + 1 >= animationTypes.size() ? 0 : ++currentType) : (currentType - 1 < 0 ? animationTypes.size() - 1 : --currentType);
            this.animationType = (String)animationTypes.get(currentType);
        } else if (button == 10) {
            this.cooldown = Math.max(0, this.cooldown + (e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 20 : 2));
        } else if (button == 11) {
            this.gravityStrength = Math.max(0.0, this.gravityStrength + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 12) {
            this.velocityDamageMultiplier = Math.max(0.0, this.velocityDamageMultiplier + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 13) {
            this.defaultVelocity = Math.max(0.0, this.defaultVelocity + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 1.0 : 0.1));
        } else if (button == 14) {
            this.damageMultiplier = Math.max(0.0, this.damageMultiplier + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 16) {
            this.infinity = !this.infinity;
        } else if (button == 18) {
            this.returnsNaturally = !this.returnsNaturally;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(10, new ItemBuilder(Material.CLOCK).name("&eWhat should the cooldown be?").lore("&fSet to &e" + StatFormat.TIME_SECONDS_BASE_20_P1.format(this.cooldown), "&6Click to increase/decrease by 0.1s", "&6Shift-Click to increase/decrease by 1s").get()).map(Set.of(new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.ENDER_PEARL).name("&eWhat should the gravity be?").lore("&fSet to &e" + StatFormat.PERCENTILE_BASE_1_P1.format(this.gravityStrength), "&fDetermines how fast the thrown weapon should", "&fbe attracted to the ground", "&6Click to increase/decrease by 1%", "&6Shift-Click to increase/decrease by 10%").get()), new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.SPECTRAL_ARROW).name("&eWhat should the velocity-damage scale be?").lore("&fSet to &e" + StatFormat.PERCENTILE_BASE_1_P1.format(this.velocityDamageMultiplier), "&fDetermines how much weaker/stronger the", "&fweapon's damage should be relative to its", "&fstarting velocity. The given stat is equal", "&fto the damage buff if the weapon hits at 2x velocity.", "&e+40% velocity for example will do " + StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1.format(0.4 * this.velocityDamageMultiplier) + " damage", "&6Click to increase/decrease by 1%", "&6Shift-Click to increase/decrease by 10%").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.ARROW).name("&eWhat should base velocity be?").lore("&fSet to &e" + StatFormat.FLOAT_P2.format(this.defaultVelocity), "&fDetermines the starting velocity of", "&fthe weapon. For reference, a shot arrow", "&ffrom a fully-drawn bow will have a velocity", "&fof 3", "&6Click to increase/decrease by 0.1", "&6Shift-Click to increase/decrease by 1").get()), new Pair<Integer, ItemStack>(14, new ItemBuilder(Material.IRON_AXE).name("&eWhat should the damage conversion be?").lore("&fSet to &e" + StatFormat.PERCENTILE_BASE_1_P1.format(this.damageMultiplier), "&fDetermines what fraction of the weapon's", "&fbase damage should be converted as thrown", "&fdamage. A 9 damage axe for example will do", "&f" + StatFormat.FLOAT_P2.format(9.0 * this.damageMultiplier) + " damage when thrown", "&6Click to increase/decrease by 1%", "&6Shift-Click to increase/decrease by 10%").get()), new Pair<Integer, ItemStack>(16, new ItemBuilder(Material.ENCHANTED_BOOK).name("&eShould it be infinite?").lore("&fSet to &e" + this.infinity, "&fDetermines if the thrown item stays", "&fin your inventory after throwing.", "&fThrown items do not drop themselves", "&6Click to toggle").get()), new Pair<Integer, ItemStack>(18, new ItemBuilder(Material.TRIDENT).name("&eShould the item return naturally?").lore("&fSet to &e" + this.returnsNaturally, "&fDetermines if the thrown item should", "&ffly back to the thrower after having", "&fhit something.", "&fApplying the Loyalty enchantment also", "&fhas this effect", "&6Click to toggle").get()), new Pair<Integer, ItemStack>(7, new ItemBuilder(Material.PAINTING).name("&eWhat should the animation be?").lore("&fSet to &e" + this.animationType, "&fDetermines the flight pattern of", "&fthe weapon", "&6Click to cycle").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.DIAMOND_AXE).get();
    }

    @Override
    public String getDisplayName() {
        return "&eThrown Weapon";
    }

    @Override
    public String getDescription() {
        return "&fMakes the weapon throwable.";
    }

    @Override
    public String getActiveDescription() {
        return "&fMakes the item throwable.";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setAnimationType(String animationType) {
        this.animationType = animationType;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setDamageMultiplier(double damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void setDefaultVelocity(double defaultVelocity) {
        this.defaultVelocity = defaultVelocity;
    }

    public void setGravityStrength(double gravityStrength) {
        this.gravityStrength = gravityStrength;
    }

    public void setInfinity(boolean infinity) {
        this.infinity = infinity;
    }

    public void setReturnsNaturally(boolean returnsNaturally) {
        this.returnsNaturally = returnsNaturally;
    }

    public void setVelocityDamageMultiplier(double velocityDamageMultiplier) {
        this.velocityDamageMultiplier = velocityDamageMultiplier;
    }

    @Override
    public DynamicItemModifier copy() {
        ThrowableWeapon m = new ThrowableWeapon(this.getName());
        m.setAnimationType(this.animationType);
        m.setCooldown(this.cooldown);
        m.setDamageMultiplier(this.damageMultiplier);
        m.setDefaultVelocity(this.defaultVelocity);
        m.setGravityStrength(this.gravityStrength);
        m.setInfinity(this.infinity);
        m.setReturnsNaturally(this.returnsNaturally);
        m.setVelocityDamageMultiplier(this.velocityDamageMultiplier);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 8) {
            return "Missing some arguments to make the item throwable";
        }
        try {
            this.animationType = args[0];
            this.cooldown = Integer.parseInt(args[1]);
            this.damageMultiplier = StringUtils.parseDouble(args[2]);
            this.defaultVelocity = StringUtils.parseDouble(args[3]);
            this.gravityStrength = StringUtils.parseDouble(args[4]);
            this.velocityDamageMultiplier = StringUtils.parseDouble(args[5]);
            this.infinity = Boolean.parseBoolean(args[6]);
            this.returnsNaturally = Boolean.parseBoolean(args[7]);
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid argument(s) given";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return new ArrayList<String>(ThrowableWeaponAnimationRegistry.getAnimations().keySet());
        }
        if (currentArg == 1) {
            return List.of("<cooldown_in_ticks>", "10", "20", "100", "200");
        }
        if (currentArg == 2) {
            return List.of("<damage_multiplier>", "1", "1.5", "2");
        }
        if (currentArg == 3) {
            return List.of("<default_velocity>", "3", "10", "30");
        }
        if (currentArg == 4) {
            return List.of("<gravity>", "0", "0.5", "1", "2");
        }
        if (currentArg == 5) {
            return List.of("<velocity_damage>", "0", "1", "2", "3");
        }
        if (currentArg == 6) {
            return List.of("<infinity>", "true", "false");
        }
        if (currentArg == 7) {
            return List.of("<returning>", "true", "false");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 8;
    }
}

