/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class TransformItemMaterial
extends DynamicItemModifier {
    private static final Map<String, Map<EquipmentClass, Material>> classToMaterialMapping = new HashMap<String, Map<EquipmentClass, Material>>();
    private final Material icon;
    private final String materialPrefix;

    public TransformItemMaterial(String name, Material icon, String materialPrefix) {
        super(name);
        this.icon = icon;
        this.materialPrefix = materialPrefix;
        this.map(EquipmentClass.HELMET, materialPrefix, "_HELMET");
        this.map(EquipmentClass.CHESTPLATE, materialPrefix, "_CHESTPLATE");
        this.map(EquipmentClass.LEGGINGS, materialPrefix, "_LEGGINGS");
        this.map(EquipmentClass.BOOTS, materialPrefix, "_BOOTS");
        this.map(EquipmentClass.SWORD, materialPrefix, "_SWORD");
        this.map(EquipmentClass.PICKAXE, materialPrefix, "_PICKAXE");
        this.map(EquipmentClass.AXE, materialPrefix, "_AXE");
        this.map(EquipmentClass.SHOVEL, materialPrefix, "_SHOVEL");
        this.map(EquipmentClass.HOE, materialPrefix, "_HOE");
    }

    private void map(EquipmentClass equipmentClass, String material, String equipment) {
        Material m = ItemUtils.stringToMaterial(material + equipment, null);
        if (m == null) {
            return;
        }
        Map existingMaterials = classToMaterialMapping.getOrDefault(material, new HashMap());
        existingMaterials.put(equipmentClass, m);
        classToMaterialMapping.put(material, existingMaterials);
    }

    @Override
    public void processItem(ModifierContext context) {
        EquipmentClass equipmentClass = EquipmentClass.getMatchingClass(context.getItem().getMeta());
        if (equipmentClass == null) {
            return;
        }
        Material transformTo = (Material)((Map)classToMaterialMapping.getOrDefault(this.materialPrefix, new HashMap())).get((Object)equipmentClass);
        if (transformTo == null) {
            return;
        }
        context.getItem().type(transformTo);
        for (AttributeWrapper wrapper : ItemAttributesRegistry.getVanillaStats(transformTo).values()) {
            ItemAttributesRegistry.addDefaultStat(context.getItem(), wrapper.copy());
        }
        PotionEffectRegistry.updateEffectLore(context.getItem());
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new HashMap<Integer, ItemStack>();
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(this.icon).get();
    }

    @Override
    public String getDisplayName() {
        return "&7Equipment Upgrade: &e" + StringUtils.toPascalCase(this.materialPrefix);
    }

    @Override
    public String getDescription() {
        return "&fChanges the equipment's material to " + this.materialPrefix.toLowerCase(Locale.US) + ". This resets the item's stats and item meta";
    }

    @Override
    public String getActiveDescription() {
        return "&fChanges the equipment's material to " + this.materialPrefix.toLowerCase(Locale.US) + ".";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    @Override
    public DynamicItemModifier copy() {
        TransformItemMaterial m = new TransformItemMaterial(this.getName(), this.icon, this.materialPrefix);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 0;
    }
}

