/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MiningExceptionsAdd
extends DynamicItemModifier {
    private final Map<Material, Double> exceptions = new HashMap<Material, Double>();
    private Material exceptionMaterial = Material.STONE;
    private double value = 2.0;

    public MiningExceptionsAdd(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        for (Material m : this.exceptions.keySet()) {
            MiningSpeed.addException(context.getItem().getMeta(), m, this.exceptions.get(m));
            ValhallaMMO.getNms().addToolBlockRule(context.getItem().getMeta(), m, this.exceptions.get(m).floatValue());
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11) {
            if (!ItemUtils.isEmpty(e.getCursor()) && !e.getCursor().getType().isBlock()) {
                this.exceptionMaterial = e.getCursor().getType();
            }
        } else if (button == 13) {
            this.value = Math.min(0.0, this.value + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0 : 0.1));
        } else if (button == 17) {
            if (e.isShiftClick()) {
                this.exceptions.clear();
            } else {
                this.exceptions.put(this.exceptionMaterial, this.value);
            }
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(this.exceptionMaterial).name("&fSelect Material").lore("&e" + String.valueOf(this.exceptionMaterial) + "&7 is selected", "&fClick with a block in your inventory", "&fto select different material.").get()).map(Set.of(new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.DIAMOND_PICKAXE).name("&fMultiplier Value").lore("&fCurrently selected: &e" + this.value, "&6Click to add/subtract 0.1", "&6Shift-Click to add/subtract 1").get()), new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.STRUCTURE_VOID).name("&fConfirm Exception").lore("&f" + String.valueOf(this.exceptionMaterial) + " will be mined at " + this.value + "x", "&fspeed.", "&6Click to add exception", "&cShift-Click to clear exceptions", "&fCurrent exceptions:").appendLore(this.exceptions.entrySet().stream().map(e -> "&e" + String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue()) + "x").toList()).get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.WOODEN_PICKAXE).get();
    }

    @Override
    public String getDisplayName() {
        return "&7Mining Speed Exceptions";
    }

    @Override
    public String getDescription() {
        return "&fAdds a mining speed exception to the item. Blocks mined by these items will mine at a different multiplier than other blocks";
    }

    @Override
    public String getActiveDescription() {
        return "&fAdds the following mining speed exceptions to the item: /n&e" + this.exceptions.entrySet().stream().map(e -> "&e" + String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue()) + "x").collect(Collectors.joining("/n&e"));
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.CUSTOM_ATTRIBUTES.id());
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setExceptionMaterial(Material exceptionMaterial) {
        this.exceptionMaterial = exceptionMaterial;
    }

    public Map<Material, Double> getExceptions() {
        return this.exceptions;
    }

    @Override
    public DynamicItemModifier copy() {
        MiningExceptionsAdd m = new MiningExceptionsAdd(this.getName());
        m.setExceptionMaterial(this.exceptionMaterial);
        m.getExceptions().putAll(this.exceptions);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 2) {
            return "Two argument are expected: a material and a double";
        }
        try {
            Material m = Material.valueOf((String)args[0]);
            double value = StringUtils.parseDouble(args[1]);
            this.exceptions.put(m, value);
        }
        catch (IllegalArgumentException ignored) {
            return "Two argument are expected: a material and a double. At least one was not a valid argument";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(Material.values()).map(Object::toString).collect(Collectors.toList());
        }
        if (currentArg == 1) {
            return List.of("<multiplier>");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 2;
    }
}

