/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_effects;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PotionEffectAdd
extends DynamicItemModifier {
    private final String effect;
    private double value = 0.0;
    private long duration = 1800L;
    private int charges = -1;
    private final double smallIncrement;
    private final double bigIncrement;
    private final Material icon;

    public PotionEffectAdd(String name, String attribute, double smallIncrement, double bigIncrement, Material icon) {
        super(name);
        this.effect = attribute;
        this.smallIncrement = smallIncrement;
        this.bigIncrement = bigIncrement;
        this.icon = icon;
    }

    @Override
    public void processItem(ModifierContext context) {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        effect.setAmplifier(this.value);
        effect.setDuration(this.duration);
        effect.setCharges(ItemUtils.isConsumable(context.getItem().getItem().getType()) ? -1 : this.charges);
        PotionEffectRegistry.addDefaultEffect(context.getItem(), effect);
        PotionEffectRegistry.updateItemName(context.getItem(), false, false);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11) {
            this.value += (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? this.bigIncrement : this.smallIncrement);
            PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
            if (effect.isVanilla()) {
                this.value = Math.max(0.0, this.value);
            }
        } else if (button == 13) {
            this.duration = Math.max(0L, this.duration + (long)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 300 : 20)));
        } else if (button == 17) {
            this.charges = Math.max(-1, this.charges + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1));
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.PAPER).name("&dHow strong should this effect be?").lore("&f" + effect.getEffect().toLowerCase(Locale.US).replace("_", " ") + " " + effect.getFormat().format(this.value + (double)(effect.isVanilla() ? 1 : 0)) + " &f(" + StringUtils.toTimeStamp(this.duration, 20L) + ")", "&e" + String.format("%.2f", this.value), "&6Click to add/subtract " + this.smallIncrement, "&6Shift-Click to add/subtract " + this.bigIncrement).get()).map(Set.of(new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.PAPER).name("&dHow long should the duration be?").lore("&f" + effect.getEffect().toLowerCase(Locale.US).replace("_", " ") + " " + effect.getFormat().format(this.value + (double)(effect.isVanilla() ? 1 : 0)) + " &f(" + StringUtils.toTimeStamp(this.duration, 20L) + ")", "&6Click to add/subtract 1 second", "&6Shift-Click to add/subtract 15 seconds").get()), new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.FIREWORK_STAR).name("&dHow many charges should it have?").lore("&e" + (String)(this.charges < 0 ? "Infinite uses" : (this.charges == 0 ? "No uses" : this.charges + " uses")), "&fPotion effects can be applied to", "&foffensive items too. The 'charges'", "&frepresent how many times you can hit", "&fan entity and inflict them with the", "&feffect before it disappears off the", "&fitem. ", "&cIncompatible with consumables .", "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 5").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(this.icon).get();
    }

    @Override
    public String getDisplayName() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        return (effect.isVanilla() ? "&bVanilla" : "&dCustom") + " Potion Effect: " + effect.getEffect().toLowerCase(Locale.US).replace("_", " ") + " (ADD)";
    }

    @Override
    public String getDescription() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        return "&fAdds " + effect.getEffect().toLowerCase(Locale.US).replace("_", " ") + " as default effect to the item. ";
    }

    @Override
    public String getActiveDescription() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        return "&fAdds " + effect.getEffect().toLowerCase(Locale.US).replace("_", " ") + " " + effect.getFormat().format(this.value + (double)(effect.isVanilla() ? 1 : 0)) + " &f(" + StringUtils.toTimeStamp(this.duration, 20L) + ") to the item. ";
    }

    @Override
    public Collection<String> getCategories() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.effect);
        return effect.isVanilla() ? Set.of(ModifierCategoryRegistry.VANILLA_POTION_EFFECTS.id()) : Set.of(ModifierCategoryRegistry.CUSTOM_POTION_EFFECTS.id());
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setCharges(int charges) {
        this.charges = charges;
    }

    @Override
    public DynamicItemModifier copy() {
        PotionEffectAdd m = new PotionEffectAdd(this.getName(), this.effect, this.smallIncrement, this.bigIncrement, this.icon);
        m.setCharges(this.charges);
        m.setDuration(this.duration);
        m.setValue(this.value);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 3) {
            return "Three arguments expected: a double and two integers";
        }
        try {
            this.value = StringUtils.parseDouble(args[0]);
            this.duration = Long.parseLong(args[1]);
            this.charges = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException ignored) {
            return "Three arguments expected: a double and two integers. At least one was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<value>");
        }
        if (currentArg == 1) {
            return List.of("<duration>");
        }
        if (currentArg == 2) {
            return List.of("<charges>");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 3;
    }
}

