/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierScalingPresets;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.item.AlchemyItemPropertyManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ScaleAmplifier
extends DynamicItemModifier {
    private String presetScaling = null;
    private String commandScaling = null;
    private Scaling.ScalingMode mode = Scaling.ScalingMode.MULTIPLIER;
    private Double lowerBound = null;
    private Double upperBound = null;
    private double amplifier = 2.0;
    private double skillRange = 300.0;
    private double rangeOffset = 0.0;
    private double minimum = 1.0;
    private String skillToScaleWith = "ALCHEMY";
    private double skillEfficiency = 1.0;
    private double minimumValue = 0.0;

    public ScaleAmplifier(String name) {
        super(name);
    }

    private String buildScaling() {
        return String.format("(%.2f/%.2f) * (%%rating%% - %.2f) + %.2f", this.amplifier, this.skillRange, this.rangeOffset, this.minimum);
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    @Override
    public void processItem(ModifierContext context) {
        int skill;
        Scaling scaling = this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling) : new Scaling(Objects.requireNonNullElseGet(this.commandScaling, this::buildScaling), this.mode, this.lowerBound, this.upperBound);
        if (scaling == null) {
            this.failedRecipe(context.getItem(), "&cRecipe scaling wrongly configured, contact admin");
            return;
        }
        switch (this.skillToScaleWith) {
            case "SMITHING": {
                skill = SmithingItemPropertyManager.getQuality(context.getItem().getMeta());
                break;
            }
            case "ALCHEMY": {
                skill = AlchemyItemPropertyManager.getQuality(context.getItem().getMeta());
                break;
            }
            case "ENCHANTING": {
                skill = (int)AccumulativeStatManager.getCachedStats("ENCHANTING_QUALITY", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
                skill = (int)((double)skill * (1.0 + AccumulativeStatManager.getCachedStats("ENCHANTING_FRACTION_QUALITY", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics())));
                break;
            }
            default: {
                Skill s = SkillRegistry.getSkill(this.skillToScaleWith);
                Profile profile = ProfileCache.getOrCache(context.getCrafter(), s.getProfileType());
                skill = profile.getLevel();
            }
        }
        int finalQuality = (int)Math.round(this.skillEfficiency * (double)skill);
        AlchemyItemPropertyManager.applyAttributeScaling(context.getItem(), scaling, finalQuality, false, this.minimumValue, 0.0);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        switch (button) {
            case 0: {
                int currentScaling;
                ArrayList<String> scalings = new ArrayList<String>(ModifierScalingPresets.getScalings().keySet());
                int n = currentScaling = this.presetScaling == null ? -1 : scalings.indexOf(this.presetScaling);
                currentScaling = e.isLeftClick() ? (currentScaling + 1 >= scalings.size() ? 0 : ++currentScaling) : (currentScaling - 1 < 0 ? scalings.size() - 1 : --currentScaling);
                this.presetScaling = (String)scalings.get(currentScaling);
                break;
            }
            case 2: {
                this.mode = this.mode == Scaling.ScalingMode.MULTIPLIER ? Scaling.ScalingMode.ADD_ON_DEFAULT : Scaling.ScalingMode.MULTIPLIER;
                break;
            }
            case 9: {
                if (e.getClick() == ClickType.MIDDLE) {
                    this.upperBound = null;
                    break;
                }
                if (this.lowerBound != null) {
                    this.upperBound = Math.max(this.lowerBound, (this.upperBound == null ? 0.0 : this.upperBound) + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01));
                    break;
                }
                this.upperBound = (this.upperBound == null ? 0.0 : this.upperBound) + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01);
                break;
            }
            case 10: {
                this.amplifier += (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01);
                break;
            }
            case 11: {
                this.skillRange += (double)((e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 25 : 1));
                break;
            }
            case 12: {
                this.rangeOffset += (double)((e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 10 : 1));
                break;
            }
            case 13: {
                this.minimum += (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01);
                break;
            }
            case 14: {
                ArrayList<String> skills = new ArrayList<String>(SkillRegistry.getAllSkillsByType().keySet());
                skills.sort(Comparator.comparingInt(s -> SkillRegistry.getSkill(s).getSkillTreeMenuOrderPriority()));
                int currentSkill = skills.indexOf(this.skillToScaleWith);
                currentSkill = e.isLeftClick() ? (currentSkill + 1 >= skills.size() ? 0 : ++currentSkill) : (currentSkill - 1 < 0 ? skills.size() - 1 : --currentSkill);
                this.skillToScaleWith = (String)skills.get(currentSkill);
                break;
            }
            case 19: {
                if (e.getClick() == ClickType.MIDDLE) {
                    this.lowerBound = null;
                    break;
                }
                if (this.upperBound != null) {
                    this.lowerBound = Math.min(this.upperBound, (this.lowerBound == null ? 0.0 : this.lowerBound) + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01));
                    break;
                }
                this.lowerBound = (this.lowerBound == null ? 0.0 : this.lowerBound) + (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? 0.25 : 0.01);
                break;
            }
            case 21: {
                this.skillEfficiency = Math.max(0.0, this.skillEfficiency + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
                break;
            }
            case 23: {
                this.minimumValue = Math.max(0.0, this.minimumValue + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
            }
        }
        if (button != 0 && button != 21 && button != 23 && this.getButtons().containsKey(button)) {
            this.presetScaling = null;
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(21, new ItemBuilder(Material.NETHER_STAR).name("&fSkill Efficiency").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fSkill efficiency: %.0f%%", this.skillEfficiency * 100.0), String.format("&fMinimum fraction of amplifier: &e%.2fx", this.minimumValue), "&fSkill efficiency determines how much", String.format("&fof the player's &e%s&f skill is used ", StringUtils.toPascalCase(this.skillToScaleWith)), "&fin the formula.", "&6Click to add/subtract 1%", "&6Shift-Click to add/subtract 10%").get()).map(Set.of(new Pair<Integer, ItemStack>(23, new ItemBuilder(Material.PAPER).name("&fMinimum fraction").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), "&fThe resulting amplifier will always be at", String.format("&fleast &e%.2fx&f of its default", this.minimumValue), "&fvalue.", "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.1").get()), new Pair<Integer, ItemStack>(0, new ItemBuilder(Material.BOOK).name("&fPreset Scalings").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), "&fSets the amplifier to scale with a", "&fpreconfigured scaling formula.", "&fClicking another button removes", "&fthis scaling in favor of the custom", "&fone", "&6Click to cycle").get()), new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.REDSTONE_TORCH).name("&fScaling Mode").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), "&fSets the scaling behavior.", "&fADD_ON_DEFAULT adds the result of", "&fthe formula to the default amplifier.", "&fMULTIPLIER multiplies the default amplifier", "&fwith the result of the formula.", "&6Click to cycle").get()), new Pair<Integer, ItemStack>(9, new ItemBuilder(Material.LIME_DYE).name("&fUpper Bound").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %s", this.upperBound == null ? "none" : String.format("%.2f", this.upperBound)), "&fSets the maximum value that can", "&fbe produced with the formula.", "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.25", "&cMiddle-Click to remove").get()), new Pair<Integer, ItemStack>(10, new ItemBuilder(Material.GLOWSTONE_DUST).name("&fAmplifier").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %.2f", this.amplifier), "&fSets how much the formula will", "&fscale up over the course of", String.format("&e%.0f &f%s skill", this.skillRange, StringUtils.toPascalCase(this.skillToScaleWith)), "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.25").get()), new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.REDSTONE).name("&fSkill Range").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %.0f", this.skillRange), "&fSets the range of skill required ", String.format("&ffor the formula to go up by %.2f", this.amplifier), "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 25").get()), new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.PISTON).name("&fOffset").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %.0f", this.rangeOffset), "&fMoves the pivot point to a", "&fdifferent skill point.", "&aKeep in mind negative values equate", "&ato higher skill requirements.", "&fFor example, for -50 that means", String.format("&f50 skill is required to reach %.2f", this.minimum), "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 10").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.BOOK).name("&fMinimum (Pivot Point)").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %.0f", this.minimum), "&fSets the baseline value the", "&fformula will produce. ", String.format("&f%.0f skill is required to reach %.2f", -this.rangeOffset, this.minimum), "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.25").get()), new Pair<Integer, ItemStack>(14, new ItemBuilder(Material.BOOK).name("&fSkill to use").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %s", StringUtils.toPascalCase(this.skillToScaleWith)), "&fSets which skill should be used", "&fto define the scaling's strength", "&eSmithing and Alchemy are exceptions", "&fwhere they base %rating% off of the", "&fitem's quality instead of player skill", "&6Click to cycle").get()), new Pair<Integer, ItemStack>(19, new ItemBuilder(Material.LIME_DYE).name("&fLower Bound").lore(String.format("&fCurrent Scaling: &e%s", this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getExpression() : this.buildScaling()), String.format("&fCurrent Mode: &e%s", new Object[]{this.presetScaling != null ? ModifierScalingPresets.getScalings().get(this.presetScaling).getScalingType() : this.mode}), String.format("&fSet to: %s", this.lowerBound == null ? "none" : String.format("%.2f", this.lowerBound)), "&fSets the minimum value that can", "&fbe produced with the formula.", "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.25", "&cMiddle-Click to remove").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.GLOWSTONE_DUST).get();
    }

    @Override
    public String getDisplayName() {
        return "&eScale Potion Amplifier";
    }

    @Override
    public String getDescription() {
        return "&fScales the potion's amplifier according to a defined formula";
    }

    @Override
    public String getActiveDescription() {
        return String.format("&fScales the item's amplifier according to the formula %s, using the mode %s. %s%s", new Object[]{this.buildScaling(), this.mode, this.lowerBound == null ? "" : "&fResult cannot go below " + this.lowerBound + ". ", this.upperBound == null ? "" : "&fResult cannot go above " + this.upperBound + "."});
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.POTION_MISC.id());
    }

    public void setSkillEfficiency(double skillEfficiency) {
        this.skillEfficiency = skillEfficiency;
    }

    public void setLowerBound(Double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(Double upperBound) {
        this.upperBound = upperBound;
    }

    public void setAmplifier(double amplifier) {
        this.amplifier = amplifier;
    }

    public void setCommandScaling(String commandScaling) {
        this.commandScaling = commandScaling;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public void setMinimumValue(double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public void setMode(Scaling.ScalingMode mode) {
        this.mode = mode;
    }

    public void setPresetScaling(String presetScaling) {
        this.presetScaling = presetScaling;
    }

    public void setRangeOffset(double rangeOffset) {
        this.rangeOffset = rangeOffset;
    }

    public void setSkillRange(double skillRange) {
        this.skillRange = skillRange;
    }

    public void setSkillToScaleWith(String skillToScaleWith) {
        this.skillToScaleWith = skillToScaleWith;
    }

    public double getRangeOffset() {
        return this.rangeOffset;
    }

    public String getPresetScaling() {
        return this.presetScaling;
    }

    @Override
    public DynamicItemModifier copy() {
        ScaleAmplifier m = new ScaleAmplifier(this.getName());
        m.setPresetScaling(this.presetScaling);
        m.setAmplifier(this.amplifier);
        m.setCommandScaling(this.commandScaling);
        m.setMinimum(this.minimum);
        m.setLowerBound(this.lowerBound);
        m.setMinimumValue(this.minimumValue);
        m.setMode(this.mode);
        m.setRangeOffset(this.rangeOffset);
        m.setSkillEfficiency(this.skillEfficiency);
        m.setSkillRange(this.skillRange);
        m.setSkillToScaleWith(this.skillToScaleWith);
        m.setUpperBound(this.upperBound);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 6) {
            return "Six arguments are expected: two doubles, a formula, a mode, and a lower- and upper bound";
        }
        try {
            this.skillEfficiency = StringUtils.parseDouble(args[0]);
            this.minimumValue = StringUtils.parseDouble(args[1]);
            this.commandScaling = args[2];
            this.mode = Scaling.ScalingMode.valueOf(args[3]);
            this.lowerBound = Catch.catchOrElse(() -> StringUtils.parseDouble(args[4]), null);
            this.upperBound = Catch.catchOrElse(() -> StringUtils.parseDouble(args[5]), null);
        }
        catch (IllegalArgumentException ignored) {
            return "Six arguments are expected: two doubles, a formula, a mode, and a lower- and upper bound. At least one was not a number, or the mode could be incorrect";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<skill_efficiency>");
        }
        if (currentArg == 1) {
            return List.of("<minimum_fraction>");
        }
        if (currentArg == 2) {
            return List.of("<expression>");
        }
        if (currentArg == 3) {
            return Arrays.stream(Scaling.ScalingMode.values()).map(Enum::toString).collect(Collectors.toList());
        }
        if (currentArg == 4) {
            return List.of("<lower_bound_or_none>");
        }
        if (currentArg == 5) {
            return List.of("<upper_bound_or_none>");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 6;
    }
}

