/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.ingredientconfiguration;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.ArmorChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.ConfigurableMaterialsChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.ExactChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialItemExclusiveWithDataChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialWithDataChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialWithIDChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MeleeWeaponChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.PotionChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.PotionMatchEffectsChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.SimilarMaterialsChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.SimilarTypeChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.ToolArmorChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.ToolChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.WeaponChoice;

public class RecipeOptionRegistry {
    private static final Map<String, RecipeOption> options = new HashMap<String, RecipeOption>();

    public static void registerOption(RecipeOption c) {
        options.put(c.getName(), c);
    }

    public static Map<String, RecipeOption> getOptions() {
        return options;
    }

    public static RecipeOption createOption(String name) {
        if (!options.containsKey(name)) {
            throw new IllegalArgumentException("Recipe option " + name + " doesn't exist");
        }
        return options.get(name).getNew();
    }

    static {
        RecipeOptionRegistry.registerOption(new ExactChoice());
        RecipeOptionRegistry.registerOption(new MaterialChoice());
        RecipeOptionRegistry.registerOption(new MaterialWithDataChoice());
        RecipeOptionRegistry.registerOption(new ArmorChoice());
        RecipeOptionRegistry.registerOption(new SimilarMaterialsChoice());
        RecipeOptionRegistry.registerOption(new SimilarTypeChoice());
        RecipeOptionRegistry.registerOption(new ConfigurableMaterialsChoice());
        RecipeOptionRegistry.registerOption(new MaterialItemExclusiveWithDataChoice());
        RecipeOptionRegistry.registerOption(new PotionChoice());
        RecipeOptionRegistry.registerOption(new MaterialWithIDChoice());
        RecipeOptionRegistry.registerOption(new PotionMatchEffectsChoice());
        RecipeOptionRegistry.registerOption(new ToolArmorChoice());
        RecipeOptionRegistry.registerOption(new ToolChoice());
        RecipeOptionRegistry.registerOption(new WeaponChoice());
        RecipeOptionRegistry.registerOption(new MeleeWeaponChoice());
    }
}

