/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;

public class MaterialItemExclusiveWithDataChoice
extends RecipeOption {
    private Collection<Material> validChoices = new HashSet<Material>();

    @Override
    public String getName() {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return "CHOICE_MATERIAL_DATA_ITEM_EXCLUSIVE";
    }

    @Override
    public String getActiveDescription() {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return "This ingredient will need to match in any of " + (String)(this.validChoices.isEmpty() ? "invalid" : String.join((CharSequence)", ", this.validChoices.stream().map(m -> StringUtils.toPascalCase(m.toString().replace("_", " "))).collect(Collectors.toSet())) + ")") + " AND base item custom model data";
    }

    @Override
    public ItemStack getIcon() {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        ItemBuilder builder = new ItemBuilder(Material.RED_DYE).name("&7Material-data Requirement (Item exclusive)");
        if (!this.validChoices.isEmpty()) {
            builder.appendLore("&f" + String.valueOf(StringUtils.separateStringIntoLines(String.join((CharSequence)", ", this.validChoices.stream().map(m -> StringUtils.toPascalCase(m.toString().replace("_", " "))).collect(Collectors.toSet())), 40)));
        }
        builder.appendLore("&aRequire this ingredient to match only in", "&aany of the configured types and the custom", "&amodel data of the base item", "", "&7The name of the ingredient will be", "&7used to communicate item requirement", "&7to the player.");
        return builder.get();
    }

    @Override
    public boolean isCompatible(ItemStack i) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return true;
    }

    @Override
    public boolean isUnique() {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return false;
    }

    @Override
    public RecipeChoice getChoice(ItemStack i) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        ArrayList<Material> combined = new ArrayList<Material>(this.validChoices);
        combined.add(i.getType());
        return new RecipeChoice.MaterialChoice(combined.toArray(new Material[0]));
    }

    @Override
    public boolean matches(ItemStack i1, ItemStack i2) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        if (!this.validChoices.contains(i2.getType())) {
            return false;
        }
        ItemMeta i1Meta = i1.getItemMeta();
        ItemMeta i2Meta = i2.getItemMeta();
        if (i1Meta == null && i2Meta == null) {
            return true;
        }
        if (i1Meta == null || i2Meta == null) {
            return false;
        }
        if (!i1Meta.hasCustomModelData() && !i2Meta.hasCustomModelData()) {
            return true;
        }
        if (!i1Meta.hasCustomModelData() || !i2Meta.hasCustomModelData()) {
            return false;
        }
        return i1Meta.getCustomModelData() == i2Meta.getCustomModelData();
    }

    @Override
    public String ingredientDescription(ItemStack base) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return ItemUtils.getItemName(new ItemBuilder(base));
    }

    @Override
    public RecipeOption getNew() {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        MaterialItemExclusiveWithDataChoice choice = new MaterialItemExclusiveWithDataChoice();
        choice.validChoices = new HashSet<Material>(this.validChoices);
        return choice;
    }

    @Override
    public boolean isCompatibleWithInputItem(boolean isInput) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        return true;
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        if (this.validChoices == null) {
            this.validChoices = new HashSet<Material>();
        }
        if (e.isRightClick()) {
            this.validChoices.clear();
            PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()).addOption(this);
        } else if (this.validChoices.isEmpty() && ItemUtils.isEmpty(e.getCursor())) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cThis option must be configured first!");
        } else if (!ItemUtils.isEmpty(e.getCursor())) {
            this.validChoices.add(e.getCursor().getType());
            PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()).addOption(this);
        } else {
            super.onClick(e);
        }
    }
}

