/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.recipetypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaKeyedRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.SmithingTransformRecipeWrapper;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DynamicSmithingRecipe
implements ValhallaRecipe,
ValhallaKeyedRecipe {
    private final NamespacedKey key;
    private final String name;
    private String displayName = null;
    private String description = null;
    private SlotEntry template = new SlotEntry(new ItemBuilder(ItemUtils.stringToMaterial("NETHERITE_UPGRADE_SMITHING_TEMPLATE", Material.PAPER)).name("&r&fReplace me!").lore("&7I'm just a placeholder template!").get(), new MaterialChoice());
    private SlotEntry base = new SlotEntry(new ItemBuilder(Material.DIAMOND_SWORD).name("&r&fReplace me!").lore("&7I'm just a placeholder base!").get(), new MaterialChoice());
    private SlotEntry addition = new SlotEntry(new ItemBuilder(Material.NETHERITE_INGOT).name("&r&fReplace me!").lore("&7I'm just a placeholder addition!").get(), new MaterialChoice());
    private ItemStack result = new ItemBuilder(Material.NETHERITE_SWORD).name("&r&fReplace me!").lore("&7I'm just a placeholder result!").get();
    private boolean requireValhallaTools = false;
    private boolean tinkerBase = false;
    private boolean consumeAddition = true;
    private boolean hiddenFromBook = false;
    private List<DynamicItemModifier> resultModifiers = new ArrayList<DynamicItemModifier>();
    private List<DynamicItemModifier> additionModifiers = new ArrayList<DynamicItemModifier>();
    private boolean unlockedForEveryone = false;
    private Collection<String> validations = new HashSet<String>();

    public DynamicSmithingRecipe(String name) {
        this.name = name;
        this.key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "smithingrecipe_" + name);
    }

    @Override
    public void registerRecipe() {
        SmithingRecipe recipe = this.generateRecipe();
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.key) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.key);
        }
        if (recipe != null) {
            ValhallaMMO.getInstance().getServer().addRecipe((Recipe)recipe);
        }
    }

    @Override
    public void unregisterRecipe() {
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.key) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.key);
        }
    }

    private ItemStack translate(ItemStack i) {
        List<String> def = TranslationManager.getListTranslation("default_recipe_description_smithing");
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        ItemBuilder result = new ItemBuilder(this.result);
        return new ItemBuilder(i).lore(Arrays.asList(this.description == null ? def.toArray(new String[0]) : this.description.replace("%template%", SlotEntry.toString(this.template)).replace("%base%", SlotEntry.toString(this.base)).replace("%tinker%", this.tinkerBase ? SlotEntry.toString(this.base) : ItemUtils.getItemName(result)).replace("%result%", this.tinkerBase ? tinkerFormat.replace("%item%", SlotEntry.toString(this.base)) : ItemUtils.getItemName(result)).replace("%addition%", SlotEntry.toString(this.addition)).split("/n"))).name(this.displayName == null ? (this.tinkerBase ? tinkerFormat.replace("%item%", SlotEntry.toString(this.base)) : ItemUtils.getItemName(result)) : this.displayName).translate().get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public SlotEntry getTemplate() {
        return this.template;
    }

    public SlotEntry getBase() {
        return this.base;
    }

    public SlotEntry getAddition() {
        return this.addition;
    }

    public boolean requireValhallaTools() {
        return this.requireValhallaTools;
    }

    public boolean tinkerBase() {
        return this.tinkerBase;
    }

    public List<DynamicItemModifier> getResultModifiers() {
        return this.resultModifiers;
    }

    public List<DynamicItemModifier> getAdditionModifiers() {
        return this.additionModifiers;
    }

    @Override
    public boolean isUnlockedForEveryone() {
        return this.unlockedForEveryone;
    }

    public Collection<String> getValidations() {
        return this.validations;
    }

    public boolean consumeAddition() {
        return this.consumeAddition;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isHiddenFromBook() {
        return this.hiddenFromBook;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setTemplate(SlotEntry template) {
        this.template = template;
    }

    public void setBase(SlotEntry base) {
        this.base = base;
    }

    public void setAddition(SlotEntry addition) {
        this.addition = addition;
    }

    public void setRequireValhallaTools(boolean requireValhallaTools) {
        this.requireValhallaTools = requireValhallaTools;
    }

    public void setTinkerBase(boolean tinkerBase) {
        this.tinkerBase = tinkerBase;
    }

    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.resultModifiers = resultModifiers;
        DynamicItemModifier.sortModifiers(this.resultModifiers);
    }

    public void setAdditionModifiers(List<DynamicItemModifier> additionModifiers) {
        this.additionModifiers = additionModifiers;
        DynamicItemModifier.sortModifiers(this.additionModifiers);
    }

    public void setUnlockedForEveryone(boolean unlockedForEveryone) {
        this.unlockedForEveryone = unlockedForEveryone;
    }

    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    public void setConsumeAddition(boolean consumeAddition) {
        this.consumeAddition = consumeAddition;
    }

    public void setHiddenFromBook(boolean hiddenFromBook) {
        this.hiddenFromBook = hiddenFromBook;
    }

    public void convertTemplate() {
        ItemStack t;
        ItemStack itemStack = t = this.template == null ? null : this.template.getItem();
        if (t == null) {
            return;
        }
        ItemMeta meta = t.getItemMeta();
        if (meta == null) {
            return;
        }
        if (!meta.hasDisplayName()) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (!displayName.contains("REPLACEWITH:")) {
            return;
        }
        String[] args = displayName.split("REPLACEWITH:");
        if (args.length != 2) {
            return;
        }
        Material m = Catch.catchOrElse(() -> Material.valueOf((String)args[1]), null);
        if (m == null) {
            return;
        }
        this.template.setExactIngredient(new ItemStack(m));
    }

    public SmithingRecipe generateRecipe() {
        RecipeChoice.MaterialChoice t = null;
        if (this.template != null) {
            Object object = t = this.template.getOption() == null ? new RecipeChoice.MaterialChoice(this.template.getItem().getType()) : this.template.getOption().getChoice(this.template.getItem());
        }
        if (this.base == null || ItemUtils.isEmpty(this.base.getItem()) || this.addition == null || ItemUtils.isEmpty(this.addition.getItem())) {
            return null;
        }
        RecipeChoice.MaterialChoice b = this.base.getOption() == null ? new RecipeChoice.MaterialChoice(this.base.getItem().getType()) : this.base.getOption().getChoice(this.base.getItem());
        RecipeChoice.MaterialChoice a = this.addition.getOption() == null ? new RecipeChoice.MaterialChoice(this.addition.getItem().getType()) : this.addition.getOption().getChoice(this.addition.getItem());
        ItemStack i = this.result.clone();
        ResultChangingModifier changer = this.resultModifiers.stream().filter(m -> m instanceof ResultChangingModifier).reduce((first, second) -> second).orElse(null);
        if (changer != null) {
            i = Utils.thisorDefault(changer.getNewResult(ModifierContext.builder(new ItemBuilder(i)).get()), i);
        }
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20) && t != null) {
            return SmithingTransformRecipeWrapper.get(this.key, this.translate(i), (RecipeChoice)t, (RecipeChoice)b, (RecipeChoice)a);
        }
        return new SmithingRecipe(this.key, this.translate(i), (RecipeChoice)b, (RecipeChoice)a);
    }

    private boolean hasEquivalentVanillaSmithingRecipe(ItemStack template, ItemStack base, ItemStack addition) {
        if (base == null || addition == null) {
            return false;
        }
        boolean isTemplateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
        Iterator iterator = ValhallaMMO.getInstance().getServer().recipeIterator();
        while (iterator.hasNext()) {
            SmithingRecipe s;
            Object e = iterator.next();
            if (!(e instanceof SmithingRecipe) || !(s = (SmithingRecipe)e).getBase().test(base) || !s.getAddition().test(addition) || !s.getBase().test(base) || !s.getAddition().test(addition) || isTemplateCompatible && !SmithingTransformRecipeWrapper.templatesMatch(s, template)) continue;
            return true;
        }
        return false;
    }
}

