/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.localization.TranslationManager;
import org.jetbrains.annotations.NotNull;

public class CustomDamageType
implements Comparable<CustomDamageType> {
    private static final Map<String, CustomDamageType> damageToCustomTypeMapping = new HashMap<String, CustomDamageType>();
    private static final Map<String, CustomDamageType> registeredTypes = new HashMap<String, CustomDamageType>();
    public static final CustomDamageType FIRE = new CustomDamageType("FIRE", "FIRE", "LAVA", "MELTING", "FIRE_TICK", "HOT_FLOOR", "DRYOUT", "CAMPFIRE").additiveDamage("FIRE_DAMAGE_BONUS").multiplicativeDamage("FIRE_DAMAGE_DEALT").resistance("FIRE_RESISTANCE").immuneable().translation(TranslationManager.getTranslation("damage_type_fire")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_fire")).i("&f\uee6b&c").register();
    public static final CustomDamageType MAGIC = new CustomDamageType("MAGIC", "MAGIC", "THORNS", "DRAGON_BREATH").additiveDamage("MAGIC_DAMAGE_BONUS").multiplicativeDamage("MAGIC_DAMAGE_DEALT").resistance("MAGIC_RESISTANCE").immuneable().lifeStealable().translation(TranslationManager.getTranslation("damage_type_magic")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_magic")).i("&f\uee6c&d").register();
    public static final CustomDamageType PROJECTILE = new CustomDamageType("PROJECTILE", "PROJECTILE").multiplicativeDamage("RANGED_DAMAGE_DEALT").resistance("PROJECTILE_RESISTANCE").lifeStealable().translation(TranslationManager.getTranslation("damage_type_projectile")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_projectile")).i("&f\uee05&c").register();
    public static final CustomDamageType EXPLOSION = new CustomDamageType("EXPLOSION", "ENTITY_EXPLOSION", "BLOCK_EXPLOSION").additiveDamage("EXPLOSION_DAMAGE_BONUS").multiplicativeDamage("EXPLOSION_DAMAGE_DEALT").resistance("EXPLOSION_RESISTANCE").translation(TranslationManager.getTranslation("damage_type_explosion")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_explosion")).i("&f\uee6a&6").register();
    public static final CustomDamageType POISON = new CustomDamageType("POISON", "POISON").additiveDamage("POISON_DAMAGE_BONUS").multiplicativeDamage("POISON_DAMAGE_DEALT").setFatal(false).resistance("POISON_RESISTANCE").immuneable().translation(TranslationManager.getTranslation("damage_type_poison")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_poison")).i("&f\uee6d&2").register();
    public static final CustomDamageType FALLING = new CustomDamageType("FALLING", "FALL", "FLY_INTO_WALL").resistance("FALLING_RESISTANCE").translation(TranslationManager.getTranslation("damage_type_falling")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_falling")).i("&f\uee98&c").register();
    public static final CustomDamageType MELEE = new CustomDamageType("MELEE", "CONTACT", "ENTITY_ATTACK", "ENTITY_SWEEP_ATTACK").multiplicativeDamage("MELEE_DAMAGE_DEALT").resistance("MELEE_RESISTANCE").lifeStealable().translation(TranslationManager.getTranslation("damage_type_melee")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_melee")).i("&f\uee54&c").register();
    public static final CustomDamageType BLEED = new CustomDamageType("BLEED", "BLEED").resistance("BLEED_RESISTANCE").immuneable().lifeStealable().translation(TranslationManager.getTranslation("damage_type_bleeding")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_bleeding")).i("&f\uee09&4").register();
    public static final CustomDamageType FREEZING = new CustomDamageType("FREEZING", "FREEZE").additiveDamage("FREEZING_DAMAGE_BONUS").multiplicativeDamage("FREEZING_DAMAGE_DEALT").resistance("FREEZING_RESISTANCE").immuneable().translation(TranslationManager.getTranslation("damage_type_freezing")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_freezing")).i("&f\uee70&b").register();
    public static final CustomDamageType LIGHTNING = new CustomDamageType("LIGHTNING", "LIGHTNING").additiveDamage("LIGHTNING_DAMAGE_BONUS").multiplicativeDamage("LIGHTNING_DAMAGE_DEALT").resistance("LIGHTNING_RESISTANCE").immuneable().translation(TranslationManager.getTranslation("damage_type_lightning")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_lightning")).i("&f\uee6f&e").register();
    public static final CustomDamageType BLUDGEONING = new CustomDamageType("BLUDGEONING", "FALLING_BLOCK", "BLUDGEONING").additiveDamage("BLUDGEONING_DAMAGE_BONUS").multiplicativeDamage("BLUDGEONING_DAMAGE_DEALT").powerAttacks(true).resistance("BLUDGEONING_RESISTANCE").lifeStealable().translation(TranslationManager.getTranslation("damage_type_bludgeoning")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_bludgeoning")).i("&f\uee6e&c").register();
    public static final CustomDamageType RADIANT = new CustomDamageType("RADIANT", "RADIANT").additiveDamage("RADIANT_DAMAGE_BONUS").multiplicativeDamage("RADIANT_DAMAGE_DEALT").resistance("RADIANT_RESISTANCE").immuneable().lifeStealable().translation(TranslationManager.getTranslation("damage_type_radiant")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_radiant")).i("&f\uee71&f").register();
    public static final CustomDamageType NECROTIC = new CustomDamageType("NECROTIC", "NECROTIC", "WITHER").additiveDamage("NECROTIC_DAMAGE_BONUS").multiplicativeDamage("NECROTIC_DAMAGE_DEALT").resistance("NECROTIC_RESISTANCE").immuneable().lifeStealable().translation(TranslationManager.getTranslation("damage_type_necrotic")).indicator(ValhallaMMO.getPluginConfig().getString("damage_indicator_necrotic")).i("&f\uee72&7").register();
    public static final CustomDamageType OTHER = new CustomDamageType("OTHER", "SUFFOCATION", "CRAMMING", "CUSTOM").i("\ued18").immuneable().register();
    private final String type;
    private final Collection<String> subTypes = new HashSet<String>();
    private Animation hurtAnimation = null;
    private String resistanceStatSource = null;
    private String additiveDamageStatSource = null;
    private String translation = null;
    private String multiplicativeDamageStatSource = null;
    private String indicatorIcon = null;
    private String hardCodedIndicatorIcon = null;
    private boolean benefitsFromPowerAttacks = false;
    private boolean fatal = true;
    private boolean immuneable = false;
    private boolean canLifeSteal = false;

    public static void register(CustomDamageType type) {
        registeredTypes.put(type.type, type);
    }

    public static CustomDamageType getCustomType(String damageCause) {
        return damageToCustomTypeMapping.getOrDefault(damageCause, registeredTypes.get(damageCause));
    }

    public static Map<String, CustomDamageType> getRegisteredTypes() {
        return registeredTypes;
    }

    public CustomDamageType(String type, String ... subTypes) {
        this.type = type;
        this.subTypes.addAll(Set.of(subTypes));
        for (String cause : subTypes) {
            damageToCustomTypeMapping.put(cause, this);
        }
    }

    public CustomDamageType(String type, Collection<String> subTypes) {
        this.type = type;
        this.subTypes.addAll(subTypes);
        for (String cause : subTypes) {
            damageToCustomTypeMapping.put(cause, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public Collection<String> getSubTypes() {
        return this.subTypes;
    }

    public Animation getHurtAnimation() {
        return this.hurtAnimation;
    }

    public String getIndicatorIcon() {
        return this.indicatorIcon == null ? "" : this.indicatorIcon;
    }

    public String getHardCodedIndicatorIcon() {
        return this.hardCodedIndicatorIcon == null ? "" : this.hardCodedIndicatorIcon;
    }

    public void setHurtAnimation(Animation hurtAnimation) {
        this.hurtAnimation = hurtAnimation;
    }

    public String resistance() {
        return this.resistanceStatSource;
    }

    public String damageAdder() {
        return this.additiveDamageStatSource;
    }

    public String damageMultiplier() {
        return this.multiplicativeDamageStatSource;
    }

    public CustomDamageType resistance(String resistanceStatSource) {
        this.resistanceStatSource = resistanceStatSource;
        return this;
    }

    public CustomDamageType translation(String translation) {
        this.translation = translation;
        return this;
    }

    public CustomDamageType immuneable() {
        this.immuneable = true;
        return this;
    }

    public CustomDamageType lifeStealable() {
        this.canLifeSteal = true;
        return this;
    }

    public CustomDamageType additiveDamage(String additiveDamageStatSource) {
        this.additiveDamageStatSource = additiveDamageStatSource;
        return this;
    }

    public CustomDamageType multiplicativeDamage(String multiplicativeDamageStatSource) {
        this.multiplicativeDamageStatSource = multiplicativeDamageStatSource;
        return this;
    }

    public CustomDamageType indicator(String indicatorIcon) {
        this.indicatorIcon = indicatorIcon;
        return this;
    }

    private CustomDamageType i(String hardCodedIndicatorIcon) {
        this.hardCodedIndicatorIcon = hardCodedIndicatorIcon;
        return this;
    }

    public CustomDamageType powerAttacks(boolean benefitsFromPowerAttacks) {
        this.benefitsFromPowerAttacks = benefitsFromPowerAttacks;
        return this;
    }

    public CustomDamageType setFatal(boolean fatal) {
        this.fatal = fatal;
        return this;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public boolean isImmuneable() {
        return this.immuneable;
    }

    public String getTranslation() {
        return this.translation;
    }

    public boolean benefitsFromPowerAttacks() {
        return this.benefitsFromPowerAttacks;
    }

    public boolean canLifeSteal() {
        return this.canLifeSteal;
    }

    public CustomDamageType register() {
        CustomDamageType.register(this);
        return this;
    }

    @Override
    public int compareTo(@NotNull CustomDamageType o) {
        return this.type.compareTo(o.getType());
    }
}

