/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import org.bukkit.entity.Player;

public class Questionnaire {
    private static final Map<UUID, Questionnaire> questioningPlayers = new HashMap<UUID, Questionnaire>();
    private final Player who;
    private final List<Question> questions;
    private final Action<Player> onStart;
    private final Action<Player> onFinish;

    public static void startQuestionnaire(Player who, Questionnaire questionnaire) {
        questioningPlayers.put(who.getUniqueId(), questionnaire);
        questionnaire.start();
    }

    public static Questionnaire getActiveQuestionnaire(Player who) {
        return questioningPlayers.get(who.getUniqueId());
    }

    public Questionnaire(Player who, Action<Player> onStart, Action<Player> onFinish, Question ... questions) {
        this.who = who;
        this.questions = Arrays.asList(questions);
        this.onStart = onStart;
        this.onFinish = onFinish;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void addQuestion(Question question) {
        this.questions.add(question);
    }

    public Action<Player> getOnStart() {
        return this.onStart;
    }

    public Player getWho() {
        return this.who;
    }

    public Action<Player> getOnFinish() {
        return this.onFinish;
    }

    public void start() {
        Question next;
        if (this.onStart != null) {
            this.getOnStart().act(this.getWho());
        }
        if ((next = this.nextQuestion()) == null) {
            this.finish();
        } else {
            next.ask(this.getWho());
        }
    }

    public Question nextQuestion() {
        if (this.allAnswered()) {
            this.finish();
            return null;
        }
        return this.getQuestions().stream().filter(q -> q.getAnswer() == null).findFirst().orElse(null);
    }

    public boolean allAnswered() {
        return this.getQuestions().stream().allMatch(q -> q.getAnswer() != null);
    }

    public void finish() {
        questioningPlayers.remove(this.who.getUniqueId());
        if (this.getOnFinish() != null) {
            this.getOnFinish().act(this.who);
        }
    }
}

