/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.entities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.entities.Dummy;
import me.athlaeos.valhallammo.entities.EntityAttributeStats;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.event.EntityUpdateLevelEvent;
import me.athlaeos.valhallammo.hooks.MythicMobsHook;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Boss;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MonsterScalingManager {
    private static final NamespacedKey ENTITY_LEVEL = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "entity_level");
    private static boolean enabled = false;
    private static boolean monstersOnly = true;
    private static String regionalPlayerLevel = null;
    private static final Map<String, String> globalStatScaling = new HashMap<String, String>();
    private static final Map<String, String> defaultStatScaling = new HashMap<String, String>();
    private static String defaultLevelScaling = null;
    private static String defaultExpOrbScaling = null;
    private static String defaultLootScaling = null;
    private static final Map<EntityType, Map<String, String>> entityStatScaling = new HashMap<EntityType, Map<String, String>>();
    private static final Map<EntityType, String> entityLevelScaling = new HashMap<EntityType, String>();
    private static final Map<EntityType, String> entityExpOrbScaling = new HashMap<EntityType, String>();
    private static final Map<EntityType, String> entityLootScaling = new HashMap<EntityType, String>();
    private static boolean wolfLeveling = false;
    private static String defaultWolfLevelScaling = null;
    private static final Map<UUID, Double> regionalMonsterLevelCache = new HashMap<UUID, Double>();

    public static void loadMonsterScalings() {
        ConfigurationSection entityStats;
        ConfigurationSection defaultStats;
        YamlConfiguration config = ConfigManager.getConfig("mob_stats.yml").reload().get();
        enabled = config.getBoolean("enabled");
        if (!enabled) {
            return;
        }
        monstersOnly = config.getBoolean("monsters_only", true);
        regionalPlayerLevel = config.getString("regional_player_level");
        wolfLeveling = config.getBoolean("wolf_leveling");
        defaultWolfLevelScaling = config.getString("default_wolf_leveling");
        ConfigurationSection globalStats = config.getConfigurationSection("global");
        if (globalStats != null) {
            for (Object stat : globalStats.getKeys(false)) {
                if (!AccumulativeStatManager.getSources().containsKey(stat)) {
                    ValhallaMMO.logWarning("Invalid global stat " + (String)stat + " referenced in mob_stats.yml");
                    continue;
                }
                globalStatScaling.put((String)stat, config.getString("global." + (String)stat));
            }
        }
        if ((defaultStats = config.getConfigurationSection("default")) != null) {
            for (String stat : defaultStats.getKeys(false)) {
                if (stat.equals("level")) {
                    defaultLevelScaling = config.getString("default.level");
                    continue;
                }
                if (stat.equals("exp_orb_bonus")) {
                    defaultExpOrbScaling = config.getString("default.exp_orb_bonus");
                    continue;
                }
                if (stat.equals("loot_bonus")) {
                    defaultLootScaling = config.getString("default.loot_bonus");
                    continue;
                }
                if (!AccumulativeStatManager.getSources().containsKey(stat)) {
                    ValhallaMMO.logWarning("Invalid default stat " + stat + " referenced in mob_stats.yml");
                    continue;
                }
                defaultStatScaling.put(stat, config.getString("default." + stat));
            }
        }
        if ((entityStats = config.getConfigurationSection("entity")) != null) {
            for (String entity : entityStats.getKeys(false)) {
                Map existingStats;
                ConfigurationSection stats;
                EntityType e = Catch.catchOrElse(() -> EntityType.valueOf((String)entity), null);
                if (e == null || (stats = config.getConfigurationSection("entity." + entity)) == null) continue;
                for (String stat : stats.getKeys(false)) {
                    if (stat.equals("level")) {
                        entityLevelScaling.put(e, config.getString("entity." + entity + ".level"));
                        continue;
                    }
                    if (stat.equals("exp_orb_bonus")) {
                        entityExpOrbScaling.put(e, config.getString("entity." + entity + ".exp_orb_bonus"));
                        continue;
                    }
                    if (stat.equals("loot_bonus")) {
                        entityLootScaling.put(e, config.getString("entity." + entity + ".loot_bonus"));
                        continue;
                    }
                    if (!AccumulativeStatManager.getSources().containsKey(stat)) {
                        ValhallaMMO.logWarning("Invalid " + entity + " stat " + stat + " referenced in mob_stats.yml");
                        continue;
                    }
                    existingStats = entityStatScaling.getOrDefault(e, new HashMap());
                    existingStats.put(stat, config.getString("entity." + entity + "." + stat));
                    entityStatScaling.put(e, existingStats);
                }
                for (String stat : defaultStatScaling.keySet()) {
                    if (!entityStatScaling.containsKey(e) || entityStatScaling.get(e).containsKey(stat)) continue;
                    existingStats = entityStatScaling.getOrDefault(e, new HashMap());
                    existingStats.put(stat, defaultStatScaling.get(stat));
                    entityStatScaling.put(e, existingStats);
                }
            }
        }
    }

    public static double getExpOrbMultiplier(LivingEntity entity) {
        if (EntityClassification.matchesClassification(entity.getType(), EntityClassification.UNALIVE)) {
            return 0.0;
        }
        if (!enabled || monstersOnly && EntityClassification.matchesClassification(entity.getType(), EntityClassification.PASSIVE) && !(entity instanceof Boss) || entity instanceof Player) {
            return 0.0;
        }
        int level = MonsterScalingManager.getLevel(entity);
        if (level < 0) {
            return 0.0;
        }
        if (entityExpOrbScaling.containsKey(entity.getType())) {
            String expScaling = entityExpOrbScaling.get(entity.getType());
            if (expScaling == null) {
                return 0.0;
            }
            return Utils.eval(MonsterScalingManager.parseRand(expScaling.replace("%level%", String.valueOf(level))));
        }
        if (defaultExpOrbScaling != null) {
            return Utils.eval(MonsterScalingManager.parseRand(defaultExpOrbScaling.replace("%level%", String.valueOf(level))));
        }
        return 0.0;
    }

    public static double getLootMultiplier(LivingEntity entity) {
        if (EntityClassification.matchesClassification(entity.getType(), EntityClassification.UNALIVE)) {
            return 0.0;
        }
        if (!enabled || monstersOnly && EntityClassification.matchesClassification(entity.getType(), EntityClassification.PASSIVE) && !(entity instanceof Boss) || entity instanceof Player) {
            return 0.0;
        }
        int level = MonsterScalingManager.getLevel(entity);
        if (level < 0) {
            return 0.0;
        }
        if (entityLootScaling.containsKey(entity.getType())) {
            String expScaling = entityLootScaling.get(entity.getType());
            if (expScaling == null) {
                return 0.0;
            }
            return Utils.eval(MonsterScalingManager.parseRand(expScaling.replace("%level%", String.valueOf(level))));
        }
        if (defaultLootScaling != null) {
            return Utils.eval(MonsterScalingManager.parseRand(defaultLootScaling.replace("%level%", String.valueOf(level))));
        }
        return 0.0;
    }

    public static double getStatValue(LivingEntity entity, String stat) {
        boolean isDummy = Dummy.isDummy(entity);
        if (!enabled || isDummy || EntityClassification.matchesClassification(entity.getType(), EntityClassification.UNALIVE)) {
            return 0.0;
        }
        int level = Math.max(0, MonsterScalingManager.getLevel(entity));
        if (ValhallaMMO.isHookFunctional(MythicMobsHook.class) && MythicMobsHook.isMythicMob((Entity)entity)) {
            return MythicMobsHook.getMythicMobStat(stat, (Entity)entity);
        }
        if (entityStatScaling.containsKey(entity.getType())) {
            Map entityStats = entityStatScaling.getOrDefault(entity.getType(), new HashMap());
            if (!entityStats.containsKey(stat)) {
                return 0.0;
            }
            return Utils.eval(MonsterScalingManager.parseRand(entityStatScaling.get(entity.getType()).get(stat).replace("%level%", String.valueOf(level))));
        }
        if ((!EntityClassification.matchesClassification(entity.getType(), EntityClassification.PASSIVE) || entity instanceof Boss || wolfLeveling && entity instanceof Wolf) && defaultStatScaling.containsKey(stat)) {
            return Utils.eval(MonsterScalingManager.parseRand(defaultStatScaling.get(stat).replace("%level%", String.valueOf(level))));
        }
        if (globalStatScaling.containsKey(stat)) {
            return Utils.eval(MonsterScalingManager.parseRand(globalStatScaling.get(stat).replace("%level%", String.valueOf(level))));
        }
        return 0.0;
    }

    public static int getLevel(LivingEntity entity) {
        return enabled ? (Integer)entity.getPersistentDataContainer().getOrDefault(ENTITY_LEVEL, PersistentDataType.INTEGER, (Object)-1) : 0;
    }

    public static void setLevel(LivingEntity entity, int level) {
        if (entity instanceof Player) {
            return;
        }
        EntityUpdateLevelEvent event = new EntityUpdateLevelEvent(entity, level);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        level = event.getLevel();
        if (level >= 0) {
            entity.getPersistentDataContainer().set(ENTITY_LEVEL, PersistentDataType.INTEGER, (Object)level);
        } else {
            entity.getPersistentDataContainer().remove(ENTITY_LEVEL);
        }
        EntityAttributeStats.updateStats(entity);
    }

    public static int getNewLevel(LivingEntity entity) {
        if (EntityClassification.matchesClassification(entity.getType(), EntityClassification.UNALIVE)) {
            return -1;
        }
        if (!enabled || monstersOnly && EntityClassification.matchesClassification(entity.getType(), EntityClassification.PASSIVE) && !(entity instanceof Boss) || entity instanceof Player) {
            return -1;
        }
        int powerLevel = (int)Math.round(MonsterScalingManager.getAreaDifficultyLevel(entity.getLocation(), null));
        if (entityLevelScaling.containsKey(entity.getType())) {
            return Math.max(0, (int)Utils.eval(MonsterScalingManager.parseRand(entityLevelScaling.get(entity.getType()).replace("%level%", String.valueOf(powerLevel)))));
        }
        if (defaultLevelScaling != null) {
            return Math.max(0, (int)Utils.eval(MonsterScalingManager.parseRand(defaultLevelScaling.replace("%level%", String.valueOf(powerLevel)))));
        }
        return -1;
    }

    public static boolean updateWolfLevel(Wolf wolf, AnimalTamer tamer) {
        int level;
        Player player;
        block12: {
            block11: {
                if (!(tamer instanceof Player)) break block11;
                player = (Player)tamer;
                if (tamer.getUniqueId().equals(player.getUniqueId()) && wolfLeveling) break block12;
            }
            return false;
        }
        int levelBefore = MonsterScalingManager.getLevel((LivingEntity)wolf);
        PowerProfile profile = ProfileCache.getOrCache(player, PowerProfile.class);
        if (entityLevelScaling.containsKey(EntityType.WOLF)) {
            level = Math.max(0, (int)Utils.eval(entityLevelScaling.get(EntityType.WOLF).replace("%level%", String.valueOf(profile.getLevel()))));
        } else if (defaultWolfLevelScaling != null) {
            level = Math.max(0, (int)Utils.eval(defaultWolfLevelScaling.replace("%level%", String.valueOf(profile.getLevel()))));
        } else {
            return false;
        }
        EntityUpdateLevelEvent event = new EntityUpdateLevelEvent((LivingEntity)wolf, level);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        level = event.getLevel();
        if (level == levelBefore) {
            return false;
        }
        if (level >= 0) {
            wolf.getPersistentDataContainer().set(ENTITY_LEVEL, PersistentDataType.INTEGER, (Object)level);
        } else {
            wolf.getPersistentDataContainer().remove(ENTITY_LEVEL);
        }
        EntityAttributeStats.updateStats((LivingEntity)wolf);
        return true;
    }

    public static double getAreaDifficultyLevel(Location l, Player cacheFor) {
        double level;
        if (!enabled || l.getWorld() == null) {
            return 0.0;
        }
        List<Player> players = EntityUtils.getNearbyPlayers(l, 128.0, false);
        int combinedLevel = 0;
        int lowest = -1;
        int highest = -1;
        for (Player p : players) {
            if (p.getGameMode() != GameMode.SURVIVAL) continue;
            PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
            combinedLevel += profile.getLevel();
            if (lowest < 0 || lowest > profile.getLevel()) {
                lowest = profile.getLevel();
            }
            if (highest >= 0 && highest >= profile.getLevel()) continue;
            highest = profile.getLevel();
        }
        double d = level = regionalPlayerLevel == null ? (double)combinedLevel / (double)players.size() : Utils.eval(regionalPlayerLevel.replace("%combined_player_level%", String.valueOf(combinedLevel)).replace("%nearby_player_count%", String.valueOf(players.size())).replace("%min_player_level%", String.valueOf(lowest)).replace("%max_player_level%", String.valueOf(highest)));
        if (cacheFor != null) {
            regionalMonsterLevelCache.put(cacheFor.getUniqueId(), level);
        }
        return level;
    }

    public static double getCachedDifficultyLevel(Player from) {
        if (Timer.isCooldownPassed(from.getUniqueId(), "delay_regional_difficulty_cache_update")) {
            ValhallaMMO.getInstance().getServer().getScheduler().runTask((Plugin)ValhallaMMO.getInstance(), () -> MonsterScalingManager.getAreaDifficultyLevel(from.getLocation(), from));
            Timer.setCooldown(from.getUniqueId(), 10000, "delay_regional_difficulty_cache_update");
        }
        return regionalMonsterLevelCache.getOrDefault(from.getUniqueId(), 0.0);
    }

    private static String parseRand(String expression) {
        String[] rands = StringUtils.substringsBetween((String)expression, (String)"rand(", (String)")");
        if (rands == null) {
            return expression;
        }
        for (String rand : rands) {
            String[] args = rand.split(",");
            if (args.length == 1) {
                expression = expression.replaceFirst(Pattern.quote("rand(" + rand + ")"), String.valueOf(Utils.getRandom().nextInt(Integer.parseInt(args[0]))));
                continue;
            }
            if (args.length != 2) continue;
            int lower = Integer.parseInt(args[0].trim());
            int upper = Integer.parseInt(args[1].trim());
            expression = expression.replaceFirst(Pattern.quote("rand(" + rand + ")"), String.valueOf(Utils.getRandom().nextInt(upper - lower + 1) + lower));
        }
        return expression;
    }
}

