/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetStatsMenu;
import me.athlaeos.valhallammo.gui.implementations.StatSelectionMenu;
import me.athlaeos.valhallammo.item.ArmorSet;
import me.athlaeos.valhallammo.item.ArmorSetRegistry;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArmorSetEditor
extends Menu
implements SetStatsMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final int backToMenuButtonIndex = 53;
    private static final int deleteButtonIndex = 45;
    private static final int nextPageButtonIndex = 53;
    private static final int previousPageButtonIndex = 45;
    private static final int statsButtonIndex = 31;
    private static final int nameButtonIndex = 12;
    private static final int loreButtonIndex = 13;
    private static final int amountRequiredButtonIndex = 14;
    private static final ItemStack createNewButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_armorset_newentry", Material.LIME_DYE)).name("&b&lNew Entry").stringTag(BUTTON_ACTION_KEY, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack nextPageButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(BUTTON_ACTION_KEY, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(BUTTON_ACTION_KEY, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private static final ItemStack setAmountRequiredButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_armorset_setrequired", Material.DIAMOND_CHESTPLATE)).name("&dSet Size").lore("&fDetermines how many pieces", "&fof this set the player has", "&fto wear to get the set bonus.").stringTag(BUTTON_ACTION_KEY, "setAmountRequiredButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setNameButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_armorset_setname", Material.NAME_TAG)).name("&dSet Name").lore("&fDetermines the set name displayed", "&fon the set items.").stringTag(BUTTON_ACTION_KEY, "setNameButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setLoreButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_armorset_setlore", Material.WRITABLE_BOOK)).name("&dSet Lore").lore("&fDetermines the lore displayed", "&fon the set items when wearing", "&fa full set").stringTag(BUTTON_ACTION_KEY, "setLoreButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setStatsButton = new ItemBuilder(ArmorSetEditor.getButtonData("editor_armorset_setstats", Material.PAPER)).name("&dSet Stats").lore("&fDetermines the stats given", "&fto players wearing a complete", "&fset.").stringTag(BUTTON_ACTION_KEY, "setStatsButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private int page = 0;
    private ArmorSet currentSet = null;
    boolean confirmDeletion = false;

    public ArmorSetEditor(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf31a" : TranslationManager.getTranslation("editormenu_armorsets"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ArmorSet set;
        String data;
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    this.currentSet = null;
                    break;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this armor set?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick() || this.currentSet == null) break;
                    ArmorSetRegistry.getRegisteredSets().remove(this.currentSet.getId());
                    this.currentSet = null;
                    return;
                }
                case "setAmountRequiredButton": {
                    this.currentSet.setPiecesRequired(Math.max(0, this.currentSet.getPiecesRequired() + (e.isRightClick() ? -1 : 1)));
                    break;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "setStatsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new StatSelectionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the set's id be? (type in chat, or 'cancel' to cancel)", s -> !ArmorSetRegistry.getRegisteredSets().containsKey(s), "&cArmor set with this key already exists! Try again")}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer().replaceAll(" ", "_").toLowerCase(Locale.US);
                                if (answer.contains("cancel")) {
                                    ArmorSetEditor.this.playerMenuUtility.getPreviousMenu().open();
                                } else if (ArmorSetRegistry.getRegisteredSets().containsKey(answer)) {
                                    Utils.sendMessage((CommandSender)this.getWho(), "&cArmor set id already exists!");
                                } else {
                                    ArmorSetRegistry.register(new ArmorSet(answer));
                                    ArmorSetEditor.this.playerMenuUtility.getPreviousMenu().open();
                                }
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                    break;
                }
                case "setNameButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the set's name be? (type in chat, 'cancel' to cancel, or 'clear' to clear)", null, null)}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer();
                                if (!answer.contains("cancel")) {
                                    if (answer.equalsIgnoreCase("clear")) {
                                        answer = null;
                                    }
                                    ArmorSetEditor.this.currentSet.setName(answer);
                                }
                                ArmorSetEditor.this.playerMenuUtility.getPreviousMenu().open();
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                    break;
                }
                case "setLoreButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the set's lore be? (type in chat, 'cancel' to cancel, or 'clear' to clear. Use /n for new lines)", null, null)}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer();
                                if (!answer.contains("cancel")) {
                                    if (answer.equalsIgnoreCase("clear")) {
                                        answer = null;
                                    }
                                    ArmorSetEditor.this.currentSet.setLore(answer == null ? new ArrayList<String>() : new ArrayList<String>(List.of(answer.split("/n"))));
                                }
                                ArmorSetEditor.this.playerMenuUtility.getPreviousMenu().open();
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                }
            }
        }
        if (!StringUtils.isEmpty(data = ItemUtils.getPDCString(BUTTON_DATA, clicked, null)) && (set = ArmorSetRegistry.getRegisteredSets().get(data)) != null) {
            this.currentSet = set;
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (this.currentSet != null) {
            this.inventory.setItem(12, new ItemBuilder(setNameButton).name("&eSet Name: " + (this.currentSet.getName() == null ? "Nothing" : this.currentSet.getName())).get());
            this.inventory.setItem(13, new ItemBuilder(setLoreButton).name("&eSet Lore").prependLore("&8&m                          ").prependLore(this.currentSet.getLore()).prependLore(this.currentSet.getLore().isEmpty() ? "&fNo lore set" : "&fSet to").get());
            this.inventory.setItem(14, new ItemBuilder(setAmountRequiredButton).name("&eAmount Required: " + this.currentSet.getPiecesRequired()).get());
            this.inventory.setItem(31, new ItemBuilder(setStatsButton).prependLore("&8&m                          ").prependLore(this.currentSet.getSetBonus().isEmpty() ? List.of("&cNo stats set") : this.currentSet.getSetBonus().keySet().stream().map(a -> {
                AttributeWrapper wrapper = ItemAttributesRegistry.getCopy(a);
                if (wrapper == null) {
                    return null;
                }
                wrapper.setValue(this.currentSet.getSetBonus().get(a));
                return wrapper.getLoreDisplay();
            }).toList()).get());
            this.inventory.setItem(53, backToMenuButton);
            this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        } else {
            ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
            for (ArmorSet set : ArmorSetRegistry.getRegisteredSets().values()) {
                ItemBuilder icon = new ItemBuilder(Material.NAME_TAG).stringTag(BUTTON_DATA, set.getId()).name("&f" + (set.getName() == null ? set.getId() : set.getName())).lore(set.getLore().isEmpty() ? List.of("&7No lore") : set.getLore()).appendLore("&8&m                          ").appendLore(set.getSetBonus().isEmpty() ? List.of("&cNo stats") : set.getSetBonus().keySet().stream().map(a -> {
                    AttributeWrapper wrapper = ItemAttributesRegistry.getCopy(a);
                    if (wrapper == null) {
                        return null;
                    }
                    wrapper.setValue(set.getSetBonus().get(a));
                    return wrapper.getLoreDisplay();
                }).toList());
                icons.add(icon.get());
            }
            icons.add(createNewButton);
            Map pages = Utils.paginate(45, icons);
            this.page = Math.max(1, Math.min(this.page, pages.size()));
            if (!pages.isEmpty()) {
                int index = 0;
                for (ItemStack i : pages.get(this.page - 1)) {
                    this.inventory.setItem(index, i);
                    ++index;
                }
            }
            if (this.page > 0 && this.page < pages.size()) {
                this.inventory.setItem(45, previousPageButton);
            }
            if (this.page < pages.size()) {
                this.inventory.setItem(53, nextPageButton);
            }
        }
    }

    @Override
    public void setStats(Map<String, Double> stats) {
        this.currentSet.setSetBonus(stats);
    }

    @Override
    public Map<String, Double> getStats() {
        return this.currentSet.getSetBonus();
    }
}

