/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetLootPredicatesMenu;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.LootPoolEditor;
import me.athlaeos.valhallammo.gui.implementations.LootPredicateMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class LootEntryEditor
extends Menu
implements SetModifiersMenu,
SetLootPredicatesMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int predicatesIndex = 1;
    private static final int predicateTypeIndex = 2;
    private static final int dropIndex = 4;
    private static final int baseQuantityIndex = 6;
    private static final int fortuneQuantityIndex = 7;
    private static final int guaranteedPresentIndex = 13;
    private static final int chanceWeightBaseIndex3 = 19;
    private static final int chanceWeightBaseIndex2 = 20;
    private static final int chanceWeightBaseIndex1 = 21;
    private static final int chanceWeightLuckIndex1 = 23;
    private static final int chanceWeightLuckIndex2 = 24;
    private static final int chanceWeightLuckIndex3 = 25;
    private static final int modifierIndex = 40;
    private static final int deleteIndex = 45;
    private static final int backToMenuIndex = 53;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final LootTable table;
    private final LootPool pool;
    private final LootEntry entry;
    private static final ItemStack togglePredicateModeButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_predicatemode", Material.COMPARATOR)).name("&eFilter Mode").stringTag(BUTTON_ACTION_KEY, "togglePredicateModeButton").lore("&7Determines to what extent filters", "&7should pass.", "&7Should all filters pass", "&7or should any filter pass?", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack modifierButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_entry_modifiers", Material.WRITABLE_BOOK)).name("&dDynamic Item Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack predicatesButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_entry_predicates", Material.WRITABLE_BOOK)).name("&bFilter").stringTag(BUTTON_ACTION_KEY, "predicatesButton").lore("&7The filter decides if this entry", "&7is capable of dropping based on", "&7conditions.", "&eClick to open the menu", "&8&m                <>                ", "%predicates%").get();
    private static final ItemStack toggleGuaranteedDroppedButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_guaranteeddroptoggle", Material.COMPARATOR)).name("&eDrop Guaranteed").stringTag(BUTTON_ACTION_KEY, "toggleGuaranteedDroppedButton").lore("&7Determines if this drop should", "&7always be dropped if it passed", "&7the filters.", "&7Chance/weight are irrelevant if", "&7enabled", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setWeightButton1 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton1").lore("&7Determines the weight for this", "&7drop. The higher the weight, the", "&7higher the drop chance. Drop chance", "&7per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 1", "&eShift-Click to change by 10").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setWeightButton2 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton2").lore("&7Determines the weight for this", "&7drop. The higher the weight, the", "&7higher the drop chance. Drop chance", "&7per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 100", "&eShift-Click to change by 1000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setWeightButton3 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setweight", Material.IRON_BLOCK)).name("&eWeight: ").stringTag(BUTTON_ACTION_KEY, "setWeightButton3").lore("&7Determines the weight for this", "&7drop. The higher the weight, the", "&7higher the drop chance. Drop chance", "&7per roll is equal to ", "&7dropWeight/totalWeight, ", "&7where totalWeight is the combined", "&7weight of all possible drops.", "&eClick to change by 10000", "&eShift-Click to change by 100000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton1 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton1").lore("&7Determines the extra weight for", "&7this drop per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7drop will be selected", "&eClick to change by 1", "&eShift-Click to change by 10").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton2 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton2").lore("&7Determines the extra weight for", "&7this drop per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7drop will be selected", "&eClick to change by 100", "&eShift-Click to change by 1000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusWeightButton3 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckweight", Material.LAPIS_LAZULI)).name("&eBonus Luck Weight: ").stringTag(BUTTON_ACTION_KEY, "setBonusWeightButton3").lore("&7Determines the extra weight for", "&7this drop per luck point. ", "&7The more of the luck stat the", "&7player has, this more likely this", "&7drop will be selected", "&eClick to change by 10000", "&eShift-Click to change by 100000").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setChanceButton1 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setchance", Material.GOLD_BLOCK)).name("&eDrop Chance: ").stringTag(BUTTON_ACTION_KEY, "setChanceButton1").lore("&7Determines the drop chance.", "&eClick to change by 10%", "&eShift-Click to change by 1%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setChanceButton2 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setchance", Material.GOLD_BLOCK)).name("&eDrop Chance: ").stringTag(BUTTON_ACTION_KEY, "setChanceButton2").lore("&7Determines the drop chance.", "&eClick to change by 0.1%", "&eShift-Click to change by 0.01%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setChanceButton3 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setchance", Material.GOLD_BLOCK)).name("&eDrop Chance: ").stringTag(BUTTON_ACTION_KEY, "setChanceButton3").lore("&7Determines the drop chance.", "&eClick to change by 0.001%", "&eShift-Click to change by 0.0001%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusChanceButton1 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckchance", Material.LAPIS_LAZULI)).name("&eBonus Luck Chance: ").stringTag(BUTTON_ACTION_KEY, "setBonusChanceButton1").lore("&7Determines the additional drop", "&7chance per luck point.", "&7The more of the luck stat the", "&7player has, the higher the drop", "&7chance", "&eClick to change by 10%", "&eShift-Click to change by 1%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusChanceButton2 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckchance", Material.LAPIS_LAZULI)).name("&eBonus Luck Chance: ").stringTag(BUTTON_ACTION_KEY, "setBonusChanceButton2").lore("&7Determines the additional drop", "&7chance per luck point.", "&7The more of the luck stat the", "&7player has, the higher the drop", "&7chance", "&eClick to change by 0.1%", "&eShift-Click to change by 0.01%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusChanceButton3 = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_setluckchance", Material.LAPIS_LAZULI)).name("&eBonus Luck Chance: ").stringTag(BUTTON_ACTION_KEY, "setBonusChanceButton3").lore("&7Determines the additional drop", "&7chance per luck point.", "&7The more of the luck stat the", "&7player has, the higher the drop", "&7chance", "&eClick to change by 0.001%", "&eShift-Click to change by 0.0001%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBaseQuantityButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_basequantity", Material.PAPER)).name("&eBase Quantity").stringTag(BUTTON_ACTION_KEY, "setBaseQuantityButton").lore("&7How many items should this", "&7entry drop? The amount dropped", "&7will be a random amount between", "&7your two given min and max values", "&eClick to change &6min&e amount by 1", "&eShift-Click to change &6max&e amount by 1").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setFortuneQuantityButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_loottable_luckquantity", Material.PAPER)).name("&eFortune Quantity").stringTag(BUTTON_ACTION_KEY, "setFortuneQuantityButton").lore("&7How many extra items should", "&7this entry drop per level of", "&7looting or fortune?", "&7The base min/max are increased by", "&7your given fortune min/max per level", "&eClick to change &6min&e amount by 1", "&eShift-Click to change &6max&e amount by 1").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).get();
    private static final ItemStack backToMenuButton = new ItemBuilder(LootEntryEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private boolean confirmDeletion = false;
    private int page = 0;

    public LootEntryEditor(PlayerMenuUtility playerMenuUtility, LootPool parent, LootEntry entry) {
        super(playerMenuUtility);
        this.entry = entry;
        this.pool = parent;
        this.table = LootTableRegistry.getLootTables().get(this.pool.getParentTable());
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf319" : TranslationManager.getTranslation("editormenu_lootentry"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        if (this.table == null) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cLoot Table has already been deleted");
            e.getWhoClicked().closeInventory();
            return;
        }
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new LootPoolEditor(this.playerMenuUtility, this.pool).open();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "predicatesButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new LootPredicateMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "togglePredicateModeButton": {
                    int currentMode = Arrays.asList(LootTable.PredicateSelection.values()).indexOf((Object)this.entry.getPredicateSelection());
                    currentMode = e.getClick().isLeftClick() ? (currentMode + 1 >= LootTable.PredicateSelection.values().length ? 0 : ++currentMode) : (currentMode - 1 < 0 ? LootTable.PredicateSelection.values().length - 1 : --currentMode);
                    this.entry.setPredicateSelection(LootTable.PredicateSelection.values()[currentMode]);
                    break;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this loot pool?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    this.pool.getEntries().remove(this.entry.getUuid());
                    new LootPoolEditor(this.playerMenuUtility, this.pool).open();
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "setWeightButton1": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1)));
                    break;
                }
                case "setWeightButton2": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
                    break;
                }
                case "setWeightButton3": {
                    this.entry.setWeight(this.entry.getWeight() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000 : 10000)));
                    break;
                }
                case "setBonusWeightButton1": {
                    this.entry.setWeightQuality(this.entry.getWeightQuality() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1)));
                    break;
                }
                case "setBonusWeightButton2": {
                    this.entry.setWeightQuality(this.entry.getWeightQuality() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
                    break;
                }
                case "setBonusWeightButton3": {
                    this.entry.setWeightQuality(this.entry.getWeightQuality() + (double)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 100000 : 10000)));
                    break;
                }
                case "setChanceButton1": {
                    this.entry.setChance(this.entry.getChance() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
                    break;
                }
                case "setChanceButton2": {
                    this.entry.setChance(this.entry.getChance() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.001 : 1.0E-4));
                    break;
                }
                case "setChanceButton3": {
                    this.entry.setChance(this.entry.getChance() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E-5 : 1.0E-6));
                    break;
                }
                case "setBonusChanceButton1": {
                    this.entry.setChanceQuality(this.entry.getChanceQuality() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
                    break;
                }
                case "setBonusChanceButton2": {
                    this.entry.setChanceQuality(this.entry.getChanceQuality() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.001 : 1.0E-4));
                    break;
                }
                case "setBonusChanceButton3": {
                    this.entry.setChanceQuality(this.entry.getChanceQuality() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0E-5 : 1.0E-6));
                    break;
                }
                case "toggleGuaranteedDroppedButton": {
                    this.entry.setGuaranteedPresent(!this.entry.isGuaranteedPresent());
                    break;
                }
                case "setBaseQuantityButton": {
                    if (e.isShiftClick()) {
                        this.entry.setBaseQuantityMax(Math.max(Math.max(0, this.entry.getBaseQuantityMin()), this.entry.getBaseQuantityMax() + (e.isLeftClick() ? 1 : -1)));
                        break;
                    }
                    this.entry.setBaseQuantityMin(Math.max(0, Math.min(this.entry.getBaseQuantityMax(), this.entry.getBaseQuantityMin() + (e.isLeftClick() ? 1 : -1))));
                    break;
                }
                case "setFortuneQuantityButton": {
                    if (e.isShiftClick()) {
                        this.entry.setQuantityMaxFortuneBase(Math.max(Math.max(0.0f, this.entry.getQuantityMinFortuneBase()), this.entry.getQuantityMaxFortuneBase() + (e.isLeftClick() ? 0.1f : -0.1f)));
                        break;
                    }
                    this.entry.setQuantityMinFortuneBase(Math.max(0.0f, Math.min(this.entry.getQuantityMaxFortuneBase(), this.entry.getQuantityMinFortuneBase() + (e.isLeftClick() ? 0.1f : -0.1f))));
                }
            }
        } else if (!ItemUtils.isEmpty(cursor) && e.getRawSlot() == 4) {
            this.entry.setDrop(cursor.clone());
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ItemBuilder dropIcon = new ItemBuilder(this.entry.getDrop());
        String[] stringArray = new String[2];
        stringArray[0] = "&8&m                                   ";
        Object[] objectArray = new Object[2];
        Object object = objectArray[0] = this.entry.getBaseQuantityMin() != this.entry.getBaseQuantityMax() ? this.entry.getBaseQuantityMin() + "-" + this.entry.getBaseQuantityMax() : Integer.valueOf(this.entry.getBaseQuantityMin());
        objectArray[1] = this.entry.getQuantityMinFortuneBase() > 0.0f ? (this.entry.getQuantityMinFortuneBase() != this.entry.getQuantityMaxFortuneBase() ? String.format("(+%.1f-%.1f/fortune)", Float.valueOf(this.entry.getQuantityMinFortuneBase()), Float.valueOf(this.entry.getQuantityMaxFortuneBase())) : String.format("(+%.1f/fortune", Float.valueOf(this.entry.getQuantityMinFortuneBase()))) : "";
        stringArray[1] = String.format("&9Quantity: %s %s", objectArray);
        dropIcon.appendLore(stringArray);
        if (!this.entry.getPredicates().isEmpty()) {
            dropIcon.appendLore("&6" + (this.entry.getPredicateSelection() == LootTable.PredicateSelection.ANY ? "Any" : "All") + "&e of the following conditions");
            dropIcon.appendLore("&emust pass:");
            this.entry.getPredicates().forEach(pr -> dropIcon.appendLore(StringUtils.separateStringIntoLines("&f> " + pr.getActiveDescription(), 40)));
        }
        if (this.entry.isGuaranteedPresent()) {
            dropIcon.appendLore("&aGuaranteed to drop if", "&aconditions succeed");
        } else if (this.pool.isWeighted()) {
            double combinedWeight = this.pool.getEntries().values().stream().mapToDouble(LootEntry::getWeight).sum();
            dropIcon.appendLore("&eWeight: " + this.entry.getWeight() + (this.entry.getWeightQuality() > 0.0 ? String.format(" (+%.1f/fortune)", this.entry.getWeightQuality()) : ""), "&6With a combined weight of " + combinedWeight, String.format("&6this has a %.1f%% chance of", this.entry.getWeight() / combinedWeight * 100.0), "&6dropping per roll (ignoring luck)");
        } else {
            dropIcon.appendLore(String.format("&eDrop chance: %.1f %s", this.entry.getChance() * 100.0, this.entry.getChanceQuality() > 0.0 ? String.format(" (+%.1f/luck)", this.entry.getChanceQuality() * 100.0) : ""));
        }
        ArrayList<String> predicateLore = new ArrayList<String>();
        this.pool.getPredicates().forEach(p -> predicateLore.addAll(StringUtils.separateStringIntoLines("&d> " + p.getActiveDescription(), 40)));
        ItemBuilder predicateIcon = new ItemBuilder(predicatesButton).placeholderLore("%predicates%", predicateLore);
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.entry.getModifiers().forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ItemBuilder modifierIcon = new ItemBuilder(modifierButton).placeholderLore("%modifiers%", modifierLore);
        ItemBuilder itemBuilder = new ItemBuilder(togglePredicateModeButton);
        this.inventory.setItem(2, itemBuilder.name("&eFilter Mode: " + (switch (this.pool.getPredicateSelection()) {
            default -> throw new IncompatibleClassChangeError();
            case LootTable.PredicateSelection.ALL -> "&aALL conditions must pass";
            case LootTable.PredicateSelection.ANY -> "&aANY condition must pass";
        })).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(53, backToMenuButton);
        this.inventory.setItem(1, predicateIcon.get());
        this.inventory.setItem(40, modifierIcon.get());
        this.inventory.setItem(4, dropIcon.get());
        this.inventory.setItem(6, new ItemBuilder(setBaseQuantityButton).name("&eDrop Count: " + this.entry.getBaseQuantityMin() + "-" + this.entry.getBaseQuantityMax()).get());
        this.inventory.setItem(7, new ItemBuilder(setFortuneQuantityButton).name(String.format("&eFortune Drop Count: %.1f-%.1f", Float.valueOf(this.entry.getQuantityMinFortuneBase()), Float.valueOf(this.entry.getQuantityMaxFortuneBase()))).get());
        this.inventory.setItem(13, new ItemBuilder(toggleGuaranteedDroppedButton).name((String)(this.entry.isGuaranteedPresent() ? "&eDrop guaranteed" : "&eDrop relies on " + (this.pool.isWeighted() ? "its weight" : "its drop chance"))).get());
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(21, this.pool.isWeighted() ? new ItemBuilder(setWeightButton1).name("&eWeight: " + this.entry.getWeight()).get() : new ItemBuilder(setChanceButton1).name(String.format("&eDrop Chance: %.4f%%", this.entry.getChance() * 100.0)).get());
        }
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(20, this.pool.isWeighted() ? new ItemBuilder(setWeightButton2).name("&eWeight: " + this.entry.getWeight()).get() : new ItemBuilder(setChanceButton2).name(String.format("&eDrop Chance: %.4f%%", this.entry.getChance() * 100.0)).get());
        }
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(19, this.pool.isWeighted() ? new ItemBuilder(setWeightButton3).name("&eWeight: " + this.entry.getWeight()).get() : new ItemBuilder(setChanceButton3).name(String.format("&eDrop Chance: %.4f%%", this.entry.getChance() * 100.0)).get());
        }
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(23, this.pool.isWeighted() ? new ItemBuilder(setBonusWeightButton1).name("&eBonus Weight: +" + this.entry.getWeightQuality() + "/luck").get() : new ItemBuilder(setBonusChanceButton1).name(String.format("&eBonus Drop Chance: +%.4f%%/luck", this.entry.getChanceQuality() * 100.0)).get());
        }
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(24, this.pool.isWeighted() ? new ItemBuilder(setBonusWeightButton2).name("&eBonus Weight: +" + this.entry.getWeightQuality() + "/luck").get() : new ItemBuilder(setBonusChanceButton2).name(String.format("&eBonus Drop Chance: +%.4f%%/luck", this.entry.getChanceQuality() * 100.0)).get());
        }
        if (!this.entry.isGuaranteedPresent()) {
            this.inventory.setItem(25, this.pool.isWeighted() ? new ItemBuilder(setBonusWeightButton3).name("&eBonus Weight: +" + this.entry.getWeightQuality() + "/luck").get() : new ItemBuilder(setBonusChanceButton3).name(String.format("&eBonus Drop Chance: +%.4f%%/luck", this.entry.getChanceQuality() * 100.0)).get());
        }
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.entry.setModifiers(resultModifiers);
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.entry.getModifiers();
    }

    @Override
    public void setPredicates(Collection<LootPredicate> predicates) {
    }

    @Override
    public Collection<LootPredicate> getPredicates() {
        return this.entry.getPredicates();
    }
}

