/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;
import org.bukkit.plugin.Plugin;

public class LootFreeSelectionMenu
extends Menu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final boolean selectableLootModifiers = ValhallaMMO.getPluginConfig().getBoolean("selectable_loot_modifiers");
    private static final int nextGuaranteedDropPageIndex = 6;
    private static final int previousGuaranteedDropPageIndex = 2;
    private static final int nextDropPageIndex = 26;
    private static final int previousDropPageIndex = 18;
    private static final int confirmIndex = 44;
    private static final int[] entryGuaranteedLayoutPriority = new int[]{4, 13, 3, 5, 12, 14};
    private static final int[] entrySelectLayoutPriority = new int[]{31, 30, 32, 29, 33, 28, 34};
    private final LootTable table;
    private final boolean allowRepeatedSelection;
    private final Action<Map<LootEntry, Integer>> onFinish;
    private final List<LootEntry> guaranteedDrops = new ArrayList<LootEntry>();
    private final List<ItemBuilder> guaranteedDropsItems = new ArrayList<ItemBuilder>();
    private final Map<UUID, Integer> selection = new HashMap<UUID, Integer>();
    private final Map<UUID, ItemBuilder> generatedItems = new HashMap<UUID, ItemBuilder>();
    private final Map<UUID, LootEntry> entryMapping = new HashMap<UUID, LootEntry>();
    private int allowedPicks;
    private int guaranteedDropsPage = 0;
    private int dropsPage = 0;
    private static final ItemStack confirmSelectionButton = new ItemBuilder(LootFreeSelectionMenu.getButtonData("lootselection_confirm", Material.STRUCTURE_VOID)).name(TranslationManager.getTranslation("menu_loottablefreeselection_confirmselection")).stringTag(BUTTON_ACTION_KEY, "confirmSelectionButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack nextPageButtonGuaranteed = new ItemBuilder(LootFreeSelectionMenu.getButtonData("editor_nextpage", Material.ARROW)).name(TranslationManager.getTranslation("translation_next_page")).stringTag(BUTTON_ACTION_KEY, "nextPageButtonGuaranteed").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButtonGuaranteed = new ItemBuilder(LootFreeSelectionMenu.getButtonData("editor_prevpage", Material.ARROW)).name(TranslationManager.getTranslation("translation_previous_page")).stringTag(BUTTON_ACTION_KEY, "previousPageButtonGuaranteed").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack nextPageButtonSelection = new ItemBuilder(LootFreeSelectionMenu.getButtonData("editor_nextpage", Material.ARROW)).name(TranslationManager.getTranslation("translation_next_page")).stringTag(BUTTON_ACTION_KEY, "nextPageButtonSelection").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButtonSelection = new ItemBuilder(LootFreeSelectionMenu.getButtonData("editor_prevpage", Material.ARROW)).name(TranslationManager.getTranslation("translation_previous_page")).stringTag(BUTTON_ACTION_KEY, "previousPageButtonSelection").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack unselectedDropBase = new ItemBuilder(LootFreeSelectionMenu.getButtonData("lootselection_unpicked", Material.RED_DYE)).name("&r").get();
    private static final ItemStack selectedDropBase = new ItemBuilder(LootFreeSelectionMenu.getButtonData("lootselection_picked", Material.LIME_DYE)).name("&r").get();

    public LootFreeSelectionMenu(PlayerMenuUtility playerMenuUtility, LootTable table, LootContext context, boolean allowRepeatedSelection, Action<Map<LootEntry, Integer>> onFinish) {
        super(playerMenuUtility);
        this.table = table;
        this.allowRepeatedSelection = allowRepeatedSelection;
        this.onFinish = onFinish;
        for (LootPool pool : table.getPools().values()) {
            if (this.allowedPicks <= 0) {
                this.allowedPicks = pool.getRolls(context);
            }
            for (LootEntry entry : pool.getEntries().values()) {
                this.entryMapping.put(entry.getUuid(), entry);
                ItemBuilder drop = new ItemBuilder(entry.getDrop());
                if (selectableLootModifiers) {
                    DynamicItemModifier.modify(ModifierContext.builder(drop).crafter(playerMenuUtility.getOwner()).validate().get(), entry.getModifiers());
                }
                if (CustomFlag.hasFlag(drop.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                if (entry.isGuaranteedPresent()) {
                    this.guaranteedDropsItems.add(drop);
                    this.guaranteedDrops.add(entry);
                    continue;
                }
                this.generatedItems.put(entry.getUuid(), drop.stringTag(BUTTON_DATA, entry.getUuid().toString()));
            }
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat((ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf100\uf80c\uf809\uf808" : "") + TranslationManager.getTranslation("menu_loottablefreeselection"));
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (ItemUtils.isEmpty(clicked)) {
            return;
        }
        ItemMeta clickedMeta = clicked.getItemMeta();
        if (clickedMeta == null) {
            return;
        }
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clickedMeta, null);
        if (action != null) {
            switch (action) {
                case "confirmSelectionButton": {
                    this.playerMenuUtility.getOwner().closeInventory();
                    HashMap<LootEntry, Integer> rewards = new HashMap<LootEntry, Integer>();
                    this.guaranteedDrops.forEach(d -> rewards.put((LootEntry)d, 1));
                    for (LootPool pool : this.table.getPools().values()) {
                        for (UUID uuid : this.selection.keySet()) {
                            LootEntry entry = pool.getEntries().get(uuid);
                            int quantity = this.selection.getOrDefault(uuid, 0);
                            if (entry == null || quantity <= 0) continue;
                            rewards.put(entry, quantity);
                        }
                    }
                    this.onFinish.act(rewards);
                    return;
                }
                case "previousPageButtonGuaranteed": {
                    this.guaranteedDropsPage = Math.max(0, this.guaranteedDropsPage - 1);
                    break;
                }
                case "nextPageButtonGuaranteed": {
                    this.guaranteedDropsPage = Math.min((int)Math.ceil((double)this.guaranteedDrops.size() / (double)entryGuaranteedLayoutPriority.length), this.guaranteedDropsPage + 1);
                    break;
                }
                case "previousPageButtonSelection": {
                    this.dropsPage = Math.max(0, this.dropsPage - 1);
                    break;
                }
                case "nextPageButtonSelection": {
                    this.dropsPage = Math.min((int)Math.ceil((double)this.generatedItems.size() / (double)entrySelectLayoutPriority.length), this.dropsPage + 1);
                }
            }
        } else {
            String data = ItemUtils.getPDCString(BUTTON_DATA, clickedMeta, null);
            if (data == null) {
                return;
            }
            UUID uuid = UUID.fromString(data);
            if (e.isLeftClick() && this.allowedPicks > 0) {
                if (this.selection.containsKey(uuid) && this.allowRepeatedSelection) {
                    int quantity = this.selection.get(uuid);
                    this.selection.put(uuid, quantity + 1);
                    --this.allowedPicks;
                } else if (!this.selection.containsKey(uuid)) {
                    this.selection.put(uuid, 1);
                    --this.allowedPicks;
                }
            } else if (e.isRightClick() && this.selection.containsKey(uuid)) {
                int quantity = this.selection.get(uuid) - 1;
                if (quantity <= 0) {
                    this.selection.remove(uuid);
                } else {
                    this.selection.put(uuid, quantity);
                }
                ++this.allowedPicks;
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        Map<Integer, List<ItemBuilder>> guaranteedDropsPages = Utils.paginate(entryGuaranteedLayoutPriority.length, this.guaranteedDropsItems);
        this.guaranteedDropsPage = Math.max(1, Math.min(this.guaranteedDropsPage, guaranteedDropsPages.size()));
        if (!guaranteedDropsPages.isEmpty()) {
            int index = 0;
            for (ItemBuilder i : guaranteedDropsPages.get(this.guaranteedDropsPage - 1)) {
                i = new ItemBuilder(i.getItem().clone()).setMeta(i.getMeta().clone());
                this.inventory.setItem(entryGuaranteedLayoutPriority[index], i.prependLore(TranslationManager.getTranslation("menu_loottablefreeselection_guaranteedincluded")).translate().get());
                ++index;
            }
        }
        Map<Integer, List<ItemBuilder>> dropsPages = Utils.paginate(entrySelectLayoutPriority.length, new ArrayList<ItemBuilder>(this.generatedItems.values()));
        this.dropsPage = Math.max(1, Math.min(this.dropsPage, dropsPages.size()));
        if (!dropsPages.isEmpty()) {
            int index = 0;
            for (ItemBuilder i : dropsPages.get(this.dropsPage - 1)) {
                String uuidString = ItemUtils.getPDCString(BUTTON_DATA, (i = new ItemBuilder(i.getItem().clone()).setMeta(i.getMeta().clone())).getMeta(), null);
                if (uuidString != null) {
                    UUID uuid = UUID.fromString(uuidString);
                    LootEntry entry = this.entryMapping.get(uuid);
                    if (entry == null) continue;
                    DynamicItemModifier.modify(ModifierContext.builder(i).crafter(this.playerMenuUtility.getOwner()).validate().get(), entry.getModifiers());
                    int existingAmount = Math.max(1, this.selection.getOrDefault(uuid, 1));
                    String quantity = (String)(entry.getBaseQuantityMin() != entry.getBaseQuantityMax() ? entry.getBaseQuantityMin() * existingAmount + "-" + entry.getBaseQuantityMax() * existingAmount : String.valueOf(entry.getBaseQuantityMin() * existingAmount)) + "x ";
                    this.inventory.setItem(entrySelectLayoutPriority[index], i.name(TranslationManager.getTranslation("menu_loottablefreeselection_nameformat").replace("%quantity%", (CharSequence)(this.selection.containsKey(uuid) ? quantity : "")).replace("%item%", ItemUtils.getItemName(i))).prependLore(ItemUtils.setListPlaceholder(TranslationManager.getListTranslation("loot_selection_prefix"), "%rolls%", (this.allowedPicks > 0 ? "&a" : "&c") + this.allowedPicks)).appendLore(ItemUtils.setListPlaceholder(TranslationManager.getListTranslation("loot_selection_suffix"), "%rolls%", (this.allowedPicks > 0 ? "&a" : "&c") + this.allowedPicks)).translate().get());
                    this.inventory.setItem(entrySelectLayoutPriority[index] + 9, new ItemBuilder(this.selection.containsKey(uuid) ? selectedDropBase : unselectedDropBase).name(ItemUtils.getItemName(i)).prependLore(ItemUtils.setListPlaceholder(TranslationManager.getListTranslation("loot_selection_prefix"), "%rolls%", (this.allowedPicks > 0 ? "&a" : "&c") + this.allowedPicks)).appendLore(ItemUtils.setListPlaceholder(TranslationManager.getListTranslation("loot_selection_suffix"), "%rolls%", (this.allowedPicks > 0 ? "&a" : "&c") + this.allowedPicks)).stringTag(BUTTON_DATA, uuidString).amount(Math.max(1, this.selection.getOrDefault(uuid, 1))).translate().get());
                }
                ++index;
            }
        }
        if (this.allowedPicks == 0 || !this.allowRepeatedSelection && this.selection.size() >= this.generatedItems.size()) {
            this.inventory.setItem(44, confirmSelectionButton);
        }
        if (this.guaranteedDropsPage > 1) {
            this.inventory.setItem(2, previousPageButtonGuaranteed);
        }
        if (this.dropsPage > 1) {
            this.inventory.setItem(18, previousPageButtonSelection);
        }
        if (this.guaranteedDropsPage <= guaranteedDropsPages.size()) {
            this.inventory.setItem(6, nextPageButtonGuaranteed);
        }
        if (this.dropsPage <= dropsPages.size()) {
            this.inventory.setItem(26, nextPageButtonSelection);
        }
    }
}

