/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetLootPredicatesMenu;
import me.athlaeos.valhallammo.gui.implementations.LootEntryEditor;
import me.athlaeos.valhallammo.gui.implementations.LootPredicateMenu;
import me.athlaeos.valhallammo.gui.implementations.LootTableEditor;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootEntry;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class LootPoolEditor
extends Menu
implements SetLootPredicatesMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final int predicatesIndex = 1;
    private static final int predicateTypeIndex = 2;
    private static final int dropChanceIndex = 3;
    private static final int dropLuckChanceIndex = 4;
    private static final int toggleWeightedIndex = 5;
    private static final int weightedRollsBaseIndex = 6;
    private static final int weightedRollsLuckBonusIndex = 7;
    private static final int previousPageIndex = 27;
    private static final int nextPageIndex = 35;
    private static final int deleteIndex = 45;
    private static final int backToMenuIndex = 53;
    private static final int[] entryIndexes = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final LootTable table;
    private final LootPool pool;
    private static final ItemStack togglePredicateModeButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_predicatemode", Material.COMPARATOR)).name("&eFilter Mode").stringTag(BUTTON_ACTION_KEY, "togglePredicateModeButton").lore("&7Determines to what extent filters", "&7should pass.", "&7Should all filters pass", "&7or should any filter pass?", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack predicatesButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_pool_predicates", Material.WRITABLE_BOOK)).name("&bFilter").stringTag(BUTTON_ACTION_KEY, "predicatesButton").lore("&7The filter decides if this pool", "&7is capable of dropping anything", "&7based on conditions.", "&eClick to open the menu", "&8&m                <>                ", "%predicates%").get();
    private static final ItemStack toggleWeightedButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_toggleweighted", Material.IRON_BLOCK)).name("&eWeighted").stringTag(BUTTON_ACTION_KEY, "toggleWeightedButton").lore("&7Determines if the loot pool", "&7should have weighted entries", "&7or chanced entries", "&7Weighted pools can only drop", "&7a limited amount of things", "&7while chanced pools can drop", "&7any amount as long as the entry's", "&7chance 'procs'", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBaseRollsButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_weightedbaserolls", Material.PAPER)).name("&eWeighted Rolls").stringTag(BUTTON_ACTION_KEY, "setBaseRollsButton").lore("&7How many items should this", "&7loot pool attempt to drop?", "&eClick to change by 1", "&eShift-Click to change by 5").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setBonusLuckRollsButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_weightedbonusrolls", Material.PAPER)).name("&eBonus Luck Rolls").stringTag(BUTTON_ACTION_KEY, "setBonusLuckRollsButton").lore("&7How many extra rolls should ", "&7occur based on player luck?", "&eClick to change by 0.1", "&eShift-Click to change by 1").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setDropChanceButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_setchance", Material.LAPIS_LAZULI)).name("&eDrop Chance").stringTag(BUTTON_ACTION_KEY, "setDropChanceButton").lore("&7What should the chance be for this", "&7pool to be able to drop things?", "&eClick to change by 1%", "&eShift-Click to change by 10%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack setDropLuckChanceButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_setluckchance", Material.LAPIS_LAZULI)).name("&eDrop Luck Chance").stringTag(BUTTON_ACTION_KEY, "setDropLuckChanceButton").lore("&7How much should each point of luck", "&7affect the drop chance?", "&eClick to change by 0.1%", "&eShift-Click to change by 2.5%").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack nextPageButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(BUTTON_ACTION_KEY, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(BUTTON_ACTION_KEY, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private static final ItemStack createNewButton = new ItemBuilder(LootPoolEditor.getButtonData("editor_loottable_newentry", Material.LIME_DYE)).name("&b&lNew Entry").stringTag(BUTTON_ACTION_KEY, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private boolean confirmDeletion = false;
    private int page = 0;

    public LootPoolEditor(PlayerMenuUtility playerMenuUtility, LootPool pool) {
        super(playerMenuUtility);
        this.pool = pool;
        this.table = LootTableRegistry.getLootTables().get(pool.getParentTable());
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf313\uf80c\uf80a\uf808\uf802&8%pool%" : TranslationManager.getTranslation("editormenu_lootpool")).replace("%pool%", this.table.getKey());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        LootEntry entry;
        String data;
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        if (this.table == null) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cLoot Table has already been deleted");
            e.getWhoClicked().closeInventory();
            return;
        }
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new LootTableEditor(this.playerMenuUtility, this.table).open();
                    return;
                }
                case "togglePredicateModeButton": {
                    int currentMode = Arrays.asList(LootTable.PredicateSelection.values()).indexOf((Object)this.pool.getPredicateSelection());
                    currentMode = e.getClick().isLeftClick() ? (currentMode + 1 >= LootTable.PredicateSelection.values().length ? 0 : ++currentMode) : (currentMode - 1 < 0 ? LootTable.PredicateSelection.values().length - 1 : --currentMode);
                    this.pool.setPredicateSelection(LootTable.PredicateSelection.values()[currentMode]);
                    break;
                }
                case "predicatesButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new LootPredicateMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this loot pool?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    this.table.getPools().remove(this.pool.getKey());
                    new LootTableEditor(this.playerMenuUtility, this.table).open();
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "toggleWeightedButton": {
                    this.pool.setWeighted(!this.pool.isWeighted());
                    break;
                }
                case "setBaseRollsButton": {
                    this.pool.setWeightedRolls(this.pool.getWeightedRolls() + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1));
                    break;
                }
                case "setBonusLuckRollsButton": {
                    this.pool.setBonusLuckRolls(this.pool.getBonusLuckRolls() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0 : 0.1));
                    break;
                }
                case "setDropChanceButton": {
                    this.pool.setDropChance(this.pool.getDropChance() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
                    break;
                }
                case "setDropLuckChanceButton": {
                    this.pool.setDropLuckChance(this.pool.getDropLuckChance() + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.25 : 0.1));
                    break;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    LootEntry entry2 = this.pool.addEntry(ItemUtils.isEmpty(e.getCursor()) ? new ItemBuilder(Material.GOLD_INGOT).name("&eReplace me!").lore("&fI'm just a placeholder drop!").get() : e.getCursor().clone());
                    new LootEntryEditor(this.playerMenuUtility, this.pool, entry2).open();
                }
            }
        }
        if (!StringUtils.isEmpty(data = ItemUtils.getPDCString(BUTTON_DATA, clicked, null)) && (entry = this.pool.getEntries().get(UUID.fromString(data))) != null) {
            new LootEntryEditor(this.playerMenuUtility, this.pool, entry).open();
            return;
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>(this.pool.getEntries().values());
        entries.sort(Comparator.comparing(LootEntry::getWeight));
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        entries.forEach(p -> {
            ItemBuilder builder = new ItemBuilder(p.getDrop()).stringTag(BUTTON_DATA, p.getUuid().toString());
            builder.name("&e" + ItemUtils.getItemName(builder));
            String[] stringArray = new String[1];
            Object[] objectArray = new Object[2];
            Object object = objectArray[0] = p.getBaseQuantityMin() != p.getBaseQuantityMax() ? p.getBaseQuantityMin() + "-" + p.getBaseQuantityMax() : Integer.valueOf(p.getBaseQuantityMin());
            objectArray[1] = p.getQuantityMinFortuneBase() > 0.0f ? (p.getQuantityMinFortuneBase() != p.getQuantityMaxFortuneBase() ? String.format("(+%.1f-%.1f/fortune)", Float.valueOf(p.getQuantityMinFortuneBase()), Float.valueOf(p.getQuantityMaxFortuneBase())) : String.format("(+%.1f/fortune", Float.valueOf(p.getQuantityMinFortuneBase()))) : "";
            stringArray[0] = String.format("&9Quantity: %s %s", objectArray);
            builder.lore(stringArray);
            if (!p.getPredicates().isEmpty()) {
                builder.appendLore("&6" + (p.getPredicateSelection() == LootTable.PredicateSelection.ANY ? "Any" : "All") + "&e of the following conditions");
                builder.appendLore("&emust pass:");
                p.getPredicates().forEach(pr -> builder.appendLore(StringUtils.separateStringIntoLines("&f> " + pr.getActiveDescription(), 40)));
            }
            if (p.isGuaranteedPresent()) {
                builder.appendLore("&aEntry is always present once if", "&aconditions succeed");
            } else if (this.pool.isWeighted()) {
                double combinedWeight = this.pool.getEntries().values().stream().mapToDouble(LootEntry::getWeight).sum();
                builder.appendLore("&eEntry weight: " + p.getWeight() + (p.getWeightQuality() > 0.0 ? String.format(" (+%.1f/luck)", p.getWeightQuality()) : ""), "&6With a combined weight of " + combinedWeight, String.format("&6this entry has a %.1f%% chance", p.getWeight() / combinedWeight * 100.0), "&6of dropping per roll (ignoring luck)");
            } else {
                builder.appendLore(String.format("&eEntry chance: %.1f %s", p.getChance() * 100.0, p.getChanceQuality() > 0.0 ? String.format(" (+%.1f/luck)", p.getChanceQuality() * 100.0) : ""));
            }
            buttons.add(builder.get());
        });
        buttons.add(createNewButton);
        Map pages = Utils.paginate(entryIndexes.length, buttons);
        this.page = Math.max(1, Math.min(this.page, pages.size()));
        if (!pages.isEmpty()) {
            int index = 0;
            for (ItemStack i : pages.get(this.page - 1)) {
                this.inventory.setItem(entryIndexes[index], i);
                ++index;
            }
        }
        ArrayList<String> predicateLore = new ArrayList<String>();
        this.pool.getPredicates().forEach(p -> predicateLore.addAll(StringUtils.separateStringIntoLines("&d> " + p.getActiveDescription(), 40)));
        ItemBuilder predicateIcon = new ItemBuilder(predicatesButton).placeholderLore("%predicates%", predicateLore);
        ItemBuilder itemBuilder = new ItemBuilder(togglePredicateModeButton);
        this.inventory.setItem(2, itemBuilder.name("&eFilter Mode: " + (switch (this.pool.getPredicateSelection()) {
            default -> throw new IncompatibleClassChangeError();
            case LootTable.PredicateSelection.ALL -> "&aALL conditions must pass";
            case LootTable.PredicateSelection.ANY -> "&aANY condition must pass";
        })).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(53, backToMenuButton);
        this.inventory.setItem(5, new ItemBuilder(toggleWeightedButton).name("&eIs Weighted: " + (this.pool.isWeighted() ? "Yes" : "No")).get());
        this.inventory.setItem(1, predicateIcon.get());
        if (this.pool.isWeighted()) {
            this.inventory.setItem(6, new ItemBuilder(setBaseRollsButton).name("&eBase Rolls: " + this.pool.getWeightedRolls()).get());
            this.inventory.setItem(7, new ItemBuilder(setBonusLuckRollsButton).name(String.format("&eBonus Luck Rolls: %.2f", this.pool.getBonusLuckRolls())).get());
        }
        this.inventory.setItem(3, new ItemBuilder(setDropChanceButton).name(String.format("&eDrop Chance: %.0f%%", this.pool.getDropChance() * 100.0)).get());
        this.inventory.setItem(4, new ItemBuilder(setDropLuckChanceButton).name(String.format("&eDrop Luck Chance: %.2f%%", this.pool.getDropLuckChance() * 100.0)).get());
        if (this.page < pages.size()) {
            this.inventory.setItem(35, nextPageButton);
        }
        if (this.page > 1) {
            this.inventory.setItem(27, previousPageButton);
        }
    }

    @Override
    public void setPredicates(Collection<LootPredicate> predicates) {
    }

    @Override
    public Collection<LootPredicate> getPredicates() {
        return this.pool.getPredicates();
    }
}

