/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetLootPredicatesMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.loot.predicates.PredicateRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class LootPredicateMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final NamespacedKey KEY_PREDICATE_ID = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_predicate_id");
    private static final NamespacedKey KEY_PREDICATE_BUTTON = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_predicate_button");
    private static final List<Integer> predicateButtonIndexes = Arrays.asList(2, 3, 4, 5, 6, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42);
    private static final ItemStack confirmButton = new ItemBuilder(Material.STRUCTURE_VOID).stringTag(KEY_ACTION, "confirmButton").name("&b&lSave").get();
    private static final ItemStack createNewButton = new ItemBuilder(LootPredicateMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lAdd Condition").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack cancelButton = new ItemBuilder(Material.BARRIER).stringTag(KEY_ACTION, "cancelButton").name("&cDelete").get();
    private static final ItemStack nextPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "nextPageButton").name("&7&lNext page").get();
    private static final ItemStack previousPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "previousPageButton").name("&7&lPrevious page").get();
    private final Menu menu;
    private View view = View.VIEW_PREDICATES;
    private int currentPage = 0;
    private final Collection<LootPredicate> currentPredicates;
    private LootPredicate currentPredicate = null;

    public LootPredicateMenu(PlayerMenuUtility playerMenuUtility, Menu menu) {
        super(playerMenuUtility);
        this.menu = menu;
        if (menu instanceof SetLootPredicatesMenu) {
            SetLootPredicatesMenu m = (SetLootPredicatesMenu)((Object)menu);
            this.currentPredicates = m.getPredicates();
        } else {
            this.currentPredicates = new ArrayList<LootPredicate>();
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf314\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_predicateselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedPredicate;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "confirmButton": {
                    Menu menu;
                    if (this.view == View.NEW_PREDICATE) {
                        if (this.currentPredicate == null) break;
                        this.currentPredicates.removeIf(m -> m.getKey().equalsIgnoreCase(this.currentPredicate.getKey()));
                        this.currentPredicates.add(this.currentPredicate);
                        this.currentPredicate = null;
                        this.view = View.VIEW_PREDICATES;
                        break;
                    }
                    if (this.view == View.PICK_PREDICATES) {
                        this.view = View.VIEW_PREDICATES;
                        break;
                    }
                    if (this.view != View.VIEW_PREDICATES || !((menu = this.menu) instanceof SetLootPredicatesMenu)) break;
                    SetLootPredicatesMenu m2 = (SetLootPredicatesMenu)((Object)menu);
                    m2.setPredicates(this.currentPredicates);
                    this.menu.open();
                    break;
                }
                case "createNewButton": {
                    this.view = View.PICK_PREDICATES;
                    break;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                    break;
                }
                case "cancelButton": {
                    if (this.currentPredicate == null) break;
                    this.view = this.currentPredicates.removeIf(m -> m.getKey().equalsIgnoreCase(this.currentPredicate.getKey())) ? View.VIEW_PREDICATES : View.PICK_PREDICATES;
                }
            }
        }
        if (!StringUtils.isEmpty(clickedPredicate = ItemUtils.getPDCString(KEY_PREDICATE_ID, clickedItem, null))) {
            if (this.view == View.PICK_PREDICATES) {
                this.currentPredicate = PredicateRegistry.createPredicate(clickedPredicate);
                this.view = View.NEW_PREDICATE;
            } else if (this.view == View.VIEW_PREDICATES) {
                for (LootPredicate predicate : this.currentPredicates) {
                    if (!predicate.getKey().equals(clickedPredicate)) continue;
                    this.currentPredicate = predicate;
                    this.view = View.NEW_PREDICATE;
                    break;
                }
            }
        }
        if (ItemUtils.getPDCInt(KEY_PREDICATE_BUTTON, clickedItem, 0) > 0 && this.currentPredicate != null) {
            int buttonPressed = predicateButtonIndexes.indexOf(e.getRawSlot());
            this.currentPredicate.onButtonPress(e, buttonPressed);
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        switch (this.view.ordinal()) {
            case 1: {
                this.setViewPredicatesView();
                break;
            }
            case 0: {
                this.setPickPredicatesView();
                break;
            }
            case 2: {
                this.setNewPredicateView();
            }
        }
    }

    private void setNewPredicateView() {
        if (this.currentPredicate != null && this.currentPredicate.getButtons() != null) {
            for (Integer b : this.currentPredicate.getButtons().keySet()) {
                if (b >= predicateButtonIndexes.size()) {
                    throw new IllegalArgumentException("Loot Predicate " + this.currentPredicate.getKey() + " has button in invalid position " + b + ", must be between 0 and 25(non-inclusive)!");
                }
                ItemStack base = this.currentPredicate.getButtons().get(b);
                if (ItemUtils.isEmpty(base)) {
                    throw new IllegalStateException("Loot Predicate " + this.currentPredicate.getKey() + " has empty button in slot " + b);
                }
                ItemStack button = new ItemBuilder(base).intTag(KEY_PREDICATE_BUTTON, 1).get();
                this.inventory.setItem(predicateButtonIndexes.get(b).intValue(), button);
            }
        }
        this.inventory.setItem(53, confirmButton);
        this.inventory.setItem(45, cancelButton);
    }

    private void setPickPredicatesView() {
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        Map<String, LootPredicate> predicates = PredicateRegistry.getPredicates();
        Collection currentStringPredicates = this.currentPredicates.stream().map(LootPredicate::getKey).collect(Collectors.toSet());
        ArrayList<LootPredicate> sortedPredicates = new ArrayList<LootPredicate>(predicates.values());
        sortedPredicates.sort(Comparator.comparing(LootPredicate::getKey));
        ArrayList<ItemStack> totalPredicateButtons = new ArrayList<ItemStack>();
        for (LootPredicate predicate : sortedPredicates) {
            if (currentStringPredicates.contains(predicate.getKey())) continue;
            ItemStack icon = new ItemBuilder(predicate.getIcon()).lore(StringUtils.separateStringIntoLines(predicate.getDescription(), 40)).name(predicate.getDisplayName()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().stringTag(KEY_PREDICATE_ID, predicate.getKey()).get();
            totalPredicateButtons.add(icon);
        }
        Map pages = Utils.paginate(45, totalPredicateButtons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (ItemStack i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(36, previousPageButton);
        this.inventory.setItem(44, nextPageButton);
        this.inventory.setItem(40, confirmButton);
    }

    private void setViewPredicatesView() {
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        List<LootPredicate> predicates = this.currentPredicates.stream().limit(45L).toList();
        for (LootPredicate predicate : predicates) {
            ItemStack icon = new ItemBuilder(predicate.getIcon()).lore(StringUtils.separateStringIntoLines(predicate.getActiveDescription(), 40)).name(predicate.getDisplayName()).stringTag(KEY_PREDICATE_ID, predicate.getKey()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
            this.inventory.addItem(new ItemStack[]{icon});
        }
        if (this.currentPredicates.size() <= 44) {
            this.inventory.addItem(new ItemStack[]{createNewButton});
        }
        this.inventory.setItem(49, confirmButton);
    }

    private static enum View {
        PICK_PREDICATES,
        VIEW_PREDICATES,
        NEW_PREDICATE;

    }
}

