/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.implementations.ReplacementTableEditor;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ReplacementTableSelectionMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final ItemStack backToMenuButton = new ItemBuilder(ReplacementTableSelectionMenu.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(KEY_ACTION, "backToMenuButton").name("&7Cancel Selection").get();
    private static final ItemStack createNewButton = new ItemBuilder(ReplacementTableSelectionMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lNew").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().wipeAttributes().get();
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private static final ItemStack nextPageButton = new ItemBuilder(ReplacementTableSelectionMenu.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(KEY_ACTION, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(ReplacementTableSelectionMenu.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(KEY_ACTION, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().wipeAttributes().get();
    private final Menu openedFrom;
    private final Action<ReplacementTable> tableAction;
    private int page = 0;

    public ReplacementTableSelectionMenu(PlayerMenuUtility playerMenuUtility, Menu menu, Action<ReplacementTable> tableAction) {
        super(playerMenuUtility);
        this.openedFrom = menu;
        this.tableAction = tableAction;
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf312\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_ingredientselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String storedValue;
        ItemStack clickedItem = e.getCurrentItem();
        e.setCancelled(true);
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    this.openedFrom.open();
                    return;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the replacement table's key be? (type in chat, or 'cancel' to cancel)", s -> !LootTableRegistry.getReplacementTables().containsKey(s), "&cReplacement table with this key already exists! Try again")}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer().replaceAll(" ", "_").toLowerCase(Locale.US);
                                if (answer.contains("cancel")) {
                                    ReplacementTableSelectionMenu.this.playerMenuUtility.getPreviousMenu().open();
                                } else if (LootTableRegistry.getLootTables().containsKey(answer)) {
                                    Utils.sendMessage((CommandSender)this.getWho(), "&cReplacement table key already exists!");
                                } else {
                                    ReplacementTable newTable = new ReplacementTable(answer);
                                    LootTableRegistry.registerReplacementTable(newTable, true);
                                    if (ReplacementTableSelectionMenu.this.tableAction != null) {
                                        ReplacementTableSelectionMenu.this.tableAction.act(newTable);
                                    }
                                }
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                }
            }
        }
        if (StringUtils.isEmpty(storedValue = ItemUtils.getPDCString(BUTTON_DATA, clickedItem, null))) {
            return;
        }
        ReplacementTable table = LootTableRegistry.getReplacementTables().get(storedValue);
        if (table == null) {
            return;
        }
        if (this.tableAction == null || e.isShiftClick()) {
            new ReplacementTableEditor(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), table).open();
        } else {
            this.tableAction.act(table);
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 45; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        for (ReplacementTable table : LootTableRegistry.getReplacementTables().values()) {
            ItemBuilder icon = new ItemBuilder(table.getIcon()).name("&e" + table.getKey()).stringTag(BUTTON_DATA, table.getKey());
            if (table.getReplacementPools().isEmpty()) {
                icon.appendLore("&cNo replacement pools set, replaces nothing");
            } else {
                icon.appendLore("&aSelecting replacement from " + table.getReplacementPools().size() + " pools");
            }
            if (this.tableAction != null) {
                icon.appendLore("&6Click to select, ", "&6Shift-Click to edit");
            } else {
                icon.appendLore("&6Click to edit");
            }
            buttons.add(icon.get());
        }
        buttons.add(createNewButton);
        Map pages = Utils.paginate(45, buttons);
        this.page = Math.max(1, Math.min(this.page, pages.size()));
        if (!pages.isEmpty()) {
            pages.get(this.page - 1).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, nextPageButton);
    }
}

