/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.loottablecategories;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.LootTableOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.ReplacementTableSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.TableCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GlobalReplacementTable
extends TableCategory {
    public GlobalReplacementTable(int position) {
        super("replacement_table_global", new ItemBuilder(Material.GRASS_BLOCK).name("&eGlobal Replacement Table").lore("&fReplacement tables assigned to any loot", "", "&eReplacement tables scan loot items", "&eand replace them with others", "&eunder certain conditions").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf318\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_fishingtable")));
    }

    @Override
    public List<ItemStack> getCategoryOptions() {
        ArrayList<ItemBuilder> buttons = new ArrayList<ItemBuilder>();
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ItemBuilder globalBuilder = new ItemBuilder(Material.GRASS_BLOCK).name((globalTable != null ? "&a" : "&c") + "Global Table").stringTag(LootTableOverviewMenu.KEY_TABLE, "global");
        if (globalTable == null) {
            globalBuilder.lore("&cNo replacement table set");
        } else {
            globalBuilder.lore("&aHas replacement table: " + globalTable.getKey());
        }
        globalBuilder.appendLore("&fClick to set new replacement table", "&fShift-Click to remove replacement table");
        buttons.add(globalBuilder);
        return buttons.stream().map(ItemBuilder::get).collect(Collectors.toList());
    }

    @Override
    public void onButtonClick(InventoryClickEvent e, String storedValue, Menu openedFrom) {
        if (StringUtils.isEmpty(storedValue)) {
            return;
        }
        if (!e.isShiftClick()) {
            new ReplacementTableSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), openedFrom, table -> {
                if (storedValue.equals("global")) {
                    LootTableRegistry.setGlobalReplacementTable(table.getKey());
                }
                new LootTableOverviewMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), LootTableOverviewMenu.GLOBAL_REPLACEMENT.getId()).open();
            }).open();
        } else if (storedValue.equals("global")) {
            LootTableRegistry.setGlobalReplacementTable(null);
        }
    }
}

