/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.recipecategories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.GridRecipeEditor;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.recipecategories.RecipeCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class GridRecipeCategory
extends RecipeCategory {
    public GridRecipeCategory(int position) {
        super("crafting_table", new ItemBuilder(Material.CRAFTING_TABLE).name("&aCrafting Grid Recipes &7(&2" + CustomRecipeRegistry.getGridRecipes().size() + "&7)").lore("&fClick to access all &aCrafting grid recipes").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf304\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_recipecategory_craftingtable")));
    }

    @Override
    public List<ItemStack> getRecipeButtons() {
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
        for (DynamicGridRecipe recipe : CustomRecipeRegistry.getGridRecipes().values()) {
            String[] stringArray;
            Object object;
            boolean toolRequired;
            ArrayList<String> lore = new ArrayList<String>();
            if (recipe.isShapeless()) {
                Map<SlotEntry, Integer> contents = ItemUtils.getItemTotals(recipe.getItems().values());
                for (SlotEntry entry : contents.keySet()) {
                    int amount = contents.get(entry);
                    lore.add("&e" + amount + "&7x &e" + SlotEntry.toString(entry));
                }
            } else {
                DynamicGridRecipe.ShapeDetails details = recipe.getRecipeShapeStrings();
                for (String shapeLine : details.getShape()) {
                    lore.add("&7[&e" + (String)shapeLine + "&7]&7");
                }
                for (Character c : details.getItems().keySet()) {
                    if (details.getItems().get(c) == null) continue;
                    lore.add("&e" + c + "&7: &e" + SlotEntry.toString(details.getItems().get(c)));
                }
            }
            boolean bl = toolRequired = recipe.getToolRequirement().getRequiredToolID() >= 0 && (recipe.getToolRequirement().getToolRequirementType() != ToolRequirementType.NOT_REQUIRED || recipe.getToolRequirement().getToolRequirementType() != ToolRequirementType.NONE_MANDATORY);
            if (toolRequired) {
                switch (recipe.getToolRequirement().getToolRequirementType()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EQUAL: {
                        object = "&aTool with ID " + recipe.getToolRequirement().getRequiredToolID() + " required";
                        break;
                    }
                    case NOT_REQUIRED: {
                        object = "&aNo tool required";
                        break;
                    }
                    case NONE_MANDATORY: {
                        object = "&aNo tool is allowed to be used";
                        break;
                    }
                    case EQUAL_OR_LESSER: {
                        object = "&aTool with ID of or lesser than " + recipe.getToolRequirement().getRequiredToolID() + " required";
                        break;
                    }
                    case EQUAL_OR_GREATER: {
                        object = "&aTool with ID of or greater than " + recipe.getToolRequirement().getRequiredToolID() + " required";
                        break;
                    }
                }
            } else {
                object = "&aNo tool required";
            }
            lore.add((String)object);
            lore.add(recipe.requireValhallaTools() ? "&fRequires ValhallaMMO equipment" : "&fVanilla equipment may be used");
            lore.add(recipe.isUnlockedForEveryone() ? "&aAccessible to anyone" : "&aNeeds to be unlocked to craft");
            if (!recipe.getValidations().isEmpty()) {
                lore.add("&8&m                <>                ");
                for (String v : recipe.getValidations()) {
                    Validation validation = ValidationRegistry.getValidation(v);
                    lore.add(validation.activeDescription());
                }
            } else {
                lore.add("&fNo special conditions required");
            }
            lore.add("&8&m                <>                ");
            if (recipe.getModifiers().isEmpty()) {
                lore.add("&aNo modifiers executed");
            }
            recipe.getModifiers().forEach(m -> lore.addAll(StringUtils.separateStringIntoLines(m.getActiveDescription(), 40)));
            SlotEntry tinkerEntry = recipe.getGridTinkerEquipment();
            if (tinkerEntry == null) {
                tinkerEntry = new SlotEntry(recipe.getResult(), new MaterialChoice());
            }
            ItemBuilder itemBuilder = new ItemBuilder(recipe.tinker() ? Objects.requireNonNullElse(tinkerEntry.getItem(), new ItemStack(Material.BARRIER)) : recipe.getResult()).name("&f" + recipe.getName()).lore(lore);
            if (ExportCommand.isPrepared(recipe.getName())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "&aPrepared for export";
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = new String[]{};
            }
            icons.add(itemBuilder.prependLore(stringArray).flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE).stringTag(RecipeOverviewMenu.KEY_RECIPE, recipe.getName()).get());
        }
        icons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        return icons;
    }

    @Override
    public void onRecipeButtonClick(String recipe, Player editor) {
        DynamicGridRecipe r = CustomRecipeRegistry.getGridRecipes().get(recipe);
        if (r == null) {
            throw new IllegalArgumentException("Crafting grid recipe of this name does not exist");
        }
        new GridRecipeEditor(PlayerMenuUtilManager.getPlayerMenuUtility(editor), r).open();
    }

    @Override
    public void createNew(String name, Player editor) {
        new GridRecipeEditor(PlayerMenuUtilManager.getPlayerMenuUtility(editor), new DynamicGridRecipe(name)).open();
    }
}

