/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.hooks;

import com.github.sachin.lootin.api.LootinInventoryOpenEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.event.ValhallaLootPopulateEvent;
import me.athlaeos.valhallammo.event.ValhallaLootReplacementEvent;
import me.athlaeos.valhallammo.hooks.PluginHook;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.bukkit.plugin.Plugin;

public class LootinHook
extends PluginHook
implements Listener {
    private static final Map<UUID, me.athlaeos.valhallammo.loot.LootTable> preparedCustomTables = new HashMap<UUID, me.athlaeos.valhallammo.loot.LootTable>();
    private static final Map<UUID, LootContext> preparedContexts = new HashMap<UUID, LootContext>();
    private static final Map<UUID, LootTable> preparedVanillaTables = new HashMap<UUID, LootTable>();

    public LootinHook() {
        super("Lootin");
    }

    @Override
    public void whenPresent() {
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLootinRefill(LootinInventoryOpenEvent e) {
        Lootable l = e.getLootable();
        if (!e.isRefill() || l == null || ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.isCancelled()) {
            return;
        }
        int originalSize = e.getItems().size();
        me.athlaeos.valhallammo.loot.LootTable table = preparedCustomTables.get(e.getPlayer().getUniqueId());
        LootContext context = preparedContexts.get(e.getPlayer().getUniqueId());
        LootTable vanillaTable = preparedVanillaTables.get(e.getPlayer().getUniqueId());
        preparedCustomTables.remove(e.getPlayer().getUniqueId());
        preparedContexts.remove(e.getPlayer().getUniqueId());
        preparedVanillaTables.remove(e.getPlayer().getUniqueId());
        if (context == null) {
            return;
        }
        if (table != null) {
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.CONTAINER);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean skip = false;
                switch (loottableEvent.getPreservationType()) {
                    case CLEAR: {
                        int i;
                        e.setItems(new ArrayList());
                        for (i = 0; i < originalSize; ++i) {
                            e.getItems().add(null);
                        }
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        int i;
                        if (loottableEvent.getDrops().isEmpty()) break;
                        e.setItems(new ArrayList());
                        for (i = 0; i < originalSize; ++i) {
                            e.getItems().add(null);
                        }
                        break;
                    }
                    case KEEP: {
                        if (!loottableEvent.getDrops().isEmpty()) break;
                        skip = true;
                    }
                }
                if (!skip) {
                    ArrayList<Object> drops = new ArrayList<ItemStack>(loottableEvent.getDrops());
                    drops.addAll(e.getItems());
                    drops.removeIf(Objects::isNull);
                    for (int i = 0; i < originalSize - drops.size(); ++i) {
                        drops.add(null);
                    }
                    drops = new ArrayList(drops.stream().limit(originalSize).toList());
                    Collections.shuffle(drops);
                    e.setItems(drops);
                }
            }
        }
        ReplacementTable replacementTable = vanillaTable == null ? null : LootTableRegistry.getReplacementTable(vanillaTable.getKey());
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < e.getItems().size(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = (ItemStack)e.getItems().get(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.CONTAINER, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.CONTAINER, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                e.getItems().set(i, item);
            }
        }
    }

    public static void prepareChestOpeningForLootin(Player player, LootTable vanillaTable, me.athlaeos.valhallammo.loot.LootTable table, LootContext context) {
        preparedCustomTables.put(player.getUniqueId(), table);
        preparedContexts.put(player.getUniqueId(), context);
        preparedVanillaTables.put(player.getUniqueId(), vanillaTable);
    }
}

