/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.hooks;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.events.MythicDamageEvent;
import io.lumine.mythic.bukkit.events.MythicDropLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import io.lumine.mythic.bukkit.utils.numbers.RandomDouble;
import io.lumine.mythic.core.drops.droppables.VanillaItemDrop;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.entities.MonsterScalingManager;
import me.athlaeos.valhallammo.event.EntityUpdateLevelEvent;
import me.athlaeos.valhallammo.hooks.PluginHook;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.listeners.EntityDamagedListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MythicMobsHook
extends PluginHook {
    private Listener listener;

    public MythicMobsHook() {
        super("MythicMobs");
    }

    public Listener getListener() {
        return this.listener;
    }

    @Override
    public void whenPresent() {
        this.listener = new Listener(){

            @EventHandler
            public void mythicDropLoadEvent(MythicDropLoadEvent e) {
                if (!e.getDropName().equalsIgnoreCase("valhallammo") && !e.getDropName().equalsIgnoreCase("val")) {
                    return;
                }
                String[] split = e.getContainer().getLine().split(" ");
                String itemName = split[1];
                String amountRange = split.length > 2 ? split[2] : "1";
                ItemStack item = CustomItemRegistry.getProcessedItem(itemName);
                if (item == null) {
                    return;
                }
                e.register((IDrop)new VanillaItemDrop(e.getContainer().getLine(), e.getConfig(), (AbstractItemStack)new ItemComponentBukkitItemStack(item), new RandomDouble(amountRange)));
            }

            @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
            public void onMythicMobSpawn(MythicMobSpawnEvent event) {
                if (!event.getSpawnReason().equals((Object)SpawnReason.NATURAL)) {
                    return;
                }
                String faction = event.getMobType().getFaction();
                if (faction == null || !faction.equalsIgnoreCase("Animals")) {
                    event.setMobLevel(MonsterScalingManager.getAreaDifficultyLevel(event.getLocation(), null));
                }
            }

            @EventHandler
            public void onLevelUp(EntityUpdateLevelEvent e) {
                Entity entity = e.getEntity();
                Optional mob = MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId());
                if (mob.isEmpty() || ((ActiveMob)mob.get()).getType().getFaction() == null || ((ActiveMob)mob.get()).getType().getFaction().equalsIgnoreCase("Animals")) {
                    return;
                }
                ((ActiveMob)mob.get()).setLevel((double)e.getLevel());
            }

            @EventHandler
            public void onDamage(MythicDamageEvent e) {
                Entity entity = e.getTarget().getBukkitEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)entity;
                    if (e.getDamageMetadata().getElement() != null) {
                        EntityDamagedListener.setCustomDamageCause(e.getTarget().getUniqueId(), e.getDamageMetadata().getElement());
                    }
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)ValhallaMMO.getInstance());
    }

    public static boolean isMythicMob(Entity entity) {
        if (!ValhallaMMO.isHookFunctional(MythicMobsHook.class)) {
            return false;
        }
        return MythicBukkit.inst().getMobManager().isMythicMob(entity);
    }

    public static double getMythicMobStat(String stat, Entity entity) {
        stat = "VAL-" + (String)stat;
        if (!ValhallaMMO.isHookFunctional(MythicMobsHook.class)) {
            return 0.0;
        }
        MythicBukkit inst = MythicBukkit.inst();
        Optional mob = inst.getMobManager().getActiveMob(entity.getUniqueId());
        if (mob.isEmpty()) {
            return 0.0;
        }
        PlaceholderDouble pd = ((ActiveMob)mob.get()).getType().getStats().getOrDefault(stat, null);
        if (pd == null) {
            return 0.0;
        }
        return pd.get((SkillCaster)mob.get());
    }
}

