/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomDurabilityManager {
    private static final NamespacedKey DURABILITY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "durability");
    private static final NamespacedKey MAX_DURABILITY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "max_durability");

    public static void damage(ItemBuilder item, int damage) {
        Material baseType = item.getItem().getType();
        if (baseType.getMaxDurability() > 0 && item.getMeta().getPersistentDataContainer().has(DURABILITY, PersistentDataType.INTEGER)) {
            int maxDurability;
            int durability = (Integer)item.getMeta().getPersistentDataContainer().getOrDefault(DURABILITY, PersistentDataType.INTEGER, (Object)0);
            if (durability > (maxDurability = ((Integer)item.getMeta().getPersistentDataContainer().getOrDefault(MAX_DURABILITY, PersistentDataType.INTEGER, (Object)0)).intValue())) {
                durability = maxDurability;
            }
            durability = Math.max(0, Math.min(maxDurability, durability - damage));
            item.intTag(DURABILITY, durability);
            CustomDurabilityManager.updateLore(item);
        }
    }

    public static void setDurability(ItemBuilder item, int durability, int maxDurability) {
        Material baseType = item.getItem().getType();
        if (baseType.getMaxDurability() > 0) {
            if (durability < 0 || maxDurability < 0) {
                item.getMeta().getPersistentDataContainer().remove(DURABILITY);
                item.getMeta().getPersistentDataContainer().remove(MAX_DURABILITY);
            } else {
                item.intTag(DURABILITY, Math.min(maxDurability, durability));
                item.intTag(MAX_DURABILITY, Math.max(maxDurability, durability));
            }
            CustomDurabilityManager.updateLore(item);
        }
    }

    public static void setDurability(ItemBuilder item, double fraction) {
        ItemMeta itemMeta;
        Material baseType = item.getItem().getType();
        fraction = Math.max(0.0, Math.min(1.0, fraction));
        boolean hasCustom = item.getMeta().getPersistentDataContainer().has(DURABILITY, PersistentDataType.INTEGER);
        int maxDurability = hasCustom ? CustomDurabilityManager.getDurability(item, true) : baseType.getMaxDurability();
        int newDurability = Math.max(1, (int)Math.round(fraction * (double)maxDurability));
        if (baseType.getMaxDurability() > 0 && (itemMeta = item.getMeta()) instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            if (hasCustom) {
                CustomDurabilityManager.setDurability(item, newDurability, maxDurability);
            } else {
                d.setDamage(maxDurability - (maxDurability - newDurability));
            }
        }
    }

    public static double getDurabilityFraction(ItemBuilder item) {
        ItemMeta itemMeta;
        int maxDurability;
        Material baseType = item.getItem().getType();
        boolean hasCustom = item.getMeta().getPersistentDataContainer().has(DURABILITY, PersistentDataType.INTEGER);
        int n = maxDurability = hasCustom ? CustomDurabilityManager.getDurability(item, true) : baseType.getMaxDurability();
        if (baseType.getMaxDurability() > 0 && (itemMeta = item.getMeta()) instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            if (hasCustom) {
                return (double)CustomDurabilityManager.getDurability(item, false) / (double)maxDurability;
            }
            return (double)(maxDurability - (maxDurability - d.getDamage())) / (double)maxDurability;
        }
        return 0.0;
    }

    public static int getDurability(ItemBuilder item, boolean max) {
        ItemMeta itemMeta;
        Material baseType = item.getItem().getType();
        if (baseType.getMaxDurability() > 0 && (itemMeta = item.getMeta()) instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            boolean hasCustom = item.getMeta().getPersistentDataContainer().has(DURABILITY, PersistentDataType.INTEGER);
            if (hasCustom) {
                return Math.max(0, (Integer)item.getMeta().getPersistentDataContainer().getOrDefault(max ? MAX_DURABILITY : DURABILITY, PersistentDataType.INTEGER, (Object)0));
            }
            return max ? baseType.getMaxDurability() : baseType.getMaxDurability() - d.getDamage();
        }
        return 0;
    }

    public static boolean hasCustomDurability(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(DURABILITY, PersistentDataType.INTEGER) || meta.getPersistentDataContainer().has(MAX_DURABILITY, PersistentDataType.INTEGER);
    }

    public static void updateLore(ItemBuilder item) {
        ItemMeta itemMeta;
        Material baseType = item.getItem().getType();
        String translation = TranslationManager.getTranslation("translation_durability");
        if (baseType.getMaxDurability() > 0 && (itemMeta = item.getMeta()) instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            short maxVanillaDurability = baseType.getMaxDurability();
            int maxCustomDurability = CustomDurabilityManager.getDurability(item, true);
            int customDurability = CustomDurabilityManager.getDurability(item, false);
            double fraction = Math.max(0.0, Math.min(1.0, (double)customDurability / (double)maxCustomDurability));
            int newVanillaDurability = maxVanillaDurability - (int)Math.ceil(fraction * (double)maxVanillaDurability);
            d.setDamage(newVanillaDurability);
            if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.HIDE_DURABILITY) || !CustomDurabilityManager.hasCustomDurability(item.getMeta())) {
                ItemUtils.removeIfLoreContains(item, translation);
            } else {
                ItemUtils.replaceOrAddLore(item, translation, String.format("%s %d/%d", translation, customDurability, maxCustomDurability));
            }
        } else {
            ItemUtils.removeIfLoreContains(item, translation);
        }
    }

    public static void applyDurabilityScaling(ItemBuilder item, Scaling scaling, int quality, double minimumFraction) {
        ItemMeta itemMeta;
        Material baseMaterial = item.getItem().getType();
        if (baseMaterial.getMaxDurability() > 0 && (itemMeta = item.getMeta()) instanceof Damageable) {
            Damageable d = (Damageable)itemMeta;
            AttributeWrapper durabilityWrapper = ItemAttributesRegistry.getAttribute(item.getMeta(), "CUSTOM_MAX_DURABILITY", true);
            int defaultDurability = durabilityWrapper == null ? CustomDurabilityManager.getDurability(item, true) : (int)durabilityWrapper.getValue();
            int minimum = (int)Math.round(Math.max(1.0, minimumFraction * (double)defaultDurability));
            int newMaxDurability = Math.max(minimum, (int)Math.round(scaling.evaluate(scaling.getExpression().replace("%rating%", String.valueOf(quality)), defaultDurability)));
            double fraction = CustomDurabilityManager.hasCustomDurability(item.getMeta()) ? (double)CustomDurabilityManager.getDurability(item, false) / (double)CustomDurabilityManager.getDurability(item, true) : (double)(baseMaterial.getMaxDurability() - d.getDamage()) / (double)baseMaterial.getMaxDurability();
            fraction = Math.max(0.0, Math.min(1.0, fraction));
            int newDurability = (int)Math.ceil(fraction * (double)newMaxDurability);
            CustomDurabilityManager.setDurability(item, newDurability, newMaxDurability);
        }
    }
}

