/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MiningSpeed {
    private static final NamespacedKey SPEED_MULTIPLIER_BASE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "mining_speed_multiplier_base");
    private static final NamespacedKey SPEED_MULTIPLIER_SPECIFIC = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "mining_speed_multiplier_specific");
    private static final NamespacedKey HARDNESS_TRANSLATIONS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "mining_hardness_translations");
    private static final Map<Material, Double> defaultMultipliers = new HashMap<Material, Double>();
    private static final Map<Material, Map<Material, Double>> defaultExceptions = new HashMap<Material, Map<Material, Double>>();
    private static final NamespacedKey EMBEDDED_TOOL_KEY;

    public static void addDefaultException(double multiplier, Collection<String> blocks, Collection<String> tools) {
        for (String bS : blocks) {
            Material b = ItemUtils.stringToMaterial(bS, null);
            if (b == null) continue;
            for (String tS : tools) {
                Material t = ItemUtils.stringToMaterial(tS, null);
                if (t == null) continue;
                MiningSpeed.addDefaultException(multiplier, b, t);
            }
        }
    }

    public static void addDefaultExceptionBlocks(double multiplier, String tool, String ... blocks) {
        Material t = ItemUtils.stringToMaterial(tool, null);
        if (t == null) {
            return;
        }
        for (String bS : blocks) {
            Material b = ItemUtils.stringToMaterial(bS, null);
            if (b == null) continue;
            MiningSpeed.addDefaultException(multiplier, b, t);
        }
    }

    public static void addDefaultExceptionTools(double multiplier, String block, String ... tools) {
        Material b = ItemUtils.stringToMaterial(block, null);
        if (b == null) {
            return;
        }
        for (String tS : tools) {
            Material t = ItemUtils.stringToMaterial(tS, null);
            if (t == null) continue;
            MiningSpeed.addDefaultException(multiplier, b, t);
        }
    }

    public static void addDefaultException(double multiplier, Material block, Material tool) {
        Map exceptions = defaultExceptions.getOrDefault(tool, new HashMap());
        exceptions.put(block, multiplier);
        defaultExceptions.put(tool, exceptions);
    }

    public static void setDefaultMultiplier(double multiplier, Material ... matches) {
        for (Material m : matches) {
            defaultMultipliers.put(m, multiplier);
        }
    }

    public static void setHardnessTranslations(ItemMeta m, Map<Material, Material> translations) {
        m.getPersistentDataContainer().set(HARDNESS_TRANSLATIONS, PersistentDataType.STRING, (Object)translations.keySet().stream().map(b -> b.toString() + ":" + ((Material)translations.get(b)).toString()).collect(Collectors.joining(";")));
    }

    public static void setDefaultMultiplier(double multiplier, String ... matches) {
        MiningSpeed.setDefaultMultiplier(multiplier, ItemUtils.getMaterialSet(matches).toArray(new Material[0]));
    }

    public static double getMultiplier(ItemMeta m) {
        Material stored = ItemUtils.getStoredType(m);
        return (Double)m.getPersistentDataContainer().getOrDefault(SPEED_MULTIPLIER_BASE, PersistentDataType.DOUBLE, (Object)defaultMultipliers.getOrDefault(stored, 1.0));
    }

    public static double getMultiplier(ItemMeta m, Material b) {
        Map<Material, Double> exceptions = MiningSpeed.getExceptions(m);
        if (exceptions.containsKey(b)) {
            return exceptions.get(b);
        }
        Material stored = ItemUtils.getStoredType(m);
        AttributeWrapper miningLevelWrapper = ItemAttributesRegistry.getAttribute(m, "MINING_SPEED", false);
        if (miningLevelWrapper != null) {
            return miningLevelWrapper.getValue();
        }
        return (Double)m.getPersistentDataContainer().getOrDefault(SPEED_MULTIPLIER_BASE, PersistentDataType.DOUBLE, (Object)defaultMultipliers.getOrDefault(stored, 1.0));
    }

    public static void setMultiplier(ItemMeta m, double multiplier) {
        m.getPersistentDataContainer().set(SPEED_MULTIPLIER_BASE, PersistentDataType.DOUBLE, (Object)multiplier);
    }

    public static void addException(ItemMeta m, Material exception, double multiplier) {
        Map<Material, Double> exceptions = MiningSpeed.getExceptions(m);
        exceptions.put(exception, multiplier);
        MiningSpeed.setExceptions(m, exceptions);
    }

    public static void addHardnessTranslation(ItemMeta m, Material from, Material to) {
        Map<Material, Material> translations = MiningSpeed.getHardnessTranslations(m);
        translations.put(from, to);
        MiningSpeed.setHardnessTranslations(m, translations);
    }

    public static void setExceptions(ItemMeta m, Map<Material, Double> exceptions) {
        m.getPersistentDataContainer().set(SPEED_MULTIPLIER_SPECIFIC, PersistentDataType.STRING, (Object)exceptions.keySet().stream().map(b -> b.toString() + ":" + String.valueOf(exceptions.get(b))).collect(Collectors.joining(";")));
    }

    public static Map<Material, Double> getExceptions(ItemMeta m) {
        String stored = ItemUtils.getPDCString(SPEED_MULTIPLIER_SPECIFIC, m, "");
        HashMap<Material, Double> exceptions = new HashMap<Material, Double>();
        Material base = ItemUtils.getStoredType(m);
        if (base != null) {
            exceptions.putAll(defaultExceptions.getOrDefault(base, new HashMap()));
        }
        if (!stored.isEmpty()) {
            for (String exceptionString : stored.split(";")) {
                String[] args = exceptionString.split(":");
                try {
                    Material b = Material.valueOf((String)args[0]);
                    double multiplier = StringUtils.parseDouble(args[1]);
                    exceptions.put(b, multiplier);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return exceptions;
    }

    public static Map<Material, Material> getHardnessTranslations(ItemMeta m) {
        String stored = ItemUtils.getPDCString(HARDNESS_TRANSLATIONS, m, "");
        HashMap<Material, Material> exceptions = new HashMap<Material, Material>();
        if (!stored.isEmpty()) {
            for (String exceptionString : stored.split(";")) {
                String[] args = exceptionString.split(":");
                try {
                    Material b = Material.valueOf((String)args[0]);
                    Material t = Material.valueOf((String)args[1]);
                    exceptions.put(b, t);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return exceptions;
    }

    public static float getHardness(ItemMeta m, Block block) {
        if (BlockUtils.hasCustomHardness(block)) {
            return BlockUtils.getHardness(block);
        }
        Map<Material, Material> hardnessTranslations = MiningSpeed.getHardnessTranslations(m);
        if (hardnessTranslations.containsKey(block.getType())) {
            return hardnessTranslations.get(block.getType()).getHardness();
        }
        return BlockUtils.getHardness(block);
    }

    public static void addEmbeddedTool(ItemMeta m, ItemStack tool) {
        Collection<EmbeddedTool> embeddedTools = MiningSpeed.getEmbeddedTools(m);
        embeddedTools.add(new EmbeddedTool(tool));
        MiningSpeed.setEmbeddedTools(m, embeddedTools);
    }

    public static void addEmbeddedTool(ItemMeta m, Material tool) {
        Collection<EmbeddedTool> embeddedTools = MiningSpeed.getEmbeddedTools(m);
        embeddedTools.add(new EmbeddedTool(tool));
        MiningSpeed.setEmbeddedTools(m, embeddedTools);
    }

    public static ItemBuilder getOptimalEmbeddedTool(ItemMeta m, Block b) {
        Collection<EmbeddedTool> embeddedTools = MiningSpeed.getEmbeddedTools(m);
        return MiningSpeed.getOptimalEmbeddedTool(embeddedTools, m, b);
    }

    public static ItemBuilder getOptimalEmbeddedTool(Collection<EmbeddedTool> embeddedTools, ItemMeta m, Block b) {
        if (embeddedTools.isEmpty()) {
            return null;
        }
        ItemBuilder bestTool = null;
        float bestMiningPower = 1.0f;
        for (EmbeddedTool tool : embeddedTools) {
            float power;
            ItemBuilder item;
            if (tool.m != null) {
                item = new ItemBuilder(new ItemStack(tool.m), m);
            } else {
                if (ItemUtils.isEmpty(tool.i)) continue;
                item = new ItemBuilder(tool.i);
            }
            if (!((power = ValhallaMMO.getNms().toolPower(item.getItem(), b)) > bestMiningPower)) continue;
            bestTool = item;
            bestMiningPower = power;
        }
        return bestTool;
    }

    public static void setEmbeddedTools(ItemMeta m, Collection<EmbeddedTool> embeddedTools) {
        if (embeddedTools == null || embeddedTools.isEmpty()) {
            m.getPersistentDataContainer().remove(EMBEDDED_TOOL_KEY);
        } else {
            String encodedTools = embeddedTools.stream().map(t -> t.m != null ? t.m.toString() : ItemUtils.serialize(t.i)).collect(Collectors.joining("<splitter>"));
            m.getPersistentDataContainer().set(EMBEDDED_TOOL_KEY, PersistentDataType.STRING, (Object)encodedTools);
        }
    }

    public static Collection<EmbeddedTool> getEmbeddedTools(ItemMeta m) {
        String[] itemStrings;
        String stored = ItemUtils.getPDCString(EMBEDDED_TOOL_KEY, m, null);
        HashSet<EmbeddedTool> embeddedTools = new HashSet<EmbeddedTool>();
        if (stored == null || stored.isEmpty()) {
            return embeddedTools;
        }
        for (String s : itemStrings = stored.split("<splitter>")) {
            Material baseMaterial = Catch.catchOrElse(() -> Material.valueOf((String)s), null);
            if (baseMaterial != null) {
                embeddedTools.add(new EmbeddedTool(baseMaterial));
                continue;
            }
            ItemStack item = ItemUtils.deserialize(s);
            if (ItemUtils.isEmpty(item)) continue;
            embeddedTools.add(new EmbeddedTool(item));
        }
        return embeddedTools;
    }

    static {
        MiningSpeed.setDefaultMultiplier(2.0, "WOODEN_AXE", "WOODEN_HOE", "WOODEN_SHOVEL", "WOODEN_PICKAXE");
        MiningSpeed.setDefaultMultiplier(12.0, "GOLDEN_AXE", "GOLDEN_HOE", "GOLDEN_SHOVEL", "GOLDEN_PICKAXE");
        MiningSpeed.setDefaultMultiplier(4.0, "STONE_AXE", "STONE_HOE", "STONE_SHOVEL", "STONE_PICKAXE");
        MiningSpeed.setDefaultMultiplier(6.0, "IRON_AXE", "IRON_HOE", "IRON_SHOVEL", "IRON_PICKAXE");
        MiningSpeed.setDefaultMultiplier(8.0, "DIAMOND_AXE", "DIAMOND_HOE", "DIAMOND_SHOVEL", "DIAMOND_PICKAXE");
        MiningSpeed.setDefaultMultiplier(9.0, "NETHERITE_AXE", "NETHERITE_HOE", "NETHERITE_SHOVEL", "NETHERITE_PICKAXE");
        MiningSpeed.addDefaultExceptionTools(15.0, "COBWEB", "WOODEN_SWORD", "GOLDEN_SWORD", "STONE_SWORD", "IRON_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD");
        MiningSpeed.addDefaultExceptionTools(30.0, "BAMBOO", "WOODEN_SWORD", "GOLDEN_SWORD", "STONE_SWORD", "IRON_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD");
        MiningSpeed.addDefaultExceptionTools(30.0, "BAMBOO_SAPLING", "WOODEN_SWORD", "GOLDEN_SWORD", "STONE_SWORD", "IRON_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD");
        MiningSpeed.addDefaultException(1.5, Set.of("COCOA", "HAY_BALE", "JACK_O_LANTERN", "CARVED_PUMPKIN", "MELON", "PUMPKIN", "GLOW_LICHEN", "OAK_LEAVES", "BIRCH_LEAVES", "SPRUCE_LEAVES", "ACACIA_LEAVES", "DARK_OAK_LEAVES", "JUNGLE_LEAVES", "MANGROVE_LEAVES", "CHERRY_LEAVES", "AZALEA_LEAVES", "FLOWERING_AZALEA_LEAVES"), Set.of("WOODEN_SWORD", "GOLDEN_SWORD", "STONE_SWORD", "IRON_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD"));
        MiningSpeed.addDefaultExceptionTools(50.0, "COBWEB", "SHEARS");
        MiningSpeed.addDefaultExceptionBlocks(7.0, "SHEARS", "OAK_LEAVES", "BIRCH_LEAVES", "SPRUCE_LEAVES", "ACACIA_LEAVES", "DARK_OAK_LEAVES", "JUNGLE_LEAVES", "MANGROVE_LEAVES", "CHERRY_LEAVES", "AZALEA_LEAVES", "FLOWERING_AZALEA_LEAVES");
        MiningSpeed.addDefaultExceptionBlocks(5.0, "SHEARS", "WHITE_WOOL", "BLACK_WOOL", "BLUE_WOOL", "BROWN_WOOL", "CYAN_WOOL", "GRAY_WOOL", "GREEN_WOOL", "LIGHT_BLUE_WOOL", "LIGHT_GRAY_WOOL", "LIME_WOOL", "MAGENTA_WOOL", "ORANGE_WOOL", "PINK_WOOL", "PURPLE_WOOL", "RED_WOOL", "YELLOW_WOOL");
        EMBEDDED_TOOL_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "embedded_tools");
    }

    public static class EmbeddedTool {
        private final Material m;
        private final ItemStack i;

        public EmbeddedTool(Material m) {
            this.m = m;
            this.i = null;
        }

        public EmbeddedTool(ItemStack i) {
            this.i = i;
            this.m = null;
        }

        public Material getMaterial() {
            return this.m;
        }

        public ItemStack getItem() {
            return this.i;
        }
    }
}

