/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.arrow_attributes.implementations;

import me.athlaeos.valhallammo.item.item_attributes.ArrowBehavior;
import me.athlaeos.valhallammo.particle.implementations.GenericParticle;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import org.bukkit.Particle;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DragonFireballArrow
extends ArrowBehavior {
    public DragonFireballArrow(String name) {
        super(name);
    }

    @Override
    public void onShoot(EntityShootBowEvent e, double ... args) {
        if (args.length == 2) {
            float radius = (float)args[0];
            boolean isIncendiary = (int)args[1] == 1;
            double multiplier = AccumulativeStatManager.getCachedStats("EXPLOSION_RADIUS_MULTIPLIER", (Entity)e.getEntity(), 10000L, true);
            DragonFireball dragonFireball = (DragonFireball)e.getEntity().launchProjectile(DragonFireball.class, e.getProjectile().getVelocity());
            dragonFireball.setShooter((ProjectileSource)e.getEntity());
            dragonFireball.setYield(radius *= (float)(1.0 + multiplier));
            dragonFireball.setIsIncendiary(isIncendiary);
            AnimationUtils.trailProjectile((Projectile)dragonFireball, new GenericParticle(Particle.FLAME), 50);
            e.setProjectile((Entity)dragonFireball);
        }
    }

    @Override
    public void onHit(ProjectileHitEvent e, double ... args) {
    }

    @Override
    public void onLaunch(ProjectileLaunchEvent e, double ... args) {
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent e, double ... args) {
    }

    @Override
    public void onPickup(PlayerPickupArrowEvent e, double ... args) {
    }
}

