/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item.arrow_attributes.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.item_attributes.ArrowBehavior;
import me.athlaeos.valhallammo.listeners.EntityAttackListener;
import me.athlaeos.valhallammo.particle.implementations.GenericParticle;
import me.athlaeos.valhallammo.utility.AnimationUtils;
import org.bukkit.Particle;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.projectiles.ProjectileSource;

public class TeleportingArrow
extends ArrowBehavior {
    private final boolean combatTpPrevention = ValhallaMMO.getPluginConfig().getBoolean("tp_arrow_out_of_combat_only", true);

    public TeleportingArrow(String name) {
        super(name);
    }

    @Override
    public void onShoot(EntityShootBowEvent e, double ... args) {
        Entity entity = e.getProjectile();
        if (entity instanceof Projectile) {
            Projectile p = (Projectile)entity;
            AnimationUtils.trailProjectile(p, new GenericParticle(Particle.PORTAL), 50);
        }
    }

    @Override
    public void onHit(ProjectileHitEvent e, double ... args) {
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof LivingEntity) {
            Player p;
            LivingEntity l = (LivingEntity)projectileSource;
            if (this.combatTpPrevention && l instanceof Player && EntityAttackListener.isInCombat(p = (Player)l)) {
                return;
            }
            EnderPearl pearl = (EnderPearl)l.launchProjectile(EnderPearl.class, e.getEntity().getVelocity().normalize());
            pearl.setShooter((ProjectileSource)l);
            pearl.teleport(e.getEntity().getLocation());
            e.getEntity().remove();
        }
    }

    @Override
    public void onLaunch(ProjectileLaunchEvent e, double ... args) {
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent e, double ... args) {
    }

    @Override
    public void onPickup(PlayerPickupArrowEvent e, double ... args) {
    }
}

