/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.BlockStore;
import me.athlaeos.valhallammo.utility.BlockUtils;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private static final Collection<Location> blocksToConsiderBroken = new HashSet<Location>();
    private static final float EXPLOSION_IMMUNE_HARDNESS = 10.0f;
    private static final float EXPLOSION_IMMUNE_BLAST_RESISTANCE = 30.0f;

    public BlockListener() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskTimer((Plugin)ValhallaMMO.getInstance(), () -> {
            for (Location b : blocksToConsiderBroken) {
                BlockStore.setPlaced(b.getBlock(), false);
                BlockStore.setBreakReason(b.getBlock(), BlockStore.BreakReason.MINED);
            }
            blocksToConsiderBroken.clear();
        }, 0L, 5L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFallBlock(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            Location loc = event.getEntity().getLocation();
            BlockStore.setPlaced(loc.getBlock(), event.getTo() == fallingBlock.getBlockData().getMaterial());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        BlockStore.setPlaced(e.getBlock(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onStructureForm(StructureGrowEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getWorld().getName())) {
            return;
        }
        for (BlockState b : e.getBlocks()) {
            BlockStore.setPlaced(b.getBlock(), false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        BlockData blockData = e.getBlock().getBlockData();
        if (blockData instanceof Directional) {
            Directional d = (Directional)blockData;
            for (Block b2 : e.getBlocks().stream().map(b -> b.getRelative(d.getFacing())).collect(Collectors.toSet())) {
                BlockStore.setPlaced(b2, true);
                blocksToConsiderBroken.remove(b2.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        BlockData blockData = e.getBlock().getBlockData();
        if (blockData instanceof Directional) {
            Directional d = (Directional)blockData;
            for (Block b2 : e.getBlocks().stream().map(b -> b.getRelative(d.getFacing().getOppositeFace())).collect(Collectors.toSet())) {
                BlockStore.setPlaced(b2, true);
                blocksToConsiderBroken.remove(b2.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (e instanceof BlockMultiPlaceEvent) {
            BlockMultiPlaceEvent me = (BlockMultiPlaceEvent)e;
            me.getReplacedBlockStates().forEach(b -> BlockStore.setPlaced(b.getBlock(), true));
        } else {
            BlockData blockData = e.getBlock().getBlockData();
            if (blockData instanceof Bisected) {
                Bisected bisected = (Bisected)blockData;
                if (bisected.getHalf() == Bisected.Half.TOP) {
                    BlockStore.setPlaced(e.getBlock().getRelative(BlockFace.DOWN), true);
                    blocksToConsiderBroken.remove(e.getBlock().getRelative(BlockFace.DOWN).getLocation());
                } else {
                    BlockStore.setPlaced(e.getBlock().getRelative(BlockFace.UP), true);
                    blocksToConsiderBroken.remove(e.getBlock().getRelative(BlockFace.UP).getLocation());
                }
            } else {
                BlockStore.setPlaced(e.getBlock(), true);
                blocksToConsiderBroken.remove(e.getBlock().getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        BlockData blockData = e.getBlock().getBlockData();
        if (blockData instanceof Bisected) {
            Bisected bisected = (Bisected)blockData;
            if (bisected.getHalf() == Bisected.Half.TOP) {
                Block down = e.getBlock().getRelative(BlockFace.DOWN);
                blocksToConsiderBroken.add(down.getLocation());
            } else {
                Block up = e.getBlock().getRelative(BlockFace.UP);
                blocksToConsiderBroken.add(up.getLocation());
            }
        } else {
            blocksToConsiderBroken.add(e.getBlock().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent e) {
        TNTPrimed tnt;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof TNTPrimed) || (tnt = (TNTPrimed)entity).getSource() == null) {
            return;
        }
        Player responsible = null;
        Entity entity2 = tnt.getSource();
        if (entity2 instanceof Player) {
            Player p;
            responsible = p = (Player)entity2;
        } else {
            AbstractArrow a;
            entity2 = tnt.getSource();
            if (entity2 instanceof AbstractArrow && (entity2 = (a = (AbstractArrow)entity2).getShooter()) instanceof Player) {
                Player p;
                responsible = p = (Player)entity2;
            }
        }
        if (responsible == null) {
            return;
        }
        double multiplier = AccumulativeStatManager.getCachedStats("EXPLOSION_RADIUS_MULTIPLIER", (Entity)responsible, 10000L, true);
        e.setRadius((float)((double)e.getRadius() * (1.0 + multiplier)));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosion(BlockExplodeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        e.blockList().removeIf(b -> {
            float hardness = BlockUtils.getHardness(b);
            return hardness < 0.0f || hardness >= 10.0f || b.getType().getBlastResistance() >= 30.0f;
        });
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        e.blockList().removeIf(b -> {
            float hardness = BlockUtils.getHardness(b);
            return hardness < 0.0f || hardness >= 10.0f || b.getType().getBlastResistance() >= 30.0f;
        });
    }
}

