/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCauldronRecipe;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.event.CauldronAbsorbItemEvent;
import me.athlaeos.valhallammo.event.CauldronCompleteRecipeEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.shaded.com.jeff_media.customblockdata.CustomBlockData;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronCraftingListener
implements Listener {
    private static final NamespacedKey CAULDRON_STORAGE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "cauldron_storage");
    private static final Map<UUID, CauldronInputTick> entityThrowItemLimiter = new HashMap<UUID, CauldronInputTick>();
    private static final Map<Location, CauldronInputTick> blockThrowItemLimiter = new HashMap<Location, CauldronInputTick>();
    private static final Map<Location, CauldronCookingTask> activeCauldrons = new HashMap<Location, CauldronCookingTask>();
    private static final int cauldron_capacity = ValhallaMMO.getPluginConfig().getInt("cauldron_max_capacity", 3);
    private static final Collection<Material> blacklistedItems = ItemUtils.getMaterialSet(ValhallaMMO.getPluginConfig().getStringList("cauldron_item_blacklist"));

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemThrow(PlayerDropItemEvent e) {
        Player thrower = e.getPlayer();
        if (ValhallaMMO.isWorldBlacklisted(thrower.getWorld().getName())) {
            return;
        }
        if (!entityThrowItemLimiter.containsKey(thrower.getUniqueId())) {
            CauldronInputTick runnable = new CauldronInputTick(thrower, e.getItemDrop());
            entityThrowItemLimiter.put(thrower.getUniqueId(), runnable);
            runnable.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
        } else {
            entityThrowItemLimiter.get(thrower.getUniqueId()).resetTicks();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDispense(BlockDispenseEvent e) {
        Block b = e.getBlock();
        if (ValhallaMMO.isWorldBlacklisted(b.getWorld().getName())) {
            return;
        }
        BlockData blockData = e.getBlock().getBlockData();
        if (!(blockData instanceof Directional)) {
            return;
        }
        Directional d = (Directional)blockData;
        if (!blockThrowItemLimiter.containsKey(b.getLocation())) {
            Collection entitiesBefore = b.getWorld().getNearbyEntities(b.getRelative(d.getFacing()).getLocation().add(0.5, 0.5, 0.5), 0.5, 0.5, 0.5, i -> i instanceof Item);
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                Collection newEntities = b.getWorld().getNearbyEntities(b.getRelative(d.getFacing()).getLocation().add(0.5, 0.5, 0.5), 0.5, 0.5, 0.5, i -> i instanceof Item && !entitiesBefore.contains(i));
                Item i2 = newEntities.stream().findAny().orElse(null);
                if (i2 == null) {
                    return;
                }
                CauldronInputTick runnable = new CauldronInputTick(b, i2);
                blockThrowItemLimiter.put(b.getLocation(), runnable);
                runnable.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
            }, 1L);
        } else {
            blockThrowItemLimiter.get(b.getLocation()).resetTicks();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCauldronClick(PlayerInteractEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getClickedBlock() == null || e.getHand() != EquipmentSlot.HAND || e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock().getType().toString().contains("CAULDRON")) {
            Levelled l;
            Block b = e.getClickedBlock();
            BlockData blockData = b.getBlockData();
            if (!(blockData instanceof Levelled) || (l = (Levelled)blockData).getLevel() <= 0 || !ItemUtils.isEmpty(e.getItem()) && blacklistedItems.contains(e.getItem().getType())) {
                return;
            }
            if (e.getPlayer().isSneaking()) {
                CauldronCraftingListener.dumpCauldronContents(b);
            } else if (!ItemUtils.isEmpty(e.getItem()) && Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cooldown_cauldron_item_interact")) {
                CauldronCraftingListener.onCauldronClickedItem(e.getPlayer(), b);
                Timer.setCooldown(e.getPlayer().getUniqueId(), 100, "cooldown_cauldron_item_interact");
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        e.getBlocks().stream().filter(CauldronCraftingListener::isCustomCauldron).forEach(CauldronCraftingListener::dumpCauldronContents);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(EntityExplodeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        e.blockList().stream().filter(CauldronCraftingListener::isCustomCauldron).forEach(CauldronCraftingListener::dumpCauldronContents);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockExplodeEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName())) {
            return;
        }
        e.blockList().stream().filter(CauldronCraftingListener::isCustomCauldron).forEach(CauldronCraftingListener::dumpCauldronContents);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (CauldronCraftingListener.isCustomCauldron(e.getBlock())) {
            CauldronCraftingListener.dumpCauldronContents(e.getBlock());
        }
    }

    public static void dumpCauldronContents(Block cauldron) {
        List<ItemStack> items;
        if (activeCauldrons.containsKey(cauldron.getLocation())) {
            activeCauldrons.get(cauldron.getLocation()).stop();
        }
        if ((items = CauldronCraftingListener.getCauldronContents(cauldron)).isEmpty()) {
            return;
        }
        for (ItemStack i : items) {
            cauldron.getWorld().dropItem(cauldron.getLocation().add(0.5, 1.0, 0.5), i);
        }
        cauldron.getWorld().playSound(cauldron.getLocation().add(0.5, 1.0, 0.5), Sound.ITEM_BUCKET_EMPTY, 0.3f, 1.0f);
        CauldronCraftingListener.setCauldronContents(cauldron, null);
    }

    public static Pair<DynamicCauldronRecipe, Integer> updateCauldronRecipes(@Nullable Player responsible, Block cauldron, @Nullable ItemStack catalyst, List<ItemStack> contents, boolean toHand) {
        Pair<DynamicCauldronRecipe, Integer> r = CauldronCraftingListener.getCauldronRecipe(responsible, contents, cauldron, catalyst);
        if (r == null) {
            return null;
        }
        DynamicCauldronRecipe recipe = r.getOne();
        int count = r.getTwo();
        if (recipe.isTimedRecipe()) {
            CauldronCookingTask task = new CauldronCookingTask(responsible, cauldron, recipe, count);
            activeCauldrons.put(cauldron.getLocation(), task);
            task.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
        } else if (!ItemUtils.isEmpty(catalyst)) {
            ItemBuilder result = new ItemBuilder(recipe.tinkerCatalyst() ? catalyst : recipe.getResult());
            if (recipe.requiresValhallaTools() && !SmithingItemPropertyManager.hasSmithingQuality(ItemUtils.getItemMeta(catalyst))) {
                return null;
            }
            List<ItemStack> removedItems = ItemUtils.removeItems(contents, recipe.getIngredients(), count, recipe.getMetaRequirement().getChoice());
            if (removedItems != null) {
                DynamicItemModifier.modify(ModifierContext.builder(result).items(removedItems).count(count).crafter(responsible).executeUsageMechanics().validate().get(), recipe.getModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    return null;
                }
                CauldronCraftingListener.setCauldronContents(cauldron, contents);
                CauldronCompleteRecipeEvent completionEvent = new CauldronCompleteRecipeEvent(cauldron, recipe, responsible, result.get());
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)completionEvent);
                for (int i = 0; i < count; ++i) {
                    if (toHand && responsible != null) {
                        if (ItemUtils.isEmpty(responsible.getInventory().getItemInMainHand())) {
                            responsible.getInventory().setItemInMainHand(completionEvent.getResult());
                            continue;
                        }
                        ItemUtils.addItem(responsible, completionEvent.getResult(), true);
                        continue;
                    }
                    cauldron.getWorld().dropItem(cauldron.getLocation().add(0.5, 1.0, 0.5), completionEvent.getResult());
                }
                cauldron.getWorld().playEffect(cauldron.getLocation().add(0.5, 0.2, 0.5), Effect.EXTINGUISH, 0);
                cauldron.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("FIREWORKS_SPARK", "FIREWORK")), cauldron.getLocation().add(0.5, 0.5, 0.5), 20);
                recipe.getValidations().forEach(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        validation.execute(cauldron);
                    }
                });
            }
        }
        return r;
    }

    public static Pair<DynamicCauldronRecipe, Integer> updateCauldronRecipes(@Nullable Player responsible, Block cauldron, @Nullable ItemStack catalyst) {
        return CauldronCraftingListener.updateCauldronRecipes(responsible, cauldron, catalyst, CauldronCraftingListener.getCauldronContents(cauldron), false);
    }

    private static void onCauldronAbsorbItem(Player thrower, Block cauldron, Item item) {
        if (activeCauldrons.containsKey(cauldron.getLocation())) {
            return;
        }
        List<ItemStack> contents = CauldronCraftingListener.getCauldronContents(cauldron);
        Pair<DynamicCauldronRecipe, Integer> r = CauldronCraftingListener.updateCauldronRecipes(thrower, cauldron, item.getItemStack(), contents, false);
        if (r == null) {
            contents = CauldronCraftingListener.addItem(cauldron, item.getItemStack(), thrower);
            if (contents == null) {
                return;
            }
            item.remove();
            CauldronCraftingListener.updateCauldronRecipes(thrower, cauldron, null, contents, false);
        } else {
            DynamicCauldronRecipe recipe = r.getOne();
            int count = r.getTwo();
            if (item.getItemStack().getAmount() <= recipe.getCatalyst().getItem().getAmount() * count) {
                item.remove();
            } else {
                ItemStack i = item.getItemStack().clone();
                i.setAmount(i.getAmount() - recipe.getCatalyst().getItem().getAmount() * count);
                item.setItemStack(i);
            }
        }
    }

    private static void onCauldronClickedItem(Player clicker, Block cauldron) {
        if (activeCauldrons.containsKey(cauldron.getLocation())) {
            return;
        }
        ItemStack item = clicker.getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(item)) {
            return;
        }
        List<ItemStack> contents = CauldronCraftingListener.getCauldronContents(cauldron);
        Pair<DynamicCauldronRecipe, Integer> r = CauldronCraftingListener.getCauldronRecipe(clicker, contents, cauldron, item);
        if (r == null) {
            contents = CauldronCraftingListener.addItem(cauldron, item, clicker);
            if (contents == null) {
                return;
            }
            clicker.getInventory().setItemInMainHand(null);
            CauldronCraftingListener.updateCauldronRecipes(clicker, cauldron, null, contents, true);
        } else {
            ItemStack catalyst = item.clone();
            DynamicCauldronRecipe recipe = r.getOne();
            int count = r.getTwo();
            if (item.getAmount() <= recipe.getCatalyst().getItem().getAmount() * count) {
                item = null;
            } else {
                item.setAmount(item.getAmount() - recipe.getCatalyst().getItem().getAmount() * count);
            }
            clicker.getInventory().setItemInMainHand(item);
            CauldronCraftingListener.updateCauldronRecipes(clicker, cauldron, catalyst, contents, true);
        }
    }

    private static Pair<DynamicCauldronRecipe, Integer> getCauldronRecipe(Player crafter, List<ItemStack> contents, Block cauldron, ItemStack catalyst) {
        Levelled l;
        if (!cauldron.getType().toString().contains("CAULDRON")) {
            return null;
        }
        BlockData blockData = cauldron.getBlockData();
        if (!(blockData instanceof Levelled) || (l = (Levelled)blockData).getLevel() <= 0) {
            return null;
        }
        for (DynamicCauldronRecipe r : CustomRecipeRegistry.getCauldronRecipes().values()) {
            int count;
            if (r.getIngredients().size() > contents.size() || r.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer) && crafter == null || ValhallaMMO.isWorldBlacklisted(cauldron.getWorld().getName()) || WorldGuardHook.inDisabledRegion(cauldron.getLocation(), "vmmo-crafting-cauldron") || r.getValidations().stream().anyMatch(v -> {
                Validation validation = ValidationRegistry.getValidation(v);
                if (validation != null) {
                    return !validation.validate(cauldron);
                }
                return false;
            })) continue;
            if (!r.isTimedRecipe()) {
                if (ItemUtils.isEmpty(catalyst) || !r.getCatalyst().getOption().matches(r.getCatalyst().getItem(), catalyst) || r.getCatalyst().getItem().getAmount() > catalyst.getAmount()) continue;
                count = (int)Math.floor((double)catalyst.getAmount() / (double)r.getCatalyst().getItem().getAmount());
                ItemBuilder result = new ItemBuilder(r.tinkerCatalyst() ? catalyst : r.getResult());
                if (r.getIngredients().isEmpty()) {
                    DynamicItemModifier.modify(ModifierContext.builder(result).count(count).crafter(crafter).validate().get(), r.getModifiers());
                    if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                    return new Pair<DynamicCauldronRecipe, Integer>(r, count);
                }
                DynamicItemModifier.modify(ModifierContext.builder(result).count(count).crafter(crafter).validate().get(), r.getModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) continue;
                count = Math.min(count, ItemUtils.timesContained(contents, r.getIngredients(), r.getMetaRequirement().getChoice()));
            } else {
                count = ItemUtils.timesContained(contents, r.getIngredients(), r.getMetaRequirement().getChoice());
            }
            if (count <= 0) continue;
            return new Pair<DynamicCauldronRecipe, Integer>(r, count);
        }
        return null;
    }

    public static List<ItemStack> addItem(Block cauldron, ItemStack i, Player adder) {
        Levelled l;
        if (!cauldron.getType().toString().contains("CAULDRON")) {
            return null;
        }
        BlockData blockData = cauldron.getBlockData();
        if (!(blockData instanceof Levelled) || (l = (Levelled)blockData).getLevel() <= 0) {
            return null;
        }
        List<ItemStack> contents = CauldronCraftingListener.getCauldronContents(cauldron);
        contents.add(i);
        HashMap<ItemStack, Integer> compactedContents = new HashMap<ItemStack, Integer>();
        for (ItemStack item : contents) {
            if (ItemUtils.isEmpty(item)) continue;
            item = item.clone();
            int itemAmount = item.getAmount();
            item.setAmount(1);
            if (compactedContents.containsKey(item)) {
                compactedContents.put(item, (Integer)compactedContents.get(item) + itemAmount);
                continue;
            }
            compactedContents.put(item, itemAmount);
        }
        List<ItemStack> newContents = ItemUtils.decompressStacks(compactedContents);
        if (newContents.size() > cauldron_capacity) {
            return null;
        }
        CauldronAbsorbItemEvent event = new CauldronAbsorbItemEvent(cauldron, i, adder);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        cauldron.getWorld().playSound(cauldron.getLocation().add(0.5, 0.5, 0.5), Sound.ITEM_BUCKET_FILL, 1.0f, 1.0f);
        cauldron.getWorld().playEffect(cauldron.getLocation().add(0.5, 0.2, 0.5), Effect.EXTINGUISH, 0);
        cauldron.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("WATER_SPLASH", "SPLASH")), cauldron.getLocation().add(0.5, 0.8, 0.5), 15);
        CauldronCraftingListener.setCauldronContents(cauldron, newContents);
        return newContents;
    }

    public static List<ItemStack> getCauldronContents(Block cauldron) {
        String[] items;
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        if (!cauldron.getType().toString().contains("CAULDRON")) {
            return inventory;
        }
        if (!CustomBlockData.hasCustomBlockData(cauldron, (Plugin)ValhallaMMO.getInstance())) {
            return inventory;
        }
        CustomBlockData customBlockData = new CustomBlockData(cauldron, (Plugin)ValhallaMMO.getInstance());
        String rawContents = (String)customBlockData.getOrDefault(CAULDRON_STORAGE, PersistentDataType.STRING, "");
        if (StringUtils.isEmpty(rawContents)) {
            return inventory;
        }
        for (String itemSlot : items = rawContents.split("<itemsplitter>")) {
            ItemStack item = ItemUtils.deserialize(itemSlot);
            if (ItemUtils.isEmpty(item)) continue;
            inventory.add(item);
        }
        return inventory;
    }

    public static void setCauldronContents(Block cauldron, List<ItemStack> contents) {
        if (!cauldron.getType().toString().contains("CAULDRON")) {
            return;
        }
        CustomBlockData customBlockData = new CustomBlockData(cauldron, (Plugin)ValhallaMMO.getInstance());
        if (contents == null || contents.isEmpty()) {
            customBlockData.remove(CAULDRON_STORAGE);
        } else {
            customBlockData.set(CAULDRON_STORAGE, PersistentDataType.STRING, contents.stream().map(ItemUtils::serialize).collect(Collectors.joining("<itemsplitter>")));
        }
    }

    public static boolean isCustomCauldron(Block cauldron) {
        if (!cauldron.getType().toString().contains("CAULDRON")) {
            return false;
        }
        if (!CustomBlockData.hasCustomBlockData(cauldron, (Plugin)ValhallaMMO.getInstance())) {
            return false;
        }
        CustomBlockData customBlockData = new CustomBlockData(cauldron, (Plugin)ValhallaMMO.getInstance());
        return customBlockData.has(CAULDRON_STORAGE, PersistentDataType.STRING) && !CauldronCraftingListener.getCauldronContents(cauldron).isEmpty();
    }

    private static class CauldronInputTick
    extends BukkitRunnable {
        private int ticks = ValhallaMMO.getPluginConfig().getInt("cauldron_item_duration");
        private final UUID thrower;
        private final Location block;
        private final UUID item;

        public CauldronInputTick(Player thrower, Item item) {
            this.thrower = thrower.getUniqueId();
            this.item = item.getUniqueId();
            this.block = null;
        }

        public CauldronInputTick(Block block, Item item) {
            this.thrower = null;
            this.item = item.getUniqueId();
            this.block = block.getLocation();
        }

        public void run() {
            Player p;
            Item it;
            Entity entity = ValhallaMMO.getInstance().getServer().getEntity(this.item);
            Item i = entity instanceof Item ? (it = (Item)entity) : null;
            Player player = p = this.thrower == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(this.thrower);
            if (this.ticks > 0 && i != null && i.isValid() && p != null) {
                Block b = i.getLocation().getBlock();
                if (!b.getType().toString().contains("CAULDRON")) {
                    b = i.getLocation().add(0.0, -0.9, 0.0).getBlock();
                }
                if (b.getType().toString().contains("CAULDRON")) {
                    Levelled l;
                    BlockData blockData = b.getBlockData();
                    if (!(blockData instanceof Levelled) || (l = (Levelled)blockData).getLevel() <= 0) {
                        this.remove();
                        this.cancel();
                        return;
                    }
                    CauldronCraftingListener.onCauldronAbsorbItem(p, b, i);
                    this.remove();
                    this.cancel();
                }
            } else {
                this.remove();
                this.cancel();
            }
            --this.ticks;
        }

        private void remove() {
            if (this.thrower != null) {
                entityThrowItemLimiter.remove(this.thrower);
            } else {
                blockThrowItemLimiter.remove(this.block);
            }
        }

        public void resetTicks() {
            this.ticks = ValhallaMMO.getPluginConfig().getInt("cauldron_item_duration");
        }
    }

    private static class CauldronCookingTask
    extends BukkitRunnable {
        private int duration;
        private final UUID cooker;
        private final Location cauldron;
        private final DynamicCauldronRecipe recipe;
        private final int quantity;

        public CauldronCookingTask(@Nullable Player cooker, @NotNull Block cauldron, @NotNull DynamicCauldronRecipe recipe, int quantity) {
            this.cooker = cooker == null ? null : cooker.getUniqueId();
            this.cauldron = cauldron.getLocation();
            this.recipe = recipe;
            this.quantity = quantity;
            this.duration = recipe.getCookTime();
        }

        public void run() {
            Player p;
            Player player = p = this.cooker == null ? null : ValhallaMMO.getInstance().getServer().getPlayer(this.cooker);
            if (this.duration > 0) {
                Animation animation = AnimationRegistry.getAnimation(AnimationRegistry.BLOCK_BUBBLES.id());
                if (animation != null && p != null) {
                    animation.animate((LivingEntity)p, this.cauldron, null, this.duration);
                }
            } else {
                Block b = this.cauldron.getBlock();
                ItemBuilder result = new ItemBuilder(this.recipe.getResult());
                List<ItemStack> contents = CauldronCraftingListener.getCauldronContents(b);
                List<ItemStack> removedItems = ItemUtils.removeItems(contents, this.recipe.getIngredients(), this.quantity, this.recipe.getMetaRequirement().getChoice());
                if (removedItems != null) {
                    DynamicItemModifier.modify(ModifierContext.builder(result).count(this.quantity).items(removedItems).crafter(p).executeUsageMechanics().validate().get(), this.recipe.getModifiers());
                    if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                        b.getWorld().playEffect(this.cauldron.add(0.5, 0.2, 0.5), Effect.EXTINGUISH, 0);
                        CauldronCraftingListener.dumpCauldronContents(b);
                        this.stop();
                        return;
                    }
                    CauldronCraftingListener.setCauldronContents(b, contents);
                    CauldronCompleteRecipeEvent completionEvent = new CauldronCompleteRecipeEvent(b, this.recipe, p, result.get());
                    ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)completionEvent);
                    for (int i = 0; i < this.quantity; ++i) {
                        b.getWorld().dropItem(this.cauldron.clone().add(0.5, 0.5, 0.5), completionEvent.getResult());
                    }
                    Animation animation = AnimationRegistry.getAnimation(AnimationRegistry.BLOCK_SPARKS_EXTINGUISH.id());
                    animation.animate((LivingEntity)p, this.cauldron, null, this.duration);
                    this.recipe.getValidations().forEach(v -> {
                        Validation validation = ValidationRegistry.getValidation(v);
                        if (validation != null) {
                            validation.execute(b);
                        }
                    });
                }
                this.stop();
            }
            --this.duration;
        }

        private void stop() {
            activeCauldrons.remove(this.cauldron);
            this.cancel();
        }
    }
}

