/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.FurnaceStartSmeltListener;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Campfire;
import org.bukkit.block.Furnace;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CookingListener
implements Listener {
    private final Map<Location, Map<Integer, DynamicCookingRecipe>> campfireRecipes = new HashMap<Location, Map<Integer, DynamicCookingRecipe>>();
    private static final Collection<InventoryType> furnaces = Set.of(InventoryType.FURNACE, InventoryType.BLAST_FURNACE, InventoryType.SMOKER);
    private final Map<Location, UUID> uuidCache = new HashMap<Location, UUID>();
    public static Map<String, Pair<CampfireRecipe, DynamicCookingRecipe>> campfireRecipeCache = new HashMap<String, Pair<CampfireRecipe, DynamicCookingRecipe>>();
    public static Map<String, Pair<CookingRecipe<?>, DynamicCookingRecipe>> furnaceRecipeCache = new HashMap();

    public CookingListener() {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_18)) {
            ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new FurnaceStartSmeltListener(), (Plugin)ValhallaMMO.getInstance());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void furnaceOwnerTracker(InventoryClickEvent e) {
        Location l;
        if (furnaces.contains(e.getView().getTopInventory().getType()) && (l = e.getView().getTopInventory().getLocation()) != null) {
            BlockUtils.setOwner(l.getBlock(), e.getWhoClicked().getUniqueId());
        }
    }

    @EventHandler
    public void onCampfireClick(PlayerInteractEvent e) {
        BlockState blockState;
        Player p = e.getPlayer();
        if (e.useItemInHand() != Event.Result.DENY && e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && (blockState = e.getClickedBlock().getState()) instanceof Campfire) {
            Campfire c = (Campfire)blockState;
            if (!Timer.isCooldownPassed(p.getUniqueId(), "delay_campfire_interact_events")) {
                e.setCancelled(true);
                return;
            }
            BlockUtils.setOwner(e.getClickedBlock(), p.getUniqueId());
            int firstEmpty = this.firstEmpty(c);
            if (firstEmpty >= 0) {
                ItemStack hand = p.getInventory().getItemInMainHand();
                if (ItemUtils.isEmpty(hand)) {
                    return;
                }
                ItemBuilder handItem = new ItemBuilder(hand);
                Pair<CampfireRecipe, DynamicCookingRecipe> recipes = this.getCampfireRecipe(handItem.getItem());
                if (recipes.getOne() == null) {
                    if (ItemUtils.isEmpty(p.getInventory().getItemInOffHand())) {
                        return;
                    }
                    handItem = new ItemBuilder(p.getInventory().getItemInOffHand());
                    recipes = this.getCampfireRecipe(handItem.getItem());
                }
                if (recipes.getOne() == null) {
                    return;
                }
                if (recipes.getTwo() == null) {
                    if (CustomRecipeRegistry.getDisabledRecipes().contains(recipes.getOne().getKey())) {
                        e.setCancelled(true);
                    }
                    return;
                }
                DynamicCookingRecipe recipe = recipes.getTwo();
                PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
                if (profile == null || recipe.getValidations().stream().anyMatch(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        boolean invalid;
                        boolean bl = invalid = !validation.validate(c.getLocation().getBlock());
                        if (invalid) {
                            Utils.sendActionBar(p, validation.validationError());
                        }
                        return invalid;
                    }
                    return false;
                }) || ValhallaMMO.isWorldBlacklisted(c.getWorld().getName()) || WorldGuardHook.inDisabledRegion(c.getLocation(), "vmmo-crafting-campfire") || !p.hasPermission("valhalla.allrecipes") && !recipe.isUnlockedForEveryone() && !profile.getUnlockedRecipes().contains(recipe.getName()) && !p.hasPermission("valhalla.recipe." + recipe.getName())) {
                    e.setCancelled(true);
                    return;
                }
                Map campfireContents = this.campfireRecipes.getOrDefault(c.getLocation(), new HashMap());
                if (recipe.requireValhallaTools() && EquipmentClass.getMatchingClass(handItem.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(handItem.getMeta())) {
                    e.setCancelled(true);
                    return;
                }
                ItemBuilder result = new ItemBuilder(recipe.tinker() ? handItem.getItem() : recipe.getResult());
                DynamicItemModifier.modify(ModifierContext.builder(result).crafter(p).validate().get(), recipe.getModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    Timer.setCooldown(e.getPlayer().getUniqueId(), 500, "delay_dynamic_campfire_attempts");
                    e.setCancelled(true);
                    return;
                }
                campfireContents.put(firstEmpty, recipe);
                this.campfireRecipes.put(c.getLocation(), campfireContents);
            } else {
                e.setCancelled(true);
            }
        }
    }

    private UUID uuidFromLocation(Location l) {
        if (this.uuidCache.containsKey(l)) {
            return this.uuidCache.get(l);
        }
        UUID uuid = UUID.nameUUIDFromBytes(String.format("%d%d%d", l.getBlockX(), l.getBlockY(), l.getBlockZ()).getBytes());
        this.uuidCache.put(l, uuid);
        return uuid;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceBurn(FurnaceBurnEvent e) {
        Block b = e.getBlock();
        BlockState blockState = b.getState();
        if (!(blockState instanceof Furnace)) {
            return;
        }
        Furnace f = (Furnace)blockState;
        UUID furnaceUUID = this.uuidFromLocation(f.getLocation());
        if (!Timer.isCooldownPassed(furnaceUUID, "furnace_wait_time")) {
            e.setCancelled(true);
            return;
        }
        Pair<CookingRecipe<?>, DynamicCookingRecipe> recipes = this.getFurnaceRecipe(f.getInventory().getSmelting());
        if (recipes.getOne() == null) {
            e.setCancelled(true);
            Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
            return;
        }
        if (recipes.getTwo() == null) {
            if (CustomRecipeRegistry.getDisabledRecipes().contains(recipes.getOne().getKey())) {
                e.setCancelled(true);
                Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
            } else {
                DynamicCookingRecipe recipe = CustomRecipeRegistry.getCookingRecipesByKey().get(recipes.getOne().getKey());
                if (recipe != null) {
                    e.setCancelled(true);
                    Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
                    return;
                }
            }
            return;
        }
        if (WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), "vmmo-crafting-furnace")) {
            e.setCancelled(true);
            Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
            return;
        }
        DynamicCookingRecipe recipe = recipes.getTwo();
        if (!ItemUtils.isEmpty(f.getInventory().getSmelting())) {
            PowerProfile profile;
            ItemBuilder result = new ItemBuilder(recipe.tinker() ? f.getInventory().getSmelting() : recipe.getResult());
            Player owner = BlockUtils.getOwner(b);
            if (!(owner == null || (profile = ProfileCache.getOrCache(owner, PowerProfile.class)) != null && (owner.hasPermission("valhalla.allrecipes") || recipe.isUnlockedForEveryone() || profile.getUnlockedRecipes().contains(recipe.getName()) || owner.hasPermission("valhalla.recipe." + recipe.getName())))) {
                e.setCancelled(true);
                return;
            }
            if (recipe.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer) && owner == null || ValhallaMMO.isWorldBlacklisted(f.getWorld().getName()) || WorldGuardHook.inDisabledRegion(f.getLocation(), "vmmo-crafting-campfire") || recipe.getValidations().stream().anyMatch(v -> {
                Validation validation = ValidationRegistry.getValidation(v);
                if (validation != null) {
                    boolean invalid;
                    boolean bl = invalid = !validation.validate(f.getLocation().getBlock());
                    if (invalid && owner != null) {
                        Utils.sendActionBar(owner, validation.validationError());
                    }
                    return invalid;
                }
                return false;
            })) {
                e.setCancelled(true);
                Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
                f.getWorld().playEffect(f.getLocation(), Effect.EXTINGUISH, 0);
                return;
            }
            DynamicItemModifier.modify(ModifierContext.builder(result).crafter(owner).validate().get(), recipe.getModifiers());
            if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                if (owner != null) {
                    Timer.setCooldown(owner.getUniqueId(), 500, "delay_furnace_attempts");
                }
                e.setCancelled(true);
                Timer.setCooldown(furnaceUUID, 5000, "furnace_wait_time");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCook(BlockCookEvent e) {
        Block b = e.getBlock();
        Player owner = BlockUtils.getOwner(b);
        BlockState blockState = b.getState();
        if (blockState instanceof Campfire) {
            Campfire c = (Campfire)blockState;
            int finishedSlot = this.getFinishedCampfireCook(c);
            if (finishedSlot >= 0) {
                Map campfireRecipes = this.campfireRecipes.getOrDefault(b.getLocation(), new HashMap());
                DynamicCookingRecipe recipe = (DynamicCookingRecipe)campfireRecipes.get(finishedSlot);
                ItemStack finishedItem = c.getItem(finishedSlot);
                if (recipe == null || ItemUtils.isEmpty(finishedItem)) {
                    return;
                }
                ItemBuilder result = new ItemBuilder(recipe.tinker() ? finishedItem : recipe.getResult());
                if (ItemUtils.isEmpty(result.getItem()) || recipe.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer) && owner == null || recipe.getValidations().stream().anyMatch(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        boolean invalid;
                        boolean bl = invalid = !validation.validate(b);
                        if (invalid && owner != null) {
                            Utils.sendActionBar(owner, validation.validationError());
                        }
                        return invalid;
                    }
                    return false;
                })) {
                    c.getWorld().playEffect(c.getLocation(), Effect.EXTINGUISH, 0);
                    this.ejectCampfire(c);
                    e.setCancelled(true);
                    return;
                }
                DynamicItemModifier.modify(ModifierContext.builder(result).crafter(owner).executeUsageMechanics().validate().get(), recipe.getModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    this.ejectCampfire(c);
                    c.getWorld().playEffect(c.getLocation(), Effect.EXTINGUISH, 0);
                    e.setCancelled(true);
                    return;
                }
                int expReward = Utils.randomAverage(recipe.getExperience());
                if (expReward > 0) {
                    Location dropLocation = c.getLocation().add(0.5, 0.5, 0.5);
                    ExperienceOrb exp = (ExperienceOrb)c.getWorld().spawn(dropLocation, ExperienceOrb.class);
                    exp.setExperience(expReward);
                }
                e.setResult(result.get());
                recipe.getValidations().forEach(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        validation.execute(c.getBlock());
                    }
                });
                campfireRecipes.remove(finishedSlot);
                this.campfireRecipes.put(b.getLocation(), campfireRecipes);
            } else {
                e.setCancelled(true);
                this.ejectCampfire(c);
            }
        } else {
            BlockState finishedSlot = e.getBlock().getState();
            if (finishedSlot instanceof Furnace) {
                Furnace f = (Furnace)finishedSlot;
                Pair<CookingRecipe<?>, DynamicCookingRecipe> recipes = this.getFurnaceRecipe(f.getInventory().getSmelting());
                if (recipes.getOne() == null) {
                    e.setCancelled(true);
                    return;
                }
                if (recipes.getTwo() == null) {
                    if (CustomRecipeRegistry.getDisabledRecipes().contains(recipes.getOne().getKey())) {
                        e.setCancelled(true);
                    } else {
                        DynamicCookingRecipe recipe = CustomRecipeRegistry.getCookingRecipesByKey().get(recipes.getOne().getKey());
                        if (recipe != null) {
                            e.setCancelled(true);
                            return;
                        }
                    }
                    return;
                }
                if (WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), "vmmo-crafting-furnace")) {
                    e.setCancelled(true);
                    return;
                }
                DynamicCookingRecipe recipe = recipes.getTwo();
                if (ItemUtils.isEmpty(f.getInventory().getSmelting())) {
                    return;
                }
                ItemBuilder result = new ItemBuilder(recipe.tinker() ? f.getInventory().getSmelting() : recipe.getResult());
                if (recipe.tinker() && recipe.requireValhallaTools() && EquipmentClass.getMatchingClass(result.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(result.getMeta())) {
                    return;
                }
                if (ItemUtils.isEmpty(result.getItem()) || recipe.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer) && owner == null || recipe.getValidations().stream().anyMatch(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        boolean invalid;
                        boolean bl = invalid = !validation.validate(b);
                        if (invalid && owner != null) {
                            Utils.sendActionBar(owner, validation.validationError());
                        }
                        return invalid;
                    }
                    return false;
                })) {
                    for (Location l : MathUtils.getRandomPointsInArea(f.getLocation().add(0.5, 0.5, 0.5), 1.0, 10)) {
                        f.getWorld().spawnParticle(Particle.ASH, l, 0);
                    }
                    f.getWorld().playEffect(f.getLocation(), Effect.EXTINGUISH, 0);
                    e.setCancelled(true);
                    return;
                }
                DynamicItemModifier.modify(ModifierContext.builder(result).crafter(owner).executeUsageMechanics().validate().get(), recipe.getModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    for (Location l : MathUtils.getRandomPointsInArea(f.getLocation().add(0.5, 0.5, 0.5), 1.0, 10)) {
                        f.getWorld().spawnParticle(Particle.ASH, l, 0);
                    }
                    f.getWorld().playEffect(f.getLocation(), Effect.EXTINGUISH, 0);
                    e.setCancelled(true);
                } else {
                    e.setResult(result.get());
                    recipe.getValidations().forEach(v -> {
                        Validation validation = ValidationRegistry.getValidation(v);
                        if (validation != null) {
                            validation.execute(f.getBlock());
                        }
                    });
                }
            }
        }
    }

    private void ejectCampfire(Campfire c) {
        for (int i = 0; i < 4; ++i) {
            ItemStack item = c.getItem(i);
            if (ItemUtils.isEmpty(item)) continue;
            c.getWorld().dropItemNaturally(c.getLocation(), item);
            c.setItem(i, null);
        }
        c.update();
    }

    private int firstEmpty(Campfire campfire) {
        if (ItemUtils.isEmpty(campfire.getItem(0))) {
            return 0;
        }
        if (ItemUtils.isEmpty(campfire.getItem(1))) {
            return 1;
        }
        if (ItemUtils.isEmpty(campfire.getItem(2))) {
            return 2;
        }
        if (ItemUtils.isEmpty(campfire.getItem(3))) {
            return 3;
        }
        return -1;
    }

    private int getFinishedCampfireCook(Campfire campfire) {
        for (int i = 0; i < 4; ++i) {
            if (ItemUtils.isEmpty(campfire.getItem(i)) || campfire.getCookTime(i) <= 0 || campfire.getCookTime(i) != campfire.getCookTimeTotal(i)) continue;
            return i;
        }
        return -1;
    }

    private Pair<CampfireRecipe, DynamicCookingRecipe> getCampfireRecipe(ItemStack i) {
        if (ItemUtils.isEmpty(i)) {
            return new Pair<Object, Object>(null, null);
        }
        ItemStack clone = i.clone();
        clone.setAmount(1);
        if (campfireRecipeCache.containsKey(clone.toString())) {
            return campfireRecipeCache.get(clone.toString());
        }
        Iterator iterator = ValhallaMMO.getInstance().getServer().recipeIterator();
        CampfireRecipe found = null;
        ItemMeta meta = ItemUtils.getItemMeta(clone);
        while (iterator.hasNext()) {
            CampfireRecipe c;
            Object e = iterator.next();
            if (!(e instanceof CampfireRecipe) || !(c = (CampfireRecipe)e).getInputChoice().test(i)) continue;
            found = c;
            DynamicCookingRecipe dynamicRecipe = CustomRecipeRegistry.getCookingRecipesByKey().get(c.getKey());
            if (dynamicRecipe == null || dynamicRecipe.getType() != DynamicCookingRecipe.CookingRecipeType.CAMPFIRE || dynamicRecipe.requireValhallaTools() && EquipmentClass.getMatchingClass(meta) != null && !SmithingItemPropertyManager.hasSmithingQuality(meta) || !this.defaultChoice(dynamicRecipe.getInput()).matches(dynamicRecipe.getInput().getItem(), i)) continue;
            Pair<CampfireRecipe, DynamicCookingRecipe> match = new Pair<CampfireRecipe, DynamicCookingRecipe>(found, dynamicRecipe);
            campfireRecipeCache.put(clone.toString(), match);
            return match;
        }
        campfireRecipeCache.put(clone.toString(), new Pair<Object, Object>(found, null));
        return new Pair<Object, Object>(found, null);
    }

    private Pair<CookingRecipe<?>, DynamicCookingRecipe> getFurnaceRecipe(ItemStack i) {
        if (ItemUtils.isEmpty(i)) {
            return new Pair<Object, Object>(null, null);
        }
        ItemStack clone = i.clone();
        clone.setAmount(1);
        if (furnaceRecipeCache.get(clone.toString()) != null) {
            return furnaceRecipeCache.get(clone.toString());
        }
        ItemMeta meta = ItemUtils.getItemMeta(clone);
        Iterator iterator = ValhallaMMO.getInstance().getServer().recipeIterator();
        CookingRecipe found = null;
        while (iterator.hasNext()) {
            CookingRecipe r;
            Recipe next = (Recipe)iterator.next();
            if (!(next instanceof FurnaceRecipe) && !(next instanceof BlastingRecipe) && !(next instanceof SmokingRecipe) || !(r = (CookingRecipe)next).getInputChoice().test(i)) continue;
            found = r;
            DynamicCookingRecipe dynamicRecipe = CustomRecipeRegistry.getCookingRecipesByKey().get(r.getKey());
            if (dynamicRecipe == null || dynamicRecipe.getType() == DynamicCookingRecipe.CookingRecipeType.CAMPFIRE || dynamicRecipe.requireValhallaTools() && EquipmentClass.getMatchingClass(meta) != null && !SmithingItemPropertyManager.hasSmithingQuality(meta) || !this.defaultChoice(dynamicRecipe.getInput()).matches(dynamicRecipe.getInput().getItem(), i)) continue;
            Pair match = new Pair(found, dynamicRecipe);
            furnaceRecipeCache.put(clone.toString(), match);
            return match;
        }
        furnaceRecipeCache.put(clone.toString(), new Pair<Object, Object>(found, null));
        return new Pair<Object, Object>(found, null);
    }

    private IngredientChoice defaultChoice(SlotEntry entry) {
        return Objects.requireNonNullElse(entry.getOption(), new MaterialChoice());
    }
}

