/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.CustomDamageType;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.potioneffects.EffectResponsibility;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityResponsibilityListener
implements Listener {
    private final Map<PotionEffectType, CustomDamageType> effectToDamageTypeMapping = new HashMap<PotionEffectType, CustomDamageType>();

    public EntityResponsibilityListener() {
        this.effectToDamageTypeMapping.put(PotionEffectMappings.POISON.getPotionEffectType(), CustomDamageType.POISON);
        this.effectToDamageTypeMapping.put(PotionEffectMappings.INSTANT_DAMAGE.getPotionEffectType(), CustomDamageType.MAGIC);
        this.effectToDamageTypeMapping.put(PotionEffectMappings.INSTANT_HEALTH.getPotionEffectType(), CustomDamageType.MAGIC);
        this.effectToDamageTypeMapping.put(PotionEffectMappings.WITHER.getPotionEffectType(), CustomDamageType.NECROTIC);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFireAspect(EntityCombustByEntityEvent e) {
        Projectile a;
        ProjectileSource projectileSource;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity v = (LivingEntity)entity;
        Entity damager = e.getCombuster();
        if (damager instanceof Projectile && (projectileSource = (a = (Projectile)damager).getShooter()) instanceof Entity) {
            Entity combuster = (Entity)projectileSource;
            EffectResponsibility.markResponsible(v.getUniqueId(), combuster.getUniqueId(), CustomDamageType.FIRE, e.getDuration() * 20 + 10);
        } else {
            EffectResponsibility.markResponsible(v.getUniqueId(), damager.getUniqueId(), CustomDamageType.FIRE, e.getDuration() * 20 + 10);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPoisonSplash(PotionSplashEvent e) {
        Object object;
        ItemStack potion = e.getPotion().getItem();
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || ItemUtils.isEmpty(potion) || !((object = e.getPotion().getShooter()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)object;
        for (PotionEffect effect : e.getPotion().getEffects()) {
            CustomDamageType type = this.effectToDamageTypeMapping.get(effect.getType());
            if (type == null) continue;
            for (LivingEntity affected : e.getAffectedEntities()) {
                boolean isUndead = EntityClassification.matchesClassification(affected.getType(), EntityClassification.UNDEAD);
                if (isUndead && effect.getType() == PotionEffectMappings.INSTANT_DAMAGE.getPotionEffectType() || !isUndead && effect.getType() == PotionEffectMappings.INSTANT_HEALTH.getPotionEffectType()) continue;
                EffectResponsibility.markResponsible(affected.getUniqueId(), shooter.getUniqueId(), type, (effect.getType().isInstant() ? 0 : (int)((double)effect.getDuration() * e.getIntensity(affected))) + 10);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLingeringCloudHit(AreaEffectCloudApplyEvent e) {
        Object object;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((object = e.getEntity().getSource()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)object;
        for (PotionEffect effect : e.getEntity().getCustomEffects()) {
            CustomDamageType type = this.effectToDamageTypeMapping.get(effect.getType());
            if (type == null) continue;
            for (LivingEntity affected : e.getAffectedEntities()) {
                boolean isUndead = EntityClassification.matchesClassification(affected.getType(), EntityClassification.UNDEAD);
                if (isUndead && effect.getType() == PotionEffectMappings.INSTANT_DAMAGE.getPotionEffectType() || !isUndead && effect.getType() == PotionEffectMappings.INSTANT_HEALTH.getPotionEffectType()) continue;
                EffectResponsibility.markResponsible(affected.getUniqueId(), shooter.getUniqueId(), type, (effect.getType().isInstant() ? 0 : effect.getDuration()) + 10);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(EntityDeathEvent e) {
        EffectResponsibility.clearResponsibility(e.getEntity().getUniqueId());
    }
}

