/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class PotionEffectListener
implements Listener {
    private final NamespacedKey potionCloudKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "lingering_custom_effects");

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent e) {
        LivingEntity l;
        ItemStack potion = e.getPotion().getItem();
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || ItemUtils.isEmpty(potion)) {
            return;
        }
        Collection<PotionEffectWrapper> effects = PotionEffectRegistry.getStoredEffects(ItemUtils.getItemMeta(potion), false).values();
        ProjectileSource projectileSource = e.getEntity().getShooter();
        LivingEntity thrower = projectileSource instanceof LivingEntity ? (l = (LivingEntity)projectileSource) : null;
        double minimumIntensity = 0.0;
        if (thrower != null) {
            minimumIntensity = AccumulativeStatManager.getCachedStats("SPLASH_INTENSITY_MINIMUM", (Entity)thrower, 10000L, true);
        }
        for (LivingEntity entity : e.getAffectedEntities()) {
            double intensity = e.getIntensity(entity);
            if (minimumIntensity > 0.0) {
                e.setIntensity(entity, Math.max(intensity, minimumIntensity));
                intensity = Math.max(intensity, minimumIntensity);
            }
            for (PotionEffectWrapper effect : effects) {
                PotionEffectRegistry.addEffect(entity, thrower, new CustomPotionEffect(effect, (int)(intensity * (double)effect.getDuration()), effect.getAmplifier()), false, intensity, EntityPotionEffectEvent.Cause.POTION_SPLASH);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionLinger(LingeringPotionSplashEvent e) {
        String encodedEffects;
        ItemStack potion = e.getEntity().getItem();
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || ItemUtils.isEmpty(potion)) {
            return;
        }
        ItemMeta potionMeta = ItemUtils.getItemMeta(potion);
        if (potionMeta == null) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)projectileSource;
            float radiusMultiplier = 1.0f + (float)AccumulativeStatManager.getCachedStats("LINGERING_RADIUS_MULTIPLIER", (Entity)l, 10000L, true);
            float durationMultiplier = 1.0f + (float)AccumulativeStatManager.getCachedStats("LINGERING_DURATION_MULTIPLIER", (Entity)l, 10000L, true);
            e.getAreaEffectCloud().setRadius(e.getAreaEffectCloud().getRadius() * radiusMultiplier);
            e.getAreaEffectCloud().setDuration((int)((float)e.getAreaEffectCloud().getDuration() * durationMultiplier));
        }
        if (!StringUtils.isEmpty(encodedEffects = PotionEffectRegistry.getRawData(potionMeta, false))) {
            e.getAreaEffectCloud().getPersistentDataContainer().set(this.potionCloudKey, PersistentDataType.STRING, (Object)encodedEffects);
            e.getAreaEffectCloud().addCustomEffect(new PotionEffect(PotionEffectType.BLINDNESS, 0, 0, false, false, false), false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLingeringCloudHit(AreaEffectCloudApplyEvent e) {
        LivingEntity l;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        AreaEffectCloud cloud = e.getEntity();
        String cloudString = (String)cloud.getPersistentDataContainer().getOrDefault(this.potionCloudKey, PersistentDataType.STRING, (Object)"");
        if (StringUtils.isEmpty(cloudString)) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getSource();
        LivingEntity thrower = projectileSource instanceof LivingEntity ? (l = (LivingEntity)projectileSource) : null;
        Map<String, PotionEffectWrapper> wrappers = PotionEffectRegistry.parseRawData(cloudString);
        if (wrappers.isEmpty()) {
            return;
        }
        for (LivingEntity entity : e.getAffectedEntities()) {
            for (PotionEffectWrapper wrapper : wrappers.values()) {
                if (wrapper.isVanilla()) continue;
                int duration = (int)Math.floor((double)wrapper.getDuration() / 4.0);
                PotionEffectRegistry.addEffect(entity, thrower, new CustomPotionEffect(wrapper, duration, wrapper.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ARROW);
            }
        }
    }
}

