/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomDurabilityManager;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.plugin.Plugin;

public class SmithingTableListener
implements Listener {
    private final Map<UUID, SmithingAdditionInfo> smithingAdditionInfoMap = new HashMap<UUID, SmithingAdditionInfo>();
    public static final Map<String, Pair<SmithingRecipe, DynamicSmithingRecipe>> smithingRecipeCache = new HashMap<String, Pair<SmithingRecipe, DynamicSmithingRecipe>>();

    @EventHandler
    public void onSmithingInteract(InventoryClickEvent e) {
        boolean isTemplateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
        Inventory inventory = e.getView().getTopInventory();
        if (inventory instanceof SmithingInventory) {
            Pair<SmithingRecipe, DynamicSmithingRecipe> recipes;
            ItemBuilder addition;
            SmithingInventory s = (SmithingInventory)inventory;
            Player p = (Player)e.getWhoClicked();
            int templateIndex = isTemplateCompatible ? 0 : -1;
            int baseIndex = templateIndex + 1;
            int additionIndex = baseIndex + 1;
            int resultIndex = additionIndex + 1;
            if (e.getRawSlot() != resultIndex) {
                return;
            }
            ItemStack template = isTemplateCompatible ? s.getItem(templateIndex) : null;
            ItemStack rawBase = s.getItem(baseIndex);
            ItemBuilder base = ItemUtils.isEmpty(rawBase) ? null : new ItemBuilder(rawBase);
            ItemStack rawAddition = s.getItem(additionIndex);
            ItemBuilder itemBuilder = addition = ItemUtils.isEmpty(rawAddition) ? null : new ItemBuilder(rawAddition);
            if (base == null || addition == null) {
                return;
            }
            if (!ItemUtils.isEmpty(template)) {
                template = template.clone();
            }
            if ((recipes = this.getSmithingRecipe(template, base, addition)) == null) {
                e.setCancelled(true);
                s.setResult(null);
                return;
            }
            if (recipes.getOne() == null) {
                return;
            }
            if (recipes.getTwo() == null) {
                if (CustomRecipeRegistry.getDisabledRecipes().contains(recipes.getOne().getKey())) {
                    s.setResult(null);
                } else {
                    DynamicSmithingRecipe recipe = CustomRecipeRegistry.getSmithingRecipesByKey().get(recipes.getOne().getKey());
                    if (recipe != null) {
                        e.setCancelled(true);
                        return;
                    }
                }
                return;
            }
            DynamicSmithingRecipe r = recipes.getTwo();
            int availableSpace = ItemUtils.maxInventoryFit(p, r.getResult());
            int crafted = 1;
            if (e.isShiftClick()) {
                crafted = 64;
                if (r.consumeAddition() && addition.getItem().getAmount() < crafted) {
                    crafted = addition.getItem().getAmount();
                }
                if (base.getItem().getAmount() < crafted) {
                    crafted = base.getItem().getAmount();
                }
                if (!ItemUtils.isEmpty(template) && template.getAmount() < crafted) {
                    crafted = template.getAmount();
                }
                crafted = Math.min(crafted, availableSpace);
            }
            ItemBuilder result = new ItemBuilder(r.tinkerBase() ? base.getItem() : r.getResult());
            DynamicItemModifier.modify(ModifierContext.builder(result).crafter(p).executeUsageMechanics().validate().count(e.isShiftClick() ? crafted : 1).get(), r.getResultModifiers());
            if (ItemUtils.isEmpty(result.getItem()) || ItemUtils.isEmpty(addition.getItem())) {
                s.setResult(null);
                return;
            }
            if (!r.consumeAddition()) {
                SmithingAdditionInfo additionPrediction = this.smithingAdditionInfoMap.get(e.getWhoClicked().getUniqueId());
                if (additionPrediction != null) {
                    if (!(r.getName().equals(additionPrediction.recipe().getName()) && additionPrediction.base().isSimilar(base.getItem()) && additionPrediction.originalAddition().isSimilar(addition.getItem()))) {
                        s.setResult(null);
                        this.smithingAdditionInfoMap.remove(e.getWhoClicked().getUniqueId());
                        return;
                    }
                    DynamicItemModifier.modify(ModifierContext.builder(addition).items(result).crafter(p).executeUsageMechanics().validate().count(crafted).get(), r.getAdditionModifiers());
                    if (ItemUtils.isEmpty(result.getItem()) || ItemUtils.isEmpty(addition.getItem())) {
                        s.setResult(null);
                        return;
                    }
                    ItemStack slotItem = s.getItem(additionIndex);
                    if (!ItemUtils.isEmpty(slotItem)) {
                        slotItem.setAmount(crafted);
                    }
                    s.setResult(result.get());
                }
                ItemStack finalAddition = addition.get();
                this.smithingAdditionInfoMap.remove(e.getWhoClicked().getUniqueId());
                if (ItemUtils.isEmpty(finalAddition) || CustomFlag.hasFlag(addition.getMeta(), CustomFlag.UNCRAFTABLE) || ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    e.setCancelled(true);
                } else {
                    ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> e.getInventory().setItem(additionIndex, finalAddition), 1L);
                }
            } else {
                if (ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    e.setCancelled(true);
                }
                s.setResult(result.get());
            }
            r.getValidations().forEach(v -> {
                Validation validation = ValidationRegistry.getValidation(v);
                if (validation != null && s.getLocation() != null) {
                    validation.execute(s.getLocation().getBlock());
                }
            });
        }
    }

    @EventHandler
    public void onPrepareSmithing(PrepareSmithingEvent e) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            ItemBuilder addition;
            boolean isTemplateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
            int baseIndex = isTemplateCompatible ? 1 : 0;
            int templateIndex = baseIndex - 1;
            int additionIndex = baseIndex + 1;
            SmithingInventory s = e.getInventory();
            ItemStack template = isTemplateCompatible ? s.getItem(templateIndex) : null;
            ItemStack rawBase = s.getItem(baseIndex);
            ItemBuilder base = ItemUtils.isEmpty(rawBase) ? null : new ItemBuilder(rawBase);
            ItemStack rawAddition = s.getItem(additionIndex);
            ItemBuilder itemBuilder = addition = ItemUtils.isEmpty(rawAddition) ? null : new ItemBuilder(rawAddition);
            if (base == null || addition == null) {
                return;
            }
            Pair<SmithingRecipe, DynamicSmithingRecipe> recipes = this.getSmithingRecipe(template, base, addition);
            if (recipes == null) {
                s.setResult(null);
                return;
            }
            if (recipes.getOne() == null) {
                s.setResult(null);
                return;
            }
            if (recipes.getTwo() == null) {
                if (CustomRecipeRegistry.getDisabledRecipes().contains(recipes.getOne().getKey())) {
                    s.setResult(null);
                }
                if (!ItemUtils.isEmpty(e.getResult()) && SmithingItemPropertyManager.hasSmithingQuality(base.getMeta()) && base.getItem().getType() != e.getResult().getType()) {
                    s.setResult(null);
                } else {
                    DynamicSmithingRecipe recipe = CustomRecipeRegistry.getSmithingRecipesByKey().get(recipes.getOne().getKey());
                    if (recipe != null) {
                        s.setResult(null);
                        return;
                    }
                }
                return;
            }
            DynamicSmithingRecipe recipe = recipes.getTwo();
            ItemStack originalAddition = rawAddition.clone();
            Player p = (Player)e.getView().getPlayer();
            PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
            if (profile == null || recipe.getValidations().stream().anyMatch(v -> {
                Validation validation = ValidationRegistry.getValidation(v);
                if (validation != null && s.getLocation() != null) {
                    boolean invalid;
                    boolean bl = invalid = !validation.validate(s.getLocation().getBlock());
                    if (invalid) {
                        Utils.sendActionBar(p, validation.validationError());
                    }
                    return invalid;
                }
                return false;
            }) || ValhallaMMO.isWorldBlacklisted(p.getWorld().getName()) || WorldGuardHook.inDisabledRegion(p.getLocation(), "vmmo-crafting-smithing") || !p.hasPermission("valhalla.allrecipes") && !recipe.isUnlockedForEveryone() && !profile.getUnlockedRecipes().contains(recipe.getName()) && !p.hasPermission("valhalla.recipe." + recipe.getName())) {
                s.setResult(null);
                return;
            }
            ItemBuilder result = new ItemBuilder(recipe.tinkerBase() ? base.getItem() : recipe.getResult());
            DynamicItemModifier.modify(ModifierContext.builder(result).items(addition).crafter(p).validate().get(), recipe.getResultModifiers());
            if (ItemUtils.isEmpty(result.getItem()) || ItemUtils.isEmpty(addition.getItem())) {
                s.setResult(null);
                return;
            }
            if (!recipe.consumeAddition()) {
                DynamicItemModifier.modify(ModifierContext.builder(addition).items(result).crafter(p).validate().get(), recipe.getAdditionModifiers());
                if (ItemUtils.isEmpty(result.getItem()) || ItemUtils.isEmpty(addition.getItem())) {
                    s.setResult(null);
                    return;
                }
            }
            if (CustomDurabilityManager.getDurability(result, true) > 0 && CustomDurabilityManager.getDurability(result, false) <= 0) {
                result = null;
            }
            if (CustomDurabilityManager.getDurability(addition, true) > 0 && CustomDurabilityManager.getDurability(addition, false) <= 0) {
                result = null;
            }
            this.smithingAdditionInfoMap.put(p.getUniqueId(), new SmithingAdditionInfo(recipe, base.get(), originalAddition, addition.get()));
            s.setResult(result == null ? null : result.get());
        }, 1L);
    }

    private Pair<SmithingRecipe, DynamicSmithingRecipe> getSmithingRecipe(ItemStack template, ItemBuilder base, ItemBuilder addition) {
        if (base == null || addition == null) {
            return new Pair<Object, Object>(null, null);
        }
        String key = this.key(template, base.getItem(), addition.getItem());
        if (smithingRecipeCache.containsKey(key)) {
            return smithingRecipeCache.get(key);
        }
        boolean isTemplateCompatible = MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20);
        Iterator iterator = ValhallaMMO.getInstance().getServer().recipeIterator();
        SmithingRecipe found = null;
        while (iterator.hasNext()) {
            SmithingRecipe s;
            Object object = iterator.next();
            if (!(object instanceof SmithingRecipe) || !(s = (SmithingRecipe)object).getBase().test(base.getItem()) || !s.getAddition().test(addition.getItem())) continue;
            found = s;
            for (DynamicSmithingRecipe dynamicRecipe : CustomRecipeRegistry.getSmithingRecipes().values()) {
                if (!dynamicRecipe.getBase().getOption().matches(dynamicRecipe.getBase().getItem(), base.getItem()) || !dynamicRecipe.getAddition().getOption().matches(dynamicRecipe.getAddition().getItem(), addition.getItem()) || isTemplateCompatible && ItemUtils.isEmpty(template) || dynamicRecipe.requireValhallaTools() && (EquipmentClass.getMatchingClass(base.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(base.getMeta()) || EquipmentClass.getMatchingClass(addition.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(addition.getMeta()))) continue;
                boolean templatesMatch = !isTemplateCompatible || (dynamicRecipe.getTemplate() == null || dynamicRecipe.getTemplate().getOption() == null || ItemUtils.isEmpty(dynamicRecipe.getTemplate().getItem()) ? ItemUtils.isEmpty(template) : dynamicRecipe.getTemplate().getOption().matches(dynamicRecipe.getTemplate().getItem(), template));
                Pair<SmithingRecipe, DynamicSmithingRecipe> match = new Pair<SmithingRecipe, DynamicSmithingRecipe>(found, dynamicRecipe);
                if (!templatesMatch) continue;
                smithingRecipeCache.put(key, match);
                return match;
            }
        }
        smithingRecipeCache.put(key, new Pair<Object, Object>(found, null));
        return new Pair<Object, Object>(found, null);
    }

    private String key(ItemStack template, ItemStack base, ItemStack addition) {
        ItemStack tClone;
        ItemStack itemStack = tClone = ItemUtils.isEmpty(template) ? null : template.clone();
        if (tClone != null) {
            tClone.setAmount(1);
        }
        ItemStack bClone = base.clone();
        bClone.setAmount(1);
        ItemStack aClone = addition.clone();
        aClone.setAmount(1);
        return String.format("%s:%s:%s", ItemUtils.isEmpty(tClone) ? "" : tClone, bClone, aClone);
    }

    private record SmithingAdditionInfo(DynamicSmithingRecipe recipe, ItemStack base, ItemStack originalAddition, ItemStack newAddition) {
    }
}

