/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ReplacementEntry
implements Weighted {
    private final UUID uuid;
    private final String parentPool;
    private ItemStack replaceBy = new ItemBuilder(Material.IRON_PICKAXE).name("&fReplace me!").lore("&7I'm just a placeholder item!").get();
    private boolean tinker = false;
    private double weight = 10.0;
    private double weightBonusLuck = 0.0;
    private double weightBonusLooting = 0.0;
    private final Collection<LootPredicate> predicates = new HashSet<LootPredicate>();
    private LootTable.PredicateSelection predicateSelection = LootTable.PredicateSelection.ANY;
    private List<DynamicItemModifier> modifiers = new ArrayList<DynamicItemModifier>();

    public ReplacementEntry(UUID uuid, String parentPool) {
        this.uuid = uuid;
        this.parentPool = parentPool;
    }

    public ReplacementEntry(UUID uuid, String parentPool, ItemStack replaceBy) {
        this.uuid = uuid;
        this.parentPool = parentPool;
        this.replaceBy = replaceBy.clone();
    }

    public Collection<LootPredicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double getWeight(double luck, double fortune) {
        return this.weight + luck * this.weightBonusLuck + (fortune + this.weightBonusLooting);
    }

    public ItemStack getReplaceBy() {
        return this.replaceBy;
    }

    public List<DynamicItemModifier> getModifiers() {
        return this.modifiers;
    }

    public LootTable.PredicateSelection getPredicateSelection() {
        return this.predicateSelection;
    }

    public String getParentPool() {
        return this.parentPool;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean tinker() {
        return this.tinker;
    }

    public double getWeightBonusLooting() {
        return this.weightBonusLooting;
    }

    public double getWeightBonusLuck() {
        return this.weightBonusLuck;
    }

    public void setModifiers(List<DynamicItemModifier> modifiers) {
        this.modifiers = modifiers;
        DynamicItemModifier.sortModifiers(this.modifiers);
    }

    public void setPredicateSelection(LootTable.PredicateSelection predicateSelection) {
        this.predicateSelection = predicateSelection;
    }

    public void setReplaceBy(ItemStack replaceBy) {
        this.replaceBy = replaceBy;
    }

    public void setTinker(boolean tinker) {
        this.tinker = tinker;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setWeightBonusLooting(double weightBonusLooting) {
        this.weightBonusLooting = weightBonusLooting;
    }

    public void setWeightBonusLuck(double weightBonusLuck) {
        this.weightBonusLuck = weightBonusLuck;
    }
}

