/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.loot.predicates.implementations.BabyFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.BiomeFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.BlockMaterialFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.BlockSurroundedMaterialFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.ContextEntityKillerFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.DamageTypeDeathCauseFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.DayFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.EntityLevelFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.KilledWhileOnFireFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.KilledWhileParriedFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.LightFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.LuckFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithEquipmentTypeFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithExplosionFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithFireAspectFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithFortuneFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithPreferredToolFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithSilkTouchFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithTaggedToolFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MinedWithToolFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.MoonPhaseFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.NearbyStructureFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.RegionFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.SkillLevelFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.SkyLightFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.TimePeriodFilter;
import me.athlaeos.valhallammo.loot.predicates.implementations.WorldFilter;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import org.bukkit.Material;
import org.bukkit.block.Biome;

public class PredicateRegistry {
    private static final Map<String, LootPredicate> predicates = new HashMap<String, LootPredicate>();

    public static void register(LootPredicate predicate) {
        predicates.put(predicate.getKey(), predicate);
    }

    public static LootPredicate createPredicate(String name) {
        if (!predicates.containsKey(name)) {
            throw new IllegalArgumentException("Loot Predicate " + name + " doesn't exist");
        }
        return predicates.get(name).createNew();
    }

    public static Map<String, LootPredicate> getPredicates() {
        return predicates;
    }

    static {
        PredicateRegistry.register(new BiomeFilter(Material.HEART_OF_THE_SEA, "All Oceans", Biome.OCEAN, Biome.DEEP_OCEAN, Biome.WARM_OCEAN, Biome.LUKEWARM_OCEAN, Biome.DEEP_LUKEWARM_OCEAN, Biome.COLD_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.FROZEN_OCEAN, Biome.DEEP_FROZEN_OCEAN));
        PredicateRegistry.register(new BiomeFilter(Material.BLUE_WOOL, "Regular Oceans", Biome.OCEAN, Biome.DEEP_OCEAN));
        PredicateRegistry.register(new BiomeFilter(Material.BRAIN_CORAL, "Warm Oceans", Biome.WARM_OCEAN, Biome.LUKEWARM_OCEAN, Biome.DEEP_LUKEWARM_OCEAN));
        PredicateRegistry.register(new BiomeFilter(Material.BLUE_ICE, "Frozen Oceans", Biome.FROZEN_OCEAN, Biome.DEEP_FROZEN_OCEAN));
        PredicateRegistry.register(new BiomeFilter(Material.ICE, "Cold Oceans", Biome.COLD_OCEAN, Biome.DEEP_COLD_OCEAN));
        PredicateRegistry.register(new BiomeFilter(Material.MYCELIUM, "Mushroom Islands", Biome.MUSHROOM_FIELDS));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            PredicateRegistry.register(new BiomeFilter(Material.STONE, "All Highlands", Biome.JAGGED_PEAKS, Biome.FROZEN_PEAKS, Biome.STONY_PEAKS, Biome.MEADOW, Biome.CHERRY_GROVE, Biome.GROVE, Biome.SNOWY_SLOPES, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_FOREST));
        } else {
            PredicateRegistry.register(new BiomeFilter(Material.STONE, "All Highlands", Biome.JAGGED_PEAKS, Biome.FROZEN_PEAKS, Biome.STONY_PEAKS, Biome.MEADOW, Biome.GROVE, Biome.SNOWY_SLOPES, Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_FOREST));
        }
        PredicateRegistry.register(new BiomeFilter(Material.POWDER_SNOW_BUCKET, "Peaks", Biome.JAGGED_PEAKS, Biome.FROZEN_PEAKS, Biome.STONY_PEAKS));
        PredicateRegistry.register(new BiomeFilter(Material.BEEHIVE, "Meadow", Biome.MEADOW));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            PredicateRegistry.register(new BiomeFilter(Material.CHERRY_LEAVES, "Cherry Blossom", Biome.CHERRY_GROVE));
        }
        PredicateRegistry.register(new BiomeFilter(Material.GRAVEL, "Hills", Biome.WINDSWEPT_HILLS, Biome.WINDSWEPT_GRAVELLY_HILLS, Biome.WINDSWEPT_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.SNOW, "Snowy Hills", Biome.GROVE, Biome.SNOWY_SLOPES));
        PredicateRegistry.register(new BiomeFilter(Material.OAK_WOOD, "All Woodlands", Biome.FOREST, Biome.FLOWER_FOREST, Biome.TAIGA, Biome.OLD_GROWTH_PINE_TAIGA, Biome.OLD_GROWTH_SPRUCE_TAIGA, Biome.SNOWY_TAIGA, Biome.BIRCH_FOREST, Biome.OLD_GROWTH_BIRCH_FOREST, Biome.DARK_FOREST, Biome.JUNGLE, Biome.SPARSE_JUNGLE, Biome.BAMBOO_JUNGLE));
        PredicateRegistry.register(new BiomeFilter(Material.OAK_LOG, "Forest", Biome.FOREST, Biome.FLOWER_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.BIRCH_LOG, "Birch Forest", Biome.BIRCH_FOREST, Biome.OLD_GROWTH_BIRCH_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.SPRUCE_LOG, "Taiga", Biome.TAIGA, Biome.OLD_GROWTH_PINE_TAIGA, Biome.OLD_GROWTH_SPRUCE_TAIGA, Biome.SNOWY_TAIGA));
        PredicateRegistry.register(new BiomeFilter(Material.JUNGLE_LOG, "Jungle", Biome.JUNGLE, Biome.SPARSE_JUNGLE, Biome.BAMBOO_JUNGLE));
        PredicateRegistry.register(new BiomeFilter(Material.DARK_OAK_LOG, "Dark Oak Forest", Biome.DARK_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.ROSE_BUSH, "Flower Forest", Biome.FLOWER_FOREST));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            PredicateRegistry.register(new BiomeFilter(Material.WATER_BUCKET, "All Wetlands", Biome.RIVER, Biome.FROZEN_RIVER, Biome.SWAMP, Biome.MANGROVE_SWAMP, Biome.BEACH, Biome.SNOWY_BEACH, Biome.STONY_SHORE));
        } else {
            PredicateRegistry.register(new BiomeFilter(Material.WATER_BUCKET, "All Wetlands", Biome.RIVER, Biome.FROZEN_RIVER, Biome.SWAMP, Biome.BEACH, Biome.SNOWY_BEACH, Biome.STONY_SHORE));
        }
        PredicateRegistry.register(new BiomeFilter(Material.CLAY, "River", Biome.RIVER, Biome.FROZEN_RIVER));
        PredicateRegistry.register(new BiomeFilter(Material.SLIME_BALL, "Swamp", Biome.SWAMP, Biome.MANGROVE_SWAMP));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20)) {
            PredicateRegistry.register(new BiomeFilter(Material.MANGROVE_ROOTS, "Mangrove Swamp", Biome.MANGROVE_SWAMP));
        }
        PredicateRegistry.register(new BiomeFilter(Material.TURTLE_EGG, "Beaches", Biome.BEACH, Biome.SNOWY_BEACH));
        PredicateRegistry.register(new BiomeFilter(Material.GRANITE, "Stony Shore", Biome.STONY_SHORE));
        PredicateRegistry.register(new BiomeFilter(Material.GRASS_BLOCK, "All Flatlands", Biome.PLAINS, Biome.SUNFLOWER_PLAINS, Biome.SNOWY_PLAINS, Biome.ICE_SPIKES));
        PredicateRegistry.register(new BiomeFilter(Material.SUNFLOWER, "Plains", Biome.PLAINS, Biome.SUNFLOWER_PLAINS));
        PredicateRegistry.register(new BiomeFilter(Material.SNOW, "Snowy Plains", Biome.SNOWY_PLAINS));
        PredicateRegistry.register(new BiomeFilter(Material.PACKED_ICE, "Ice Spikes", Biome.ICE_SPIKES));
        PredicateRegistry.register(new BiomeFilter(Material.CACTUS, "All Arid Lands", Biome.DESERT, Biome.SAVANNA, Biome.SAVANNA_PLATEAU, Biome.WINDSWEPT_SAVANNA, Biome.BADLANDS, Biome.WOODED_BADLANDS, Biome.ERODED_BADLANDS));
        PredicateRegistry.register(new BiomeFilter(Material.SAND, "Desert", Biome.DESERT));
        PredicateRegistry.register(new BiomeFilter(Material.ACACIA_LOG, "Savanna", Biome.SAVANNA, Biome.SAVANNA_PLATEAU, Biome.WINDSWEPT_SAVANNA));
        PredicateRegistry.register(new BiomeFilter(Material.TERRACOTTA, "Badlands", Biome.BADLANDS, Biome.ERODED_BADLANDS, Biome.WOODED_BADLANDS));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_19)) {
            PredicateRegistry.register(new BiomeFilter(Material.IRON_ORE, "All Caves", Biome.DEEP_DARK, Biome.DRIPSTONE_CAVES, Biome.LUSH_CAVES));
        } else {
            PredicateRegistry.register(new BiomeFilter(Material.IRON_ORE, "All Caves", Biome.DRIPSTONE_CAVES, Biome.LUSH_CAVES));
        }
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_19)) {
            PredicateRegistry.register(new BiomeFilter(Material.SCULK, "Deep Dark", Biome.DEEP_DARK));
        }
        PredicateRegistry.register(new BiomeFilter(Material.DRIPSTONE_BLOCK, "Dripstone Caves", Biome.DRIPSTONE_CAVES));
        PredicateRegistry.register(new BiomeFilter(Material.MOSS_BLOCK, "Lush Caves", Biome.LUSH_CAVES));
        PredicateRegistry.register(new BiomeFilter(Material.GLOWSTONE, "All Nether Biomes", Biome.NETHER_WASTES, Biome.SOUL_SAND_VALLEY, Biome.CRIMSON_FOREST, Biome.WARPED_FOREST, Biome.BASALT_DELTAS));
        PredicateRegistry.register(new BiomeFilter(Material.NETHERRACK, "Nether Wastes", Biome.NETHER_WASTES));
        PredicateRegistry.register(new BiomeFilter(Material.SOUL_SAND, "Soul Sand Valley", Biome.SOUL_SAND_VALLEY));
        PredicateRegistry.register(new BiomeFilter(Material.NETHER_WART_BLOCK, "Crimson Forest", Biome.CRIMSON_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.WARPED_WART_BLOCK, "Warped Forest", Biome.WARPED_FOREST));
        PredicateRegistry.register(new BiomeFilter(Material.BASALT, "Basalt Deltas", Biome.BASALT_DELTAS));
        PredicateRegistry.register(new BiomeFilter(Material.END_STONE, "The End", Biome.THE_END, Biome.SMALL_END_ISLANDS, Biome.END_MIDLANDS, Biome.END_HIGHLANDS, Biome.END_BARRENS));
        PredicateRegistry.register(new BiomeFilter(Material.END_CRYSTAL, "The End (Main Island)", Biome.THE_END));
        PredicateRegistry.register(new BiomeFilter(Material.PURPUR_BLOCK, "The End (End Cities)", Biome.END_MIDLANDS, Biome.END_HIGHLANDS));
        PredicateRegistry.register(new BiomeFilter(Material.CHORUS_FLOWER, "The End (Chorus Plants)", Biome.END_HIGHLANDS));
        PredicateRegistry.register(new BlockMaterialFilter());
        PredicateRegistry.register(new BlockSurroundedMaterialFilter());
        PredicateRegistry.register(new ContextEntityKillerFilter());
        PredicateRegistry.register(new DamageTypeDeathCauseFilter());
        PredicateRegistry.register(new DayFilter());
        PredicateRegistry.register(new KilledWhileOnFireFilter());
        PredicateRegistry.register(new KilledWhileParriedFilter());
        PredicateRegistry.register(new LightFilter());
        PredicateRegistry.register(new LuckFilter());
        PredicateRegistry.register(new MinedWithEquipmentTypeFilter());
        PredicateRegistry.register(new MinedWithExplosionFilter());
        PredicateRegistry.register(new MinedWithFireAspectFilter());
        PredicateRegistry.register(new MinedWithFortuneFilter());
        PredicateRegistry.register(new MinedWithPreferredToolFilter());
        PredicateRegistry.register(new MinedWithSilkTouchFilter());
        PredicateRegistry.register(new MinedWithTaggedToolFilter());
        PredicateRegistry.register(new MinedWithToolFilter());
        PredicateRegistry.register(new MoonPhaseFilter());
        if (ValhallaMMO.isHookFunctional(WorldGuardHook.class)) {
            PredicateRegistry.register(new RegionFilter());
        }
        PredicateRegistry.register(new SkyLightFilter());
        PredicateRegistry.register(new TimePeriodFilter());
        PredicateRegistry.register(new WorldFilter());
        PredicateRegistry.register(new EntityLevelFilter());
        PredicateRegistry.register(new BabyFilter());
        PredicateRegistry.register(new NearbyStructureFilter());
        for (Skill skill : SkillRegistry.getAllSkills().values()) {
            PredicateRegistry.register(new SkillLevelFilter(skill));
        }
    }
}

