/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class BlockSurroundedMaterialFilter
extends LootPredicate {
    private static final List<AreaType> areaTypes = List.of(AreaType.values());
    private final Collection<String> materials = new HashSet<String>();
    private AreaType areaType = AreaType.TOUCHING;
    private int quantity = 5;

    @Override
    public String getKey() {
        return "surrounded_by_blocks";
    }

    @Override
    public Material getIcon() {
        return Material.BRICKS;
    }

    @Override
    public String getDisplayName() {
        return "&fSurrounded by Blocks";
    }

    @Override
    public String getDescription() {
        return "&fRequires the block to be surrounded by a minimum of the given blocks";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the block to " + (this.isInverted() ? "&cNOT&f " : "") + "be surrounded by at least " + this.quantity + " of &e" + this.materials.stream().map(b -> b.toLowerCase(Locale.US)).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new BlockSurroundedMaterialFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Pair<Integer, ItemStack> pair = new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get());
        Pair<Integer, ItemStack> pair2 = new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Block Material").lore("&6Click with item in cursor to", "&6add required block type", "&cShift-Click to clear list", "&fCurrently: ").appendLore(this.materials.isEmpty() ? List.of("&cNone, condition always passes") : this.materials.stream().map(b -> "&f>" + b.toLowerCase(Locale.US)).toList()).get());
        Integer n = 11;
        ItemBuilder itemBuilder = new ItemBuilder(Material.STRUCTURE_VOID).name("&eSelect Area Type");
        String[] stringArray = new String[3];
        stringArray[0] = "&fDetermines the scan area";
        stringArray[1] = switch (this.areaType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "&eDirectly adjacent (6 blocks)";
            case 1 -> "&eWithin 3x3 cube (26 blocks)";
            case 2 -> "&eWithin 5x5 cube (124 blocks)";
        };
        stringArray[2] = "&6Click to cycle";
        return pair.map(Set.of(pair2, new Pair<Integer, ItemStack>(n, itemBuilder.lore(stringArray).get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Block Count").lore("&f" + this.quantity, "&fWithin the given area around", "&fthe block, " + this.quantity + " blocks", "&fmust match or be similar to one of", "&fthe given materials", "&6Click to add/subtract 1", "&cShift-Click to add/subtract 10").get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 11) {
            int currentIndex = this.areaType == null ? -1 : areaTypes.indexOf((Object)this.areaType);
            currentIndex = Math.max(0, Math.min(areaTypes.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
            this.areaType = areaTypes.get(currentIndex);
        } else if (button == 12) {
            if (ItemUtils.isEmpty(e.getCursor()) && !e.isShiftClick()) {
                this.materials.add("AIR");
            } else if (!ItemUtils.isEmpty(e.getCursor()) && !e.isShiftClick()) {
                String potentialCustomType = ItemUtils.getItemType(e.getCursor());
                if (potentialCustomType.equalsIgnoreCase(e.getCursor().getType().toString())) {
                    this.materials.add(ItemUtils.getBaseMaterial(e.getCursor().getType()).toString());
                } else if (e.getCursor().getType().isBlock()) {
                    this.materials.add(potentialCustomType);
                }
            } else if (e.isShiftClick()) {
                this.materials.clear();
            }
        } else if (button == 13) {
            this.quantity = Math.max(0, this.quantity + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 10 : 1));
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (this.materials.isEmpty()) {
            return this.inverted;
        }
        Block b = context.getLocation().getBlock();
        int found = 0;
        for (Block surrounding : this.areaType.getSurroundingBlocks(b)) {
            if (this.materials.contains("AIR") && surrounding.getType().isAir()) {
                ++found;
                continue;
            }
            if (!this.materials.stream().anyMatch(m -> {
                Material vanilla = Catch.catchOrElse(() -> Material.valueOf((String)m), null);
                if (vanilla == null) {
                    return BlockUtils.getBlockType(surrounding).equalsIgnoreCase((String)m);
                }
                return ItemUtils.isSimilarMaterial(vanilla, surrounding.getType());
            })) continue;
            ++found;
        }
        return found >= this.quantity != this.inverted;
    }

    private static enum AreaType {
        TOUCHING({1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}),
        CUBE3X3(MathUtils.getOffsetsBetweenPoints(new int[]{-1, -1, -1}, new int[]{1, 1, 1}, new int[0][])),
        CUBE5X5(MathUtils.getOffsetsBetweenPoints(new int[]{-2, -2, -2}, new int[]{2, 2, 2}, new int[0][]));

        private final int[][] offsets;

        private AreaType(int[] ... offsets) {
            this.offsets = offsets;
        }

        public Collection<Block> getSurroundingBlocks(Block center) {
            HashSet<Block> blocks = new HashSet<Block>();
            for (int[] offset : this.offsets) {
                blocks.add(center.getLocation().add((double)offset[0], (double)offset[1], (double)offset[2]).getBlock());
            }
            blocks.remove(center);
            return blocks;
        }
    }
}

