/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;

public class MinedWithEquipmentTypeFilter
extends LootPredicate {
    private static final List<EquipmentClass> types = List.of(EquipmentClass.values());
    private final Collection<EquipmentClass> equipmentClasses = new HashSet<EquipmentClass>();
    private EquipmentClass equipmentClass = EquipmentClass.PICKAXE;

    @Override
    public String getKey() {
        return "mined_with_equipment_type";
    }

    @Override
    public Material getIcon() {
        return Material.IRON_PICKAXE;
    }

    @Override
    public String getDisplayName() {
        return "&fMined with Equipment Type";
    }

    @Override
    public String getDescription() {
        return "&fRequires the block to be mined with a type of equipment";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the block to " + (this.isInverted() ? "&cNOT&f " : "") + "be mined with &e" + this.equipmentClasses.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new MinedWithEquipmentTypeFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        int currentIndex = types.indexOf((Object)this.equipmentClass);
        String before = currentIndex <= 0 ? "" : String.valueOf((Object)types.get(currentIndex - 1)) + " > &e";
        String after = currentIndex + 1 >= types.size() ? "" : "&f > " + String.valueOf((Object)types.get(currentIndex + 1));
        String info = "&f" + before + String.valueOf((Object)this.equipmentClass) + after;
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Entity Type").lore(info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: ").appendLore(types.isEmpty() ? List.of("&cNone, condition always passes") : types.stream().map(b -> "&f>" + String.valueOf(b)).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.equipmentClasses.add(this.equipmentClass);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.equipmentClasses.clear();
            } else {
                if (types.isEmpty()) {
                    return;
                }
                int currentIndex = this.equipmentClass == null ? -1 : types.indexOf((Object)this.equipmentClass);
                currentIndex = Math.max(0, Math.min(types.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.equipmentClass = types.get(currentIndex);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        Player p;
        block6: {
            block5: {
                Entity entity = context.getLootedEntity();
                if (!(entity instanceof Player)) break block5;
                p = (Player)entity;
                if (!this.equipmentClasses.isEmpty()) break block6;
            }
            return this.inverted;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(tool)) {
            return this.inverted;
        }
        ItemMeta meta = ItemUtils.getItemMeta(tool);
        if (meta == null) {
            return this.inverted;
        }
        return this.equipmentClasses.contains((Object)EquipmentClass.getMatchingClass(meta)) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.BREAK;
    }
}

