/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.MoonPhase;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class MoonPhaseFilter
extends LootPredicate {
    private final Collection<MoonPhase> phases = new HashSet<MoonPhase>();
    private MoonPhase phase = null;

    @Override
    public String getKey() {
        return "moon_phase";
    }

    @Override
    public Material getIcon() {
        return Material.END_STONE;
    }

    @Override
    public String getDisplayName() {
        return "&fMoon Phase";
    }

    @Override
    public String getDescription() {
        return "&fRequires the world to have a specific moon phase. ";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the world's moon phase to " + (this.isInverted() ? "&cNOT&f " : "") + "be in one of &e" + this.phases.stream().map(Enum::toString).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new MoonPhaseFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        int currentIndex;
        List<MoonPhase> phases = List.of(MoonPhase.values());
        if (this.phase == null) {
            this.phase = phases.get(0);
        }
        String before = (currentIndex = phases.indexOf((Object)this.phase)) <= 0 ? "" : String.valueOf((Object)phases.get(currentIndex - 1)) + " > &e";
        String after = currentIndex + 1 >= phases.size() ? "" : "&f > " + String.valueOf((Object)phases.get(currentIndex + 1));
        String info = "&f" + before + String.valueOf((Object)this.phase) + after;
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Phase").lore(info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: ").appendLore(phases.isEmpty() ? List.of("&cNone, condition always passes") : phases.stream().map(b -> "&f>" + String.valueOf(b)).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.phases.add(this.phase);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.phases.clear();
            } else {
                List<MoonPhase> phases = List.of(MoonPhase.values());
                if (phases.isEmpty()) {
                    return;
                }
                int currentIndex = this.phase == null ? -1 : phases.indexOf((Object)this.phase);
                currentIndex = Math.max(0, Math.min(phases.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.phase = phases.get(currentIndex);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (this.phases.isEmpty() || context.getLocation().getWorld() == null) {
            return this.inverted;
        }
        return this.phases.contains((Object)MoonPhase.getPhase(context.getLocation().getWorld())) != this.inverted;
    }
}

