/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class RegionFilter
extends LootPredicate {
    private final Collection<String> regions = new HashSet<String>();
    private String region = null;

    @Override
    public String getKey() {
        return "region";
    }

    @Override
    public Material getIcon() {
        return Material.RED_BANNER;
    }

    @Override
    public String getDisplayName() {
        return "&fRegion";
    }

    @Override
    public String getDescription() {
        return "&fRequires the environment to be within one or several regions";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the environment to " + (this.isInverted() ? "&cNOT&f " : "") + "be in one of &e" + String.join((CharSequence)", ", this.regions);
    }

    @Override
    public LootPredicate createNew() {
        return new RegionFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Object info;
        if (!ValhallaMMO.isHookFunctional(WorldGuardHook.class)) {
            return new HashMap<Integer, ItemStack>();
        }
        ArrayList<String> regions = new ArrayList<String>(WorldGuardHook.getRegions());
        if (regions.isEmpty()) {
            info = "&cNo regions found";
        } else {
            int currentIndex;
            if (this.region == null) {
                this.region = (String)regions.get(0);
            }
            String before = (currentIndex = regions.indexOf(this.region)) <= 0 ? "" : (String)regions.get(currentIndex - 1) + " > &e";
            String after = currentIndex + 1 >= regions.size() ? "" : "&f > " + (String)regions.get(currentIndex + 1);
            info = "&f" + before + this.region + after;
        }
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").appendLore(regions.isEmpty() ? List.of("&cNone, condition always passes") : regions.stream().map(b -> "&f>" + b).toList()).get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.GRASS_BLOCK).name("&eSelect Region").lore(new String[]{info, "&6Click to cycle", "&6Shift-Click to add to selection", "&cMiddle-Click to clear selection", "&fCurrently: "}).appendLore(regions.isEmpty() ? List.of("&cNone, condition always passes") : regions.stream().map(b -> "&f>" + b).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (!ValhallaMMO.isHookFunctional(WorldGuardHook.class)) {
            return;
        }
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (e.isShiftClick()) {
                this.regions.add(this.region);
            } else if (e.getClick() == ClickType.MIDDLE) {
                this.regions.clear();
            } else {
                ArrayList<String> regions = new ArrayList<String>(WorldGuardHook.getRegions());
                if (regions.isEmpty()) {
                    return;
                }
                int currentIndex = this.region == null ? -1 : regions.indexOf(this.region);
                currentIndex = Math.max(0, Math.min(regions.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
                this.region = (String)regions.get(currentIndex);
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        if (!ValhallaMMO.isHookFunctional(WorldGuardHook.class)) {
            return true;
        }
        if (this.regions.isEmpty()) {
            return true;
        }
        return this.regions.stream().anyMatch(r -> WorldGuardHook.isInRegion(context.getLocation(), r)) != this.inverted;
    }
}

