/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class SkyLightFilter
extends LootPredicate {
    private int from = 0;
    private int to = 15;

    @Override
    public String getKey() {
        return "sky_light";
    }

    @Override
    public Material getIcon() {
        return Material.GLOWSTONE;
    }

    @Override
    public String getDisplayName() {
        return "&fSky Light";
    }

    @Override
    public String getDescription() {
        return "&fRequires environment to be between specific sky light level values";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the sky light level to " + (this.isInverted() ? "&cNOT&f " : "") + "be between &e" + this.from + " &fand &e" + this.to;
    }

    @Override
    public LootPredicate createNew() {
        return new SkyLightFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.LIGHT).name("&eSelect From").lore("&eIs currently " + this.from, "&fSky Light must " + (this.isInverted() ? "&cNOT&f " : "") + "be between", String.format("&f%d and %d", this.from, this.to), "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 5").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.LIGHT).name("&eSelect To").lore("&eIs currently " + this.to, "&fSky Light must " + (this.isInverted() ? "&cNOT&f " : "") + "be between", String.format("&f%d and %d", this.from, this.to), "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 5").get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 11) {
            this.from = Math.max(0, Math.max(Math.min(15, this.to), this.from + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1)));
        } else if (button == 13) {
            this.to = Math.max(0, Math.min(Math.min(15, this.from), this.to + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1)));
        }
    }

    @Override
    public boolean test(LootContext context) {
        byte lightLevel = context.getLocation().getBlock().getLightFromSky();
        return (lightLevel >= this.from && lightLevel <= this.to) != this.inverted;
    }
}

