/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Crafter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.inventory.CrafterInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class CrafterCraftListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraft(CrafterCraftEvent e) {
        if (e.getRecipe() instanceof ShapedRecipe || e.getRecipe() instanceof ShapelessRecipe) {
            DynamicGridRecipe recipe = CustomRecipeRegistry.getGridRecipesByKey().get(e.getRecipe().getKey());
            if (recipe == null) {
                return;
            }
            if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), "vmmo-crafting-craftingtable")) {
                e.setCancelled(true);
                return;
            }
            if (recipe.getModifiers().stream().anyMatch(DynamicItemModifier::requiresPlayer)) {
                e.setCancelled(true);
            } else {
                Crafter c;
                Block crafter = e.getBlock();
                BlockState blockState = crafter.getState();
                if (!(blockState instanceof Crafter) || !((blockState = (c = (Crafter)blockState).getInventory()) instanceof CrafterInventory)) {
                    return;
                }
                CrafterInventory ci = (CrafterInventory)blockState;
                ItemStack result = this.verifyIngredients(recipe, ci.getContents());
                if (ItemUtils.isEmpty(result)) {
                    Pair<DynamicGridRecipe, ItemStack> corrected = this.correctRecipe(e.getBlock(), recipe, ci.getContents());
                    if (corrected == null) {
                        e.setCancelled(true);
                        return;
                    }
                    recipe = corrected.getOne();
                    result = corrected.getTwo().clone();
                }
                ItemBuilder prepareResultBuilder = new ItemBuilder(result);
                DynamicItemModifier.modify(ModifierContext.builder(prepareResultBuilder).items(ci.getContents()).validate().get(), recipe.getModifiers());
                if (CustomFlag.hasFlag(prepareResultBuilder.getMeta(), CustomFlag.UNCRAFTABLE)) {
                    e.setCancelled(true);
                    return;
                }
                e.setResult(prepareResultBuilder.get());
            }
        }
    }

    private ItemStack verifyIngredients(DynamicGridRecipe recipe, ItemStack[] matrix) {
        ItemBuilder result = new ItemBuilder(recipe.getResult().clone());
        if (!recipe.isUnlockedForEveryone()) {
            return null;
        }
        if (recipe.tinker()) {
            SlotEntry tinkerEntry = recipe.getGridTinkerEquipment();
            for (ItemStack slot : matrix) {
                if (ItemUtils.isEmpty(slot)) continue;
                ItemBuilder builder = new ItemBuilder(slot);
                if (recipe.requireValhallaTools() && EquipmentClass.getMatchingClass(builder.getMeta()) != null && !SmithingItemPropertyManager.hasSmithingQuality(builder.getMeta())) {
                    return null;
                }
                if (!this.defaultChoice(tinkerEntry).matches(tinkerEntry.getItem(), slot)) continue;
                result = new ItemBuilder(slot.clone());
                break;
            }
        }
        ArrayList<SlotEntry> allIngredients = new ArrayList<SlotEntry>(recipe.getItems().values());
        SlotEntry toolEntry = recipe.getItems().get(recipe.getToolIndex());
        block1: for (ItemStack slot : matrix) {
            if (ItemUtils.isEmpty(slot)) continue;
            ItemBuilder builder = new ItemBuilder(slot);
            for (SlotEntry entry : new ArrayList<SlotEntry>(allIngredients)) {
                IngredientChoice choice;
                if (toolEntry != null) {
                    if (recipe.getToolRequirement().getToolRequirementType() == ToolRequirementType.NONE_MANDATORY) {
                        if (ToolRequirementType.getToolID(builder.getMeta()) >= 0) {
                            return null;
                        }
                    } else if (recipe.getToolRequirement().getToolRequirementType() != ToolRequirementType.NOT_REQUIRED && recipe.getToolRequirement().getRequiredToolID() >= 0 && recipe.getToolRequirement().canCraft(ToolRequirementType.getToolID(builder.getMeta()))) {
                        allIngredients.removeIf(e -> e.isSimilar(entry));
                        continue;
                    }
                }
                if (!(choice = this.defaultChoice(entry)).matches(entry.getItem(), slot) || !entry.isSimilar(entry) || !allIngredients.remove(entry)) continue;
                continue block1;
            }
        }
        if (!allIngredients.isEmpty()) {
            return null;
        }
        return result.get();
    }

    private IngredientChoice defaultChoice(SlotEntry entry) {
        return Objects.requireNonNullElse(entry.getOption(), new MaterialChoice());
    }

    private Pair<DynamicGridRecipe, ItemStack> correctRecipe(Block crafter, DynamicGridRecipe original, ItemStack[] grid) {
        int ingredients = original.getItems().size();
        ItemStack originalCorrect = this.verifyIngredients(original, grid);
        if (!ItemUtils.isEmpty(originalCorrect)) {
            return new Pair<DynamicGridRecipe, ItemStack>(original, originalCorrect);
        }
        for (DynamicGridRecipe recipe : (Collection)CustomRecipeRegistry.getGridRecipesByIngredientQuantity().getOrDefault(ingredients, new HashSet())) {
            ItemStack result;
            if (recipe.getName().equals(original.getName()) || !original.isShapeless() && !recipe.isShapeless() && !this.matchesShape(original, recipe) || ItemUtils.isEmpty(result = this.verifyIngredients(recipe, grid))) continue;
            return new Pair<DynamicGridRecipe, ItemStack>(recipe, result);
        }
        return null;
    }

    private boolean matchesShape(DynamicGridRecipe d1, DynamicGridRecipe d2) {
        String[] shape2;
        if (d1.isShapeless() || d2.isShapeless()) {
            return false;
        }
        String[] shape1 = d1.getRecipeShapeStrings().getShape();
        if (shape1.length != (shape2 = d2.getRecipeShapeStrings().getShape()).length) {
            return false;
        }
        if (shape1.length == 0) {
            return false;
        }
        boolean inverse = false;
        int index = 0;
        block0: for (int i = 0; i < shape1.length * 2 && index < shape1.length; ++i) {
            String s2;
            String s1 = shape1[index];
            String string = s2 = inverse ? new StringBuilder(shape2[index]).reverse().toString() : shape2[index];
            if (s1.length() != s2.length()) {
                return false;
            }
            char[] s1Chars = s1.toCharArray();
            char[] s2Chars = s2.toCharArray();
            for (int c = 0; c < s1Chars.length; ++c) {
                if (s1Chars[c] == ' ' && s2Chars[c] == ' ' || s1Chars[c] != ' ' && s2Chars[c] != ' ') continue;
                if (!inverse) {
                    inverse = true;
                    index = 0;
                    continue block0;
                }
                return false;
            }
            ++index;
        }
        return true;
    }
}

